/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.boot;

import com.caucho.boot.BootClusterConfig;
import com.caucho.boot.OpenPort;
import com.caucho.boot.WatchdogArgs;
import com.caucho.boot.WatchdogChildTask;
import com.caucho.boot.WatchdogConfig;
import com.caucho.config.program.ConfigProgram;
import com.caucho.env.service.ResinSystem;
import com.caucho.env.shutdown.ExitCode;
import com.caucho.management.server.AbstractManagedObject;
import com.caucho.management.server.WatchdogMXBean;
import com.caucho.util.CurrentTime;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.concurrent.atomic.AtomicReference;

class WatchdogChild {
    private static final L10N L = new L10N(WatchdogChild.class);
    private static final long MINUTE = 60000L;
    private static final long HOUR = 3600000L;
    private static final long DAY = 86400000L;
    private final String _id;
    private final ResinSystem _system;
    private final WatchdogConfig _config;
    private final WatchdogAdmin _admin;
    private AtomicReference<WatchdogChildTask> _taskRef = new AtomicReference();
    private boolean _isConsole;
    private Date _initialStartTime;
    private Date _lastStartTime;
    private int _startCount;

    WatchdogChild(String id, ResinSystem system, WatchdogArgs args, Path rootDirectory, BootClusterConfig cluster, int index) {
        this(system, new WatchdogConfig(id, cluster, args, rootDirectory, index));
    }

    WatchdogChild(ResinSystem system, WatchdogConfig config) {
        this._id = config.getId();
        this._config = config;
        this._admin = new WatchdogAdmin();
        this._system = system;
    }

    public String getId() {
        return this._id;
    }

    WatchdogArgs getArgs() {
        return this._config.getArgs();
    }

    String[] getArgv() {
        return this._config.getArgv();
    }

    public WatchdogConfig getConfig() {
        return this._config;
    }

    public Path getJavaHome() {
        return this._config.getJavaHome();
    }

    public String getJavaExe() {
        return this._config.getJavaExe();
    }

    public String getJvmMode() {
        return this._config.getJvmMode();
    }

    public ArrayList<String> getJvmArgs() {
        return this._config.getJvmArgs();
    }

    public ArrayList<String> getJvmClasspath() {
        return this._config.getJvmClasspath();
    }

    public String getSystemClassLoader() {
        return this._config.getSystemClassLoader();
    }

    public String getUserName() {
        return this._config.getUserName();
    }

    public String getGroupName() {
        return this._config.getGroupName();
    }

    public boolean isConsole() {
        return this._isConsole;
    }

    public Path getLogPath() {
        return this._config.getLogPath();
    }

    public long getShutdownWaitTime() {
        return this._config.getShutdownWaitTime();
    }

    public int getWatchdogPort() {
        return this._config.getWatchdogPort();
    }

    public String getWatchdogAddress() {
        return this._config.getWatchdogAddress();
    }

    Iterable<OpenPort> getPorts() {
        return this._config.getPorts();
    }

    Path getChroot() {
        return this._config.getChroot();
    }

    Path getPwd() {
        return this._config.getPwd();
    }

    Path getResinHome() {
        return this._config.getResinHome();
    }

    Path getResinRoot() {
        return this._config.getResinRoot();
    }

    Path getResinConf() {
        return this._config.getResinConf();
    }

    ConfigProgram getStdoutLog() {
        if (this._config.getCluster() != null) {
            return this._config.getCluster().getStdoutLog();
        }
        return null;
    }

    boolean isElasticServer() {
        return this._config.isElastic();
    }

    int getElasticServerPort() {
        return this._config.getElasticServerPort();
    }

    String getElasticServerCluster() {
        return this._config.getElasticServerCluster();
    }

    boolean hasXmx() {
        return this._config.hasXmx();
    }

    boolean hasXss() {
        return this._config.hasXss();
    }

    boolean is64bit() {
        return this._config.is64bit();
    }

    public String getState() {
        WatchdogChildTask task = this._taskRef.get();
        if (task == null) {
            return "inactive";
        }
        return task.getState();
    }

    int getPid() {
        WatchdogChildTask task = this._taskRef.get();
        if (task != null) {
            return task.getPid();
        }
        return 0;
    }

    String getUptimeString() {
        long uptime = 0L;
        WatchdogChildTask task = this._taskRef.get();
        if (task != null) {
            uptime = task.getUptime();
        }
        if (uptime <= 0L) {
            return "--";
        }
        long d = uptime / 86400000L;
        StringBuilder sb = new StringBuilder();
        sb.append(d + " day" + (d == 1L ? "" : "s"));
        long h = uptime % 86400000L / 3600000L;
        sb.append(" ").append(h / 10L).append(h % 10L).append("h");
        long m = uptime % 3600000L / 60000L;
        sb.append(m / 10L).append(m % 10L);
        return sb.toString();
    }

    boolean isRestart() {
        WatchdogChildTask task = this._taskRef.get();
        if (task != null) {
            return task.isRestart();
        }
        return false;
    }

    String getRestartMessage() {
        WatchdogChildTask task = this._taskRef.get();
        if (task != null) {
            return task.getRestartMessage();
        }
        return null;
    }

    ExitCode getPreviousExitCode() {
        WatchdogChildTask task = this._taskRef.get();
        if (task != null) {
            return task.getPreviousExitCode();
        }
        return null;
    }

    Serializable queryGet(Serializable payload) {
        WatchdogChildTask task = this._taskRef.get();
        if (task != null) {
            return task.queryGet(payload);
        }
        return null;
    }

    boolean isVerbose() {
        return this._config.isVerbose();
    }

    public int startConsole() {
        this._isConsole = true;
        WatchdogChildTask task = new WatchdogChildTask(this._system, this);
        if (!this._taskRef.compareAndSet(null, task)) {
            return -1;
        }
        task.start();
        return 1;
    }

    public void start() {
        WatchdogChildTask task = new WatchdogChildTask(this._system, this);
        if (!this._taskRef.compareAndSet(null, task)) {
            WatchdogChildTask oldTask = this._taskRef.get();
            if (oldTask != null && !oldTask.isActive()) {
                this._taskRef.set(task);
            } else if (!this._taskRef.compareAndSet(null, task)) {
                throw new IllegalStateException(L.l("Can't start new Resin server '{0}' because one is already running '{1}'", (Object)this._id, (Object)task));
            }
        }
        task.start();
    }

    public boolean isActive() {
        return this._taskRef.get() != null;
    }

    public void stop() {
        WatchdogChildTask task = this._taskRef.getAndSet(null);
        if (task != null) {
            task.stop();
        }
    }

    public void restart() {
        this.stop();
        this.start();
    }

    public void kill() {
        WatchdogChildTask task = this._taskRef.getAndSet(null);
        if (task != null) {
            task.kill();
        }
    }

    public void close() {
        this.kill();
        this._admin.unregister();
    }

    void notifyTaskStarted() {
        ++this._startCount;
        this._lastStartTime = new Date(CurrentTime.getExactTime());
        if (this._initialStartTime == null) {
            this._initialStartTime = this._lastStartTime;
        }
    }

    void completeTask(WatchdogChildTask task) {
        this._taskRef.compareAndSet(task, null);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getId() + "]";
    }

    class WatchdogAdmin
    extends AbstractManagedObject
    implements WatchdogMXBean {
        WatchdogAdmin() {
            this.registerSelf();
        }

        void unregister() {
            this.unregisterSelf();
        }

        @Override
        public String getId() {
            return WatchdogChild.this.getId();
        }

        public String getName() {
            return this.getId();
        }

        public String getType() {
            return "Watchdog";
        }

        @Override
        public String getResinHome() {
            return WatchdogChild.this.getResinHome().getNativePath();
        }

        @Override
        public String getResinRoot() {
            return WatchdogChild.this.getResinRoot().getNativePath();
        }

        @Override
        public String getResinConf() {
            return WatchdogChild.this.getResinConf().getNativePath();
        }

        @Override
        public String getUserName() {
            String userName = WatchdogChild.this.getUserName();
            if (userName != null) {
                return userName;
            }
            return System.getProperty("user.name");
        }

        @Override
        public String getState() {
            WatchdogChildTask task = (WatchdogChildTask)WatchdogChild.this._taskRef.get();
            if (task == null) {
                return "inactive";
            }
            return task.getState();
        }

        @Override
        public Date getInitialStartTime() {
            return WatchdogChild.this._initialStartTime;
        }

        @Override
        public Date getStartTime() {
            return WatchdogChild.this._lastStartTime;
        }

        @Override
        public int getStartCount() {
            return WatchdogChild.this._startCount;
        }

        @Override
        public void start() {
            WatchdogChild.this.start();
        }

        @Override
        public void stop() {
            WatchdogChild.this.stop();
        }

        @Override
        public void kill() {
            WatchdogChild.this.kill();
        }
    }
}

