/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.boot;

import com.caucho.VersionFactory;
import com.caucho.boot.AbstractStopCommand;
import com.caucho.boot.BootArgumentException;
import com.caucho.boot.WatchdogArgs;
import com.caucho.boot.WatchdogClient;
import com.caucho.util.L10N;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StopCommand
extends AbstractStopCommand {
    private static Logger _log;
    private static L10N _L;

    @Override
    public String getDescription() {
        return "stop a Resin server";
    }

    @Override
    public int doCommand(WatchdogArgs args, WatchdogClient client) throws BootArgumentException {
        try {
            client.stopWatchdog(args.getServerId(), args.getArgv());
            System.out.println(StopCommand.L().l("Resin/{0} stopped{1} for watchdog at {2}:{3}", (Object)VersionFactory.getVersion(), (Object)this.getServerUsageArg(args.getServerId(), client.getId()), (Object)client.getWatchdogAddress(), (Object)client.getWatchdogPort()));
        }
        catch (Exception e) {
            System.out.println(StopCommand.L().l("Resin/{0} can't stop -server '{1}' for watchdog at {2}:{3}.\n{4}", (Object)VersionFactory.getVersion(), (Object)client.getId(), (Object)client.getWatchdogAddress(), (Object)client.getWatchdogPort(), (Object)e.toString()));
            StopCommand.log().log(Level.FINE, e.toString(), e);
            System.exit(1);
        }
        return 0;
    }

    @Override
    public boolean isRetry() {
        return true;
    }

    private static Logger log() {
        if (_log == null) {
            _log = Logger.getLogger(StopCommand.class.getName());
        }
        return _log;
    }

    private static L10N L() {
        if (_L == null) {
            _L = new L10N(StopCommand.class);
        }
        return _L;
    }
}

