/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.boot;

import com.caucho.VersionFactory;
import com.caucho.boot.AbstractStartCommand;
import com.caucho.boot.BootArgumentException;
import com.caucho.boot.WatchdogArgs;
import com.caucho.boot.WatchdogClient;
import com.caucho.config.ConfigException;
import com.caucho.util.L10N;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StartWithForegroundCommand
extends AbstractStartCommand {
    private static Logger _log;
    private static L10N _L;

    @Override
    public String getName() {
        return "start-with-foreground";
    }

    @Override
    public String getDescription() {
        return "starts the watchdog in foreground mode (for MacOS-X)";
    }

    @Override
    public int doCommand(WatchdogArgs args, WatchdogClient client) throws BootArgumentException {
        try {
            Process process = client.startWatchdog(args.getArgv(), true);
            String message = process != null ? "Resin/{0} started -server '{1}' for watchdog at {2}:{3} with foreground" : "Resin/{0} started -server '{1}' for watchdog at {2}:{3} with no foreground";
            System.out.println(StartWithForegroundCommand.L().l(message, (Object)VersionFactory.getVersion(), (Object)client.getId(), (Object)client.getWatchdogAddress(), (Object)client.getWatchdogPort()));
            if (process != null) {
                process.waitFor();
                return process.exitValue();
            }
            return 0;
        }
        catch (Exception e) {
            String eMsg = e instanceof ConfigException ? e.getMessage() : e.toString();
            System.out.println(StartWithForegroundCommand.L().l("Resin/{0} can't start-with-foreground -server '{1}' for watchdog at {2}:{3}.\n  {4}", (Object)VersionFactory.getVersion(), (Object)client.getId(), (Object)client.getWatchdogAddress(), (Object)client.getWatchdogPort(), (Object)eMsg));
            StartWithForegroundCommand.log().log(Level.FINE, e.toString(), e);
            System.exit(1);
            return 0;
        }
    }

    @Override
    public boolean isRetry() {
        return true;
    }

    private static Logger log() {
        if (_log == null) {
            _log = Logger.getLogger(StartWithForegroundCommand.class.getName());
        }
        return _log;
    }

    private static L10N L() {
        if (_L == null) {
            _L = new L10N(StartWithForegroundCommand.class);
        }
        return _L;
    }
}

