/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.boot;

import com.caucho.Version;
import com.caucho.boot.GuiCommand;
import com.caucho.boot.WatchdogClient;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;

public class ResinGUI
extends JFrame
implements WindowListener,
ActionListener {
    private final WatchdogClient _client;
    private GuiCommand _command;
    private final ExecutorService _exec = Executors.newSingleThreadExecutor();
    private JRadioButton _start;
    private JRadioButton _stop;
    private JButton _quit;

    public ResinGUI(GuiCommand command, WatchdogClient client) throws HeadlessException, IOException {
        super(Version.FULL_VERSION);
        this._client = client;
        this._command = command;
        this._client.startConsole();
        this.init();
        this.pack();
        double titleWidth = this.getFontMetrics(this.getFont()).getStringBounds(Version.FULL_VERSION, this.getGraphics()).getWidth();
        Dimension size = this.getSize();
        int width = (int)titleWidth + 96;
        if ((double)width < size.getWidth()) {
            width = (int)size.getWidth();
        }
        Dimension dim = new Dimension(width, (int)size.getHeight());
        this.setMinimumSize(dim);
        this.setSize(dim);
    }

    private void init() {
        String id = this._client.getId();
        if (id == null || id.isEmpty()) {
            id = "default";
        }
        this.setLayout(new BorderLayout());
        Box box = new Box(1);
        CompoundBorder border = BorderFactory.createCompoundBorder(new EmptyBorder(5, 5, 5, 5), new TitledBorder("Server: " + id));
        box.setBorder(border);
        ButtonGroup group = new ButtonGroup();
        this._start = new JRadioButton("Start");
        this._start.setActionCommand("start");
        this._start.addActionListener(this);
        this._start.setSelected(true);
        this._stop = new JRadioButton("Stop");
        this._stop.setActionCommand("stop");
        this._stop.addActionListener(this);
        group.add(this._start);
        group.add(this._stop);
        box.add(this._start);
        box.add(this._stop);
        this.add((Component)box, "Center");
        this._quit = new JButton("Quit");
        this._quit.setActionCommand("quit");
        this._quit.addActionListener(this);
        JPanel panel = new JPanel();
        panel.add(this._quit);
        this.add((Component)panel, "South");
        this.addWindowListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.setUiEnabled(false);
        this._exec.execute(new ActionRunnable(e.getActionCommand()));
    }

    private void setUiEnabled(boolean enabled) {
        this._start.setEnabled(enabled);
        this._stop.setEnabled(enabled);
        this._quit.setEnabled(enabled);
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void windowClosed(WindowEvent e) {
        GuiCommand guiCommand = this._command;
        synchronized (guiCommand) {
            this._command.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void windowClosing(WindowEvent e) {
        GuiCommand guiCommand = this._command;
        synchronized (guiCommand) {
            this._command.notifyAll();
        }
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    public class ActionRunnable
    implements Runnable {
        private String _action;

        public ActionRunnable(String action) {
            this._action = action;
        }

        @Override
        public void run() {
            if ("start".equals(this._action)) {
                try {
                    ResinGUI.this._client.startConsole();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                ResinGUI.this._client.stopConsole();
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if ("quit".equals(ActionRunnable.this._action)) {
                        ResinGUI.this.setVisible(false);
                        ResinGUI.this.dispose();
                    } else {
                        ResinGUI.this.setUiEnabled(true);
                    }
                }
            });
        }
    }
}

