/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.boot;

import com.caucho.boot.AbstractManagementCommand;
import com.caucho.boot.WatchdogArgs;
import com.caucho.boot.WatchdogClient;
import com.caucho.config.types.Period;
import com.caucho.server.admin.ManagerClient;
import com.caucho.server.admin.PdfReportQueryReply;
import com.caucho.util.IoUtil;
import com.caucho.util.L10N;
import com.caucho.vfs.StreamSource;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class PdfReportCommand
extends AbstractManagementCommand {
    private static final L10N L = new L10N(PdfReportCommand.class);

    @Override
    protected void initBootOptions() {
        this.addValueOption("report", "value", "specifies the report-type key (default Snapshot)");
        this.addSpacerOption();
        this.addValueOption("period", "time", "specifies look-back period of time (default 7D)");
        this.addValueOption("profile-time", "time", "turns code profiling on for a time before generating report");
        this.addValueOption("profile-sample", "time", "specifies profiling sampling frequency (100ms)");
        this.addSpacerOption();
        this.addFlagOption("snapshot", "saves heap-dump, thread-dump, jmx-dump before generating report");
        this.addFlagOption("watchdog", "specifies look-back period starting at last Resin start");
        this.addSpacerOption();
        this.addValueOption("logdir", "dir", "PDF output directory (default to resin log)");
        this.addValueOption("local-dir", "dir", "writes a local copy of PDF report to a specified directory");
        this.addFlagOption("local", "writes a local copy of PDF report");
        super.initBootOptions();
    }

    @Override
    public String getDescription() {
        return "creates a PDF report of a Resin server";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int doCommand(WatchdogArgs args, WatchdogClient client, ManagerClient managerClient) {
        block19: {
            String serverId = args.getArg("-server");
            String path = args.getArg("-path");
            String report = args.getArg("-report");
            long period = -1L;
            String periodStr = args.getArg("-period");
            if (periodStr != null) {
                period = Period.toPeriod((String)periodStr);
            }
            String logDirectory = args.getArg("-logdir");
            long profileTime = -1L;
            String profileTimeArg = args.getArg("-profile-time");
            if (profileTimeArg != null) {
                profileTime = Period.toPeriod((String)profileTimeArg);
            }
            long samplePeriod = -1L;
            String samplePeriodArg = null;
            if (samplePeriodArg == null) {
                samplePeriodArg = args.getArg("-profile-sample");
            }
            if (samplePeriodArg == null) {
                samplePeriodArg = args.getArg("-sample-period");
            }
            if (samplePeriodArg != null) {
                samplePeriod = Period.toPeriod((String)samplePeriodArg, (long)1L);
            }
            boolean isSnapshot = args.getArgBoolean("-snapshot", true);
            boolean isWatchdog = args.getArgBoolean("-watchdog", false);
            boolean isLocal = args.getArgBoolean("-local", false);
            String localDir = args.getArg("-local-dir");
            if (localDir == null) {
                localDir = System.getProperty("user.dir");
            }
            boolean isReturnPdf = isLocal || localDir != null;
            PdfReportQueryReply result = managerClient.pdfReport(path, report, serverId, period, logDirectory, profileTime, samplePeriod, isSnapshot, isWatchdog, isReturnPdf);
            System.out.println(result.getMessage());
            if (isReturnPdf) {
                StreamSource streamSource = result.getPdf();
                try {
                    File file;
                    InputStream in = streamSource.getInputStream();
                    String fileName = result.getFileName();
                    if (fileName.lastIndexOf(47) > 0) {
                        fileName = fileName.substring(fileName.lastIndexOf(47));
                    } else if (fileName.lastIndexOf(92) > 0) {
                        fileName = fileName.substring(fileName.lastIndexOf(92));
                    }
                    if (localDir != null) {
                        file = new File(localDir, fileName);
                        file.getParentFile().mkdirs();
                    } else {
                        file = new File(fileName);
                    }
                    FileOutputStream out = null;
                    try {
                        out = new FileOutputStream(file);
                        byte[] buffer = new byte[1024];
                        int len = -1;
                        while ((len = in.read(buffer)) > 0) {
                            out.write(buffer, 0, len);
                        }
                        out.flush();
                        System.out.println(L.l("Local copy is written to '{0}'", (Object)file.toString()));
                    }
                    catch (IOException e) {
                        try {
                            System.out.println(L.l("Can't write a local copy '{0}'", (Object)file.toString()));
                        }
                        catch (Throwable throwable) {
                            IoUtil.close(out);
                            throw throwable;
                        }
                        IoUtil.close((OutputStream)out);
                        break block19;
                    }
                    IoUtil.close((OutputStream)out);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return 0;
    }
}

