/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.boot;

import com.caucho.admin.Password;
import com.caucho.boot.AbstractBootCommand;
import com.caucho.boot.BootArgumentException;
import com.caucho.boot.WatchdogArgs;
import com.caucho.boot.WatchdogClient;
import com.caucho.config.ConfigException;
import com.caucho.util.L10N;
import java.io.Console;
import java.util.ArrayList;

public class PasswordEncryptCommand
extends AbstractBootCommand {
    private static final L10N L = new L10N(PasswordEncryptCommand.class);

    @Override
    protected void initBootOptions() {
        this.addValueOption("password", "password", "the password to be encrypted");
        this.addValueOption("salt", "salt", "optional salt for the password");
        super.initBootOptions();
    }

    @Override
    public String getDescription() {
        return "encrypts a password";
    }

    @Override
    public int doCommand(WatchdogArgs args, WatchdogClient client) throws BootArgumentException {
        String salt = args.getArg("-salt");
        String password = args.getArg("-password");
        ArrayList<String> tailArgs = args.getTailArgs();
        if (tailArgs.size() == 1 && !((String)tailArgs.get(0)).startsWith("-")) {
            password = (String)tailArgs.get(0);
        }
        if (password == null) {
            password = PasswordEncryptCommand.readPasswordFromConsole();
        }
        if (password == null) {
            throw new ConfigException(L.l("password-encrypt requires a -password argument"));
        }
        String value = this.encrypt(password, salt);
        if (value != null) {
            System.out.println("password: {RESIN}" + value);
        } else {
            System.out.println("password: " + password);
        }
        return 0;
    }

    private static String readPasswordFromConsole() {
        try {
            Console console = System.console();
            if (console == null) {
                System.out.println(L.l("Warning: interactive console is not available"));
                return null;
            }
            char[] passwordChars = console.readPassword("Enter password: ", new Object[0]);
            if (passwordChars == null || passwordChars.length == 0) {
                return null;
            }
            return new String(passwordChars);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private String encrypt(String password, String salt) {
        try {
            Class<?> cl = Class.forName("com.caucho.admin.PasswordImpl");
            Password passwordApi = (Password)cl.newInstance();
            return passwordApi.encrypt(password, salt);
        }
        catch (Exception e) {
            throw ConfigException.create((String)"password-encrypt requires Resin Pro\n", (Throwable)e);
        }
    }

    @Override
    public String getUsageArgs() {
        return " [<password>]";
    }

    @Override
    public boolean isDefaultArgsAccepted() {
        return true;
    }
}

