/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.boot;

import com.caucho.boot.AbstractBootCommand;
import com.caucho.boot.BootArgumentException;
import com.caucho.boot.WatchdogArgs;
import com.caucho.boot.WatchdogClient;
import com.caucho.jsp.JspCompiler;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JspcCommand
extends AbstractBootCommand {
    private static final Logger log = Logger.getLogger(JspcCommand.class.getName());

    @Override
    protected void initBootOptions() {
        this.addValueOption("app-dir", "dir", "Directory root of the web-app");
        this.addValueOption("class-dir", "dir", "The work directory to compile as output");
        this.addSpacerOption();
        this.addValueOption("compiler", "value", "The java compiler for javac");
        super.initBootOptions();
    }

    @Override
    public String getDescription() {
        return "pre-compiles JSP files";
    }

    @Override
    public String getUsageArgs() {
        return " <jsp1> <jsp2> ...";
    }

    @Override
    public boolean isDefaultArgsAccepted() {
        return true;
    }

    @Override
    public int doCommand(WatchdogArgs args, WatchdogClient client) throws BootArgumentException {
        String conf;
        String compiler;
        String classDir;
        ArrayList<String> jspcArgs = new ArrayList<String>();
        String appDir = args.getArg("-app-dir");
        if (appDir != null && !"".equals(appDir)) {
            jspcArgs.add("-app-dir");
            jspcArgs.add(appDir);
        }
        if ((classDir = args.getArg("-class-dir")) != null && !"".equals(classDir)) {
            jspcArgs.add("-class-dir");
            jspcArgs.add(classDir);
        }
        if ((compiler = args.getArg("-compiler")) != null && !"".equals(compiler)) {
            jspcArgs.add("-compiler");
            jspcArgs.add(compiler);
        }
        if ((conf = args.getArg("-conf")) != null && !"".equals(conf)) {
            jspcArgs.add("-conf");
            jspcArgs.add(conf);
        }
        jspcArgs.addAll(args.getTailArgs());
        try {
            JspCompiler.main(jspcArgs.toArray(new String[jspcArgs.size()]));
            StringBuilder builder = new StringBuilder();
            if (appDir != null) {
                builder.append(appDir);
            } else {
                for (String tailArg : args.getTailArgs()) {
                    builder.append(tailArg).append(' ');
                }
            }
            System.out.println("resin jspc finished compiling " + builder.toString());
            return 0;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getMessage(), e);
            return 3;
        }
    }
}

