/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.boot;

import com.caucho.boot.AbstractManagementCommand;
import com.caucho.boot.WatchdogArgs;
import com.caucho.boot.WatchdogClient;
import com.caucho.server.admin.ManagerClient;
import com.caucho.server.admin.StringQueryReply;
import com.caucho.util.L10N;

public class HeapDumpCommand
extends AbstractManagementCommand {
    private static final L10N L = new L10N(HeapDumpCommand.class);

    @Override
    protected void initBootOptions() {
        this.addFlagOption("raw", "creates a JVM hprof file");
        super.initBootOptions();
    }

    @Override
    public String getDescription() {
        return "produces a JVM memory heap dump";
    }

    @Override
    public int doCommand(WatchdogArgs args, WatchdogClient client, ManagerClient managerClient) {
        boolean raw = args.hasOption("-raw");
        StringQueryReply result = managerClient.doHeapDump(raw);
        System.out.println(result.getValue());
        return 0;
    }

    @Override
    public boolean isProOnly() {
        return false;
    }
}

