/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.boot;

import com.caucho.boot.AbstractBootCommand;
import com.caucho.boot.WatchdogArgs;
import com.caucho.boot.WatchdogClient;
import com.caucho.cloud.scaling.ResinScalingClient;
import com.caucho.config.ConfigException;
import com.caucho.util.L10N;
import java.lang.reflect.Constructor;

public abstract class AbstractScalingCommand
extends AbstractBootCommand {
    private static final L10N L = new L10N(AbstractScalingCommand.class);
    private static Class<?> _scalingClientClass;

    @Override
    protected void initBootOptions() {
        this.addValueOption("address", "address", "ip or host name of the server");
        this.addIntValueOption("port", "port", "server http port");
        this.addSpacerOption();
        this.addValueOption("user", "user", "user name used for authentication to the server");
        this.addValueOption("password", "password", "password used for authentication to the server");
        super.initBootOptions();
    }

    protected ResinScalingClient getScalingClient(WatchdogArgs args, WatchdogClient client) {
        String address = args.getArg("-address");
        if (address == null || address.isEmpty()) {
            address = client.getConfig().getAddress();
        }
        int port = -1;
        String portArg = args.getArg("-port");
        try {
            if (portArg != null && !portArg.isEmpty()) {
                port = Integer.parseInt(portArg);
            }
        }
        catch (NumberFormatException e) {
            NumberFormatException e1 = new NumberFormatException("-port argument is not a number '" + portArg + "'");
            e1.setStackTrace(e.getStackTrace());
            throw e;
        }
        if (port == -1) {
            port = client.getConfig().getPort();
        }
        if (port == 0) {
            throw new ConfigException(L.l("HTTP listener {0}:{1} was not found", (Object)address, port));
        }
        String user = args.getArg("-user");
        String password = args.getArg("-password");
        try {
            Constructor<?> c = _scalingClientClass.getConstructor(String.class, Integer.TYPE, String.class, String.class);
            ResinScalingClient scaingClient = (ResinScalingClient)c.newInstance(address, port, user, password);
            return scaingClient;
        }
        catch (Exception e) {
            throw new ConfigException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public boolean isProOnly() {
        return true;
    }

    public boolean isPro() {
        return _scalingClientClass != null;
    }

    static {
        try {
            _scalingClientClass = Class.forName("com.caucho.cloud.elastic.ElasticCloudClient");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

