/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.boot;

import com.caucho.boot.AbstractRepositoryCommand;
import com.caucho.boot.WatchdogArgs;
import com.caucho.boot.WatchdogClient;
import com.caucho.config.ConfigException;
import com.caucho.env.repository.CommitBuilder;
import com.caucho.server.admin.WebAppDeployClient;
import com.caucho.server.deploy.DeployClient;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;

public abstract class AbstractDeployCommand
extends AbstractRepositoryCommand {
    private static final L10N L = new L10N(AbstractDeployCommand.class);

    @Override
    protected void initBootOptions() {
        this.addValueOption("stage", "stage", "stage to deploy application to, defaults to production");
        this.addValueOption("version", "version", "version of application formatted as <major.minor.micro.qualifier>");
        this.addValueOption("m", "message", "commit message");
        this.addValueOption("timeout", "timeout", "timeout for long deploys");
        super.initBootOptions();
    }

    @Override
    public boolean isDefaultArgsAccepted() {
        return true;
    }

    @Override
    public String getDescription() {
        return "deploys a configuration directory or jar file";
    }

    @Override
    public String getUsageArgs() {
        return " <filename>";
    }

    @Override
    public int doCommand(WatchdogArgs args, WatchdogClient client, WebAppDeployClient deployClient) {
        Path path = this.getDeployPath(args);
        CommitBuilder commit = this.createCommitBuilder(args, path);
        long timeout = args.getArgInt("timeout", 120) * 1000;
        if (timeout <= 0L) {
            timeout = 120000L;
        }
        this.deploy(args, deployClient, path, commit, timeout);
        return 0;
    }

    protected Path getDeployPath(WatchdogArgs args) {
        String jar = args.getDefaultArg();
        if (jar == null) {
            throw new ConfigException(L.l("Cannot find archive or directory argument in command line"));
        }
        Path jarPath = Vfs.lookup((String)jar);
        if (!jar.endsWith(".jar") && !jarPath.isDirectory()) {
            throw new ConfigException(L.l("Deploy expects to be used with a *.jar file or directory at {0}", (Object)jar));
        }
        return jarPath;
    }

    protected abstract CommitBuilder createCommitBuilder(WatchdogArgs var1, Path var2);

    protected void deploy(WatchdogArgs args, WebAppDeployClient deployClient, Path path, CommitBuilder commit, long timeout) {
        if (!path.isFile() && !path.isDirectory()) {
            throw new ConfigException(L.l("'{0}' is not a readable file.", (Object)path.getFullPath()));
        }
        String message = args.getArg("-m");
        if (message == null) {
            message = args.getArg("-message");
        }
        if (message == null) {
            message = "deploy " + path.getNativePath() + " from command line";
        }
        commit.message(message);
        commit.attribute("user", System.getProperty("user.name"));
        String version = args.getArg("-version");
        if (version != null) {
            DeployClient.fillInVersion(commit, version);
        }
        if (path.isDirectory()) {
            deployClient.commitPath(commit, path, timeout);
        } else {
            deployClient.commitArchive(commit, path, timeout);
        }
        System.out.println("Deployed " + commit.getId() + " from " + path + " to " + deployClient.getUrl());
    }
}

