/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.bam.actor;

import com.caucho.bam.BamError;
import com.caucho.bam.actor.ActorSender;
import com.caucho.bam.actor.BamActorRef;
import com.caucho.bam.broker.Broker;
import com.caucho.bam.query.QueryCallback;
import com.caucho.bam.query.QueryFuture;
import com.caucho.bam.query.QueryManager;
import java.io.Serializable;

public abstract class AbstractActorSender
implements ActorSender {
    private final QueryManager _queryManager;
    private long _timeout = 120000L;

    protected AbstractActorSender(String id) {
        this._queryManager = new QueryManager(id);
    }

    protected AbstractActorSender() {
        this._queryManager = new QueryManager(this.toString());
    }

    public long getTimeout() {
        return this._timeout;
    }

    public void setTimeout(long timeout) {
        this._timeout = timeout;
    }

    @Override
    public boolean isClosed() {
        return false;
    }

    @Override
    public void close() {
    }

    @Override
    public abstract Broker getBroker();

    @Override
    public QueryManager getQueryManager() {
        return this._queryManager;
    }

    @Override
    public void message(String to, Serializable payload) {
        this.getBroker().message(to, this.getAddress(), payload);
    }

    @Override
    public void message(BamActorRef to, Serializable payload) {
        to.message(this.getAddress(), payload);
    }

    @Override
    public long nextQueryId() {
        return this.getQueryManager().nextQueryId();
    }

    @Override
    public Serializable query(String to, Serializable payload) {
        return this.query(to, payload, this.getTimeout());
    }

    @Override
    public Serializable query(String to, Serializable payload, long timeout) {
        return this.queryFuture(to, payload, timeout).get();
    }

    public QueryFuture queryFuture(String to, Serializable payload, long timeout) {
        long qId = this.getQueryManager().nextQueryId();
        QueryFuture future = this.getQueryManager().addQueryFuture(qId, to, this.getAddress(), payload, timeout);
        try {
            this.getBroker().query(qId, to, this.getAddress(), payload);
        }
        catch (RuntimeException e) {
            this.getQueryManager().onQueryError(qId, this.getAddress(), to, payload, BamError.create(e));
        }
        return future;
    }

    @Override
    public void query(String to, Serializable payload, QueryCallback callback) {
        this.query(to, payload, callback, this.getTimeout());
    }

    @Override
    public void query(String to, Serializable payload, QueryCallback callback, long timeout) {
        long qId = this.getQueryManager().nextQueryId();
        this.getQueryManager().addQueryCallback(qId, callback, timeout);
        try {
            this.getBroker().query(qId, to, this.getAddress(), payload);
        }
        catch (RuntimeException e) {
            this.getQueryManager().onQueryError(qId, this.getAddress(), to, payload, BamError.create(e));
        }
    }

    @Override
    public void query(BamActorRef to, Serializable payload, QueryCallback callback) {
        this.query(to, payload, callback, this.getTimeout());
    }

    @Override
    public void query(BamActorRef to, Serializable payload, QueryCallback callback, long timeout) {
        long qId = this.getQueryManager().nextQueryId();
        this.getQueryManager().addQueryCallback(qId, callback, timeout);
        try {
            to.query(qId, this.getAddress(), payload);
        }
        catch (RuntimeException e) {
            this.getQueryManager().onQueryError(qId, this.getAddress(), to.getAddress(), payload, BamError.create(e));
        }
    }
}

