/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amqp.io;

import com.caucho.amqp.AmqpException;
import com.caucho.amqp.io.AmqpAbstractPacket;
import com.caucho.amqp.io.AmqpConstants;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AmqpReader
implements AmqpConstants {
    private InputStream _is;
    private boolean _isNull;
    private byte[] _buffer = new byte[256];
    private int _offset;
    private int _length;

    public void init(InputStream is) {
        this._is = is;
        this._offset = 0;
        this._length = 0;
    }

    public int getFrameAvailable() {
        try {
            return this._length - this._offset + this._is.available();
        }
        catch (IOException e) {
            throw new AmqpException(e);
        }
    }

    public boolean isNull() {
        return this._isNull;
    }

    public int read() throws IOException {
        int length = this._length;
        int offset = this._offset;
        if (length <= offset) {
            if (!this.fillBuffer()) {
                return -1;
            }
            offset = this._offset;
            length = this._length;
        }
        int value = this._buffer[offset++] & 0xFF;
        this._offset = offset;
        return value;
    }

    public long peekDescriptor() throws IOException {
        this.ensureBuffer(10);
        int offset = this._offset;
        long desc = this.readDescriptor();
        this._offset = offset;
        return desc;
    }

    private boolean ensureBuffer(int len) throws IOException {
        if (len <= this._length - this._offset) {
            return true;
        }
        System.arraycopy(this._buffer, this._offset, this._buffer, 0, this._length - this._offset);
        int sublen = this._buffer.length - this._offset;
        sublen = this._is.read(this._buffer, this._offset, sublen);
        if (sublen >= 0) {
            this._length = this._offset + sublen;
            this._offset = 0;
            return true;
        }
        this._length = this._offset;
        this._offset = 0;
        return false;
    }

    private boolean fillBuffer() throws IOException {
        this._length = this._is.read(this._buffer, 0, this._buffer.length);
        this._offset = 0;
        return this._length > 0;
    }

    public int read(byte[] buffer, int offset, int length) throws IOException {
        int readLength;
        for (readLength = 0; readLength < length; ++readLength) {
            int ch = this.read();
            if (ch < 0) {
                return readLength > 0 ? readLength : -1;
            }
            buffer[offset + readLength] = (byte)ch;
        }
        return readLength;
    }

    public boolean readBoolean() throws IOException {
        this._isNull = false;
        int code = this.read();
        switch (code) {
            case 64: {
                this._isNull = true;
                return false;
            }
            case 65: {
                return true;
            }
            case 66: {
                return false;
            }
            case 86: {
                return this.read() != 0;
            }
        }
        throw new IOException("unknown boolean code: " + Integer.toHexString(code));
    }

    public int readInt() throws IOException {
        this._isNull = false;
        int code = this.read();
        switch (code) {
            case 64: {
                this._isNull = true;
                return 0;
            }
            case 67: {
                return 0;
            }
            case 81: 
            case 84: {
                return (byte)this.read();
            }
            case 80: 
            case 82: {
                return this.read() & 0xFF;
            }
            case 97: {
                return (short)this.readShort();
            }
            case 96: {
                return this.readShort() & 0xFFFF;
            }
            case 112: 
            case 113: {
                return this.readIntImpl();
            }
        }
        throw new IOException("unknown int code: " + Integer.toHexString(code));
    }

    public long readLong() throws IOException {
        this._isNull = false;
        int code = this.read();
        switch (code) {
            case 64: {
                this._isNull = true;
                return 0L;
            }
            case 67: 
            case 68: {
                return 0L;
            }
            case 81: 
            case 84: 
            case 85: {
                return (byte)this.read();
            }
            case 80: 
            case 82: 
            case 83: {
                return this.read() & 0xFF;
            }
            case 97: {
                return (short)this.readShort();
            }
            case 96: {
                return this.readShort() & 0xFFFF;
            }
            case 112: 
            case 113: {
                return (long)this.readIntImpl() & 0xFFFFFFFFL;
            }
            case 128: 
            case 129: {
                return this.readLongImpl();
            }
        }
        throw new IOException("unknown long code: " + Integer.toHexString(code));
    }

    public List<String> readSymbolArray() throws IOException {
        this._isNull = false;
        int code = this.read();
        if (code == 64) {
            return null;
        }
        ArrayList<String> values = new ArrayList<String>();
        switch (code) {
            case 64: {
                return null;
            }
            case 163: {
                String value = this.readSymbol(this.read() & 0xFF);
                values.add(value);
                return values;
            }
            case 179: {
                String value = this.readSymbol(this.readIntImpl());
                values.add(value);
                return values;
            }
        }
        throw new IOException("unknown symbol array code: " + Integer.toHexString(code));
    }

    public String readSymbol() throws IOException {
        this._isNull = false;
        int code = this.read();
        switch (code) {
            case 64: {
                return null;
            }
            case 163: {
                return this.readSymbol(this.read() & 0xFF);
            }
            case 179: {
                return this.readSymbol(this.readIntImpl());
            }
        }
        throw new IOException("unknown symbol code: " + Integer.toHexString(code));
    }

    public byte[] readBinary() throws IOException {
        this._isNull = false;
        int code = this.read();
        switch (code) {
            case 64: {
                return null;
            }
            case 160: {
                int len = this.read() & 0xFF;
                byte[] data = new byte[len];
                for (int i = 0; i < len; ++i) {
                    data[i] = (byte)this.read();
                }
                return data;
            }
            case 176: {
                int len = this.readIntImpl();
                byte[] data = new byte[len];
                for (int i = 0; i < len; ++i) {
                    data[i] = (byte)this.read();
                }
                return data;
            }
        }
        throw new IOException("unknown binary code: " + Integer.toHexString(code));
    }

    public String readString() throws IOException {
        this._isNull = false;
        int code = this.read();
        switch (code) {
            case 64: {
                return null;
            }
            case 161: {
                return this.readUtf8(this.read() & 0xFF);
            }
            case 177: {
                return this.readUtf8(this.readIntImpl());
            }
        }
        throw new IOException("unknown symbol code: " + Integer.toHexString(code));
    }

    public long readDescriptor() throws IOException {
        this._isNull = false;
        int code = this.read();
        switch (code) {
            case -1: {
                return -1L;
            }
            case 64: {
                this._isNull = true;
                return 0L;
            }
            case 0: {
                return this.readLong();
            }
        }
        throw new IOException("unknown descriptor code: " + Integer.toHexString(code));
    }

    public <T extends AmqpAbstractPacket> T readObject(Class<T> type) throws IOException {
        long descriptor = this.readDescriptor();
        if (this._isNull) {
            return null;
        }
        return this.readObject(descriptor, type);
    }

    public Object readObject(long descriptor) throws IOException {
        return this.readObject(descriptor, AmqpAbstractPacket.class);
    }

    public <T extends AmqpAbstractPacket> T readObject(long descriptor, Class<T> type) throws IOException {
        return AmqpAbstractPacket.readType(this, descriptor, type);
    }

    public Object readObject() throws IOException {
        int code = this.read();
        switch (code) {
            case 64: {
                return null;
            }
            case 161: {
                int len = this.read() & 0xFF;
                return this.readUtf8(len);
            }
            case 177: {
                int len = this.readIntImpl();
                return this.readUtf8(len);
            }
            case 163: {
                int len = this.read() & 0xFF;
                return this.readSymbol(len);
            }
            case 179: {
                int len = this.readIntImpl();
                return this.readSymbol(len);
            }
        }
        throw new IllegalStateException("unknown code: 0x" + Integer.toHexString(code));
    }

    public List<?> readList() throws IOException {
        this._isNull = false;
        int code = this.read();
        switch (code) {
            case 64: {
                return null;
            }
        }
        throw new IOException("unknown array code: " + Integer.toHexString(code));
    }

    public int startList() throws IOException {
        this._isNull = false;
        int code = this.read();
        switch (code) {
            case 64: {
                return 0;
            }
            case 69: {
                return 0;
            }
            case 192: {
                int size = this.read() & 0xFF;
                int count = this.read() & 0xFF;
                return count;
            }
            case 208: {
                int size = this.readIntImpl();
                int count = this.readIntImpl();
                return count;
            }
        }
        throw new IOException("unknown array code: " + Integer.toHexString(code));
    }

    public void endList() {
    }

    public List<?> readArray() throws IOException {
        this._isNull = false;
        int code = this.read();
        switch (code) {
            case 64: {
                return null;
            }
        }
        throw new IOException("unknown array code: " + Integer.toHexString(code));
    }

    public Map<String, Object> readFieldMap() throws IOException {
        return this.readMap();
    }

    public Map<?, ?> readMap() throws IOException {
        this._isNull = false;
        int code = this.read();
        switch (code) {
            case 64: {
                return null;
            }
            case 193: {
                int length = this.read() & 0xFF;
                int size = this.read() & 0xFF;
                HashMap<Object, Object> map = new HashMap<Object, Object>();
                for (int i = 0; i < size; ++i) {
                    map.put(this.readObject(), this.readObject());
                }
                return map;
            }
        }
        throw new IOException("unknown map code: " + Integer.toHexString(code));
    }

    private String readSymbol(int length) throws IOException {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            int ch = this.read();
            sb.append((char)ch);
        }
        return sb.toString();
    }

    private String readUtf8(int length) throws IOException {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            int ch = this.read();
            sb.append((char)ch);
        }
        return sb.toString();
    }

    private int readShort() throws IOException {
        return ((this.read() & 0xFF) << 8) + (this.read() & 0xFF);
    }

    private int readIntImpl() throws IOException {
        return ((this.read() & 0xFF) << 24) + ((this.read() & 0xFF) << 16) + ((this.read() & 0xFF) << 8) + (this.read() & 0xFF);
    }

    private long readLongImpl() throws IOException {
        return (((long)this.read() & 0xFFL) << 56) + (((long)this.read() & 0xFFL) << 48) + (((long)this.read() & 0xFFL) << 40) + (((long)this.read() & 0xFFL) << 32) + (((long)this.read() & 0xFFL) << 24) + (((long)this.read() & 0xFFL) << 16) + (((long)this.read() & 0xFFL) << 8) + ((long)this.read() & 0xFFL);
    }
}

