/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amp.actor;

import com.caucho.amp.actor.AmpActorContext;
import com.caucho.amp.actor.AmpActorRef;
import com.caucho.amp.actor.AmpMethodRef;
import com.caucho.amp.mailbox.AmpMailbox;
import com.caucho.amp.stream.AmpEncoder;
import com.caucho.amp.stream.AmpError;

public final class ActorRefImpl
implements AmpActorRef {
    private final String _address;
    private final AmpMailbox _mailbox;
    private final AmpActorContext _actor;

    public ActorRefImpl(String address, AmpMailbox mailbox, AmpActorContext actor) {
        this._address = address;
        this._mailbox = mailbox;
        this._actor = actor;
    }

    @Override
    public String getAddress() {
        return this._address;
    }

    @Override
    public AmpMethodRef getMethod(String methodName, AmpEncoder encoder) {
        return this._actor.getMethod(methodName, encoder);
    }

    @Override
    public void send(AmpActorRef from, AmpEncoder encoder, String methodName, Object ... args) {
        this.getMailbox().send(this, from, encoder, methodName, args);
    }

    @Override
    public void query(long id, AmpActorRef from, AmpEncoder encoder, String methodName, Object ... args) {
        this.getMailbox().query(id, this, from, encoder, methodName, args);
    }

    @Override
    public void reply(long id, AmpActorRef from, AmpEncoder encoder, Object result) {
        this.getMailbox().queryResult(id, this, from, encoder, result);
    }

    @Override
    public void queryError(long id, AmpActorRef from, AmpEncoder encoder, AmpError error) {
        this.getMailbox().queryError(id, this, from, encoder, error);
    }

    @Override
    public void error(AmpActorRef from, AmpEncoder encoder, AmpError error) {
    }

    private AmpMailbox getMailbox() {
        return this._mailbox;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getAddress() + "]";
    }
}

