/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.query;

import com.caucho.amber.entity.AmberEntityHome;
import com.caucho.amber.expr.IdExpr;
import com.caucho.amber.expr.JoinExpr;
import com.caucho.amber.expr.PathExpr;
import com.caucho.amber.query.AbstractQuery;
import com.caucho.amber.table.AmberTable;
import com.caucho.amber.type.EntityType;

public class FromItem {
    private String _name;
    private EntityType _entityType;
    private AmberTable _table;
    private AbstractQuery _query;
    private PathExpr _collectionExpr;
    private IdExpr _idExpr;
    private int _index;
    private JoinExpr _joinExpr;
    private boolean _isUsed;
    private JoinSemantics _joinSemantics = JoinSemantics.UNKNOWN;

    FromItem(EntityType entityType, AmberTable table, String name, int index) {
        this._entityType = entityType;
        this._table = table;
        this._name = name;
        this._index = index;
    }

    public void setIdExpr(IdExpr idExpr) {
        this._idExpr = idExpr;
    }

    public IdExpr getIdExpr() {
        if (this._idExpr == null) {
            this._idExpr = this._collectionExpr != null ? this._collectionExpr.createId(this) : new IdExpr(this);
        }
        return this._idExpr;
    }

    public void setCollectionExpr(PathExpr collectionExpr) {
        this._collectionExpr = collectionExpr;
    }

    public PathExpr getCollectionExpr() {
        return this._collectionExpr;
    }

    public AbstractQuery getQuery() {
        return this._query;
    }

    public void setQuery(AbstractQuery query) {
        this._query = query;
    }

    public String getName() {
        return this._name;
    }

    public EntityType getEntityType() {
        if (this._entityType != null) {
            return this._entityType;
        }
        return this.getTableType();
    }

    public EntityType getTableType() {
        return this._table.getType();
    }

    public AmberTable getTable() {
        return this._table;
    }

    public boolean isEntityType() {
        return this._entityType != null;
    }

    public void setTable(AmberTable table) {
        this._table = table;
    }

    public void setJoinExpr(JoinExpr joinExpr) {
        this._joinExpr = joinExpr;
    }

    public boolean isUsed() {
        return this._isUsed;
    }

    public void setUsed(boolean isUsed) {
        this._isUsed = isUsed;
    }

    public boolean isInnerJoin() {
        return this._joinSemantics == JoinSemantics.INNER;
    }

    public boolean isOuterJoin() {
        return this._joinSemantics == JoinSemantics.OUTER;
    }

    public void setJoinSemantics(JoinSemantics joinSemantics) {
        this._joinSemantics = joinSemantics;
    }

    public void setOuterJoin(boolean isOuterJoin) {
        this._joinSemantics = isOuterJoin ? JoinSemantics.OUTER : JoinSemantics.INNER;
    }

    public JoinExpr getJoinExpr() {
        return this._joinExpr;
    }

    public AmberEntityHome getEntityHome() {
        return this.getTableType().getHome();
    }

    public int getIndex() {
        return this._index;
    }

    public String toString() {
        return "FromItem[" + this._table.getName() + " AS " + this.getName() + "]";
    }

    static enum JoinSemantics {
        UNKNOWN,
        INNER,
        OUTER;

    }
}

