/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.gen;

import com.caucho.VersionFactory;
import com.caucho.amber.field.AmberField;
import com.caucho.amber.field.PropertyField;
import com.caucho.amber.type.EmbeddableType;
import com.caucho.java.JavaWriter;
import com.caucho.java.gen.ClassComponent;
import com.caucho.util.L10N;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;

public class EmbeddableComponent
extends ClassComponent {
    private static final L10N L = new L10N(EmbeddableComponent.class);
    private String _baseClassName;
    private String _extClassName;
    private EmbeddableType _embeddableType;

    public void setEmbeddableType(EmbeddableType embeddableType) {
        this._embeddableType = embeddableType;
    }

    public void setBaseClassName(String baseClassName) {
        this._baseClassName = baseClassName;
    }

    public String getBaseClassName() {
        return this._baseClassName;
    }

    public void setExtClassName(String extClassName) {
        this._extClassName = extClassName;
    }

    public String getClassName() {
        return this._extClassName;
    }

    public String getBeanClassName() {
        return this._baseClassName;
    }

    public void generate(JavaWriter out) throws IOException {
        this.generateHeader(out);
        this.generateInit(out);
        this.generateMake(out);
        this.generateMakeFromLoad(out);
        this.generateGetField(out);
        this.generateLoad(out);
    }

    private void generateHeader(JavaWriter out) throws IOException {
        out.println("/*");
        out.println(" * Generated by Resin Amber");
        out.println(" * " + VersionFactory.getVersion());
        out.println(" */");
        out.println("private static final java.util.logging.Logger __caucho_log");
        out.println("  = java.util.logging.Logger.getLogger(\"" + this.getBeanClassName() + "\");");
    }

    private void generateInit(JavaWriter out) throws IOException {
        String className = this.getClassName();
        int p = className.lastIndexOf(46);
        if (p > 0) {
            className = className.substring(p + 1);
        }
        ArrayList<AmberField> fields = this._embeddableType.getFields();
        for (Constructor<?> ctor : this._embeddableType.getBeanClass().getConstructors()) {
            int i;
            out.println();
            out.print("public ");
            out.print(className);
            out.print("(");
            Class<?>[] args = ctor.getParameterTypes();
            for (i = 0; i < args.length; ++i) {
                if (i != 0) {
                    out.print(", ");
                }
                out.printClass(args[i]);
                out.print(" a" + i);
            }
            out.println(")");
            out.println("{");
            out.pushDepth();
            out.print("super(");
            for (i = 0; i < args.length; ++i) {
                if (i != 0) {
                    out.print(", ");
                }
                out.print("a" + i);
            }
            out.println(");");
            for (AmberField field : fields) {
                field.generatePostConstructor(out);
            }
            out.popDepth();
            out.println("}");
        }
    }

    private void generateMake(JavaWriter out) throws IOException {
        AmberField prop;
        int i;
        ArrayList<AmberField> fields = this._embeddableType.getFields();
        out.println();
        out.println("public static " + this.getClassName() + " __caucho_make(");
        for (i = 0; i < fields.size(); ++i) {
            prop = fields.get(i);
            out.print("  " + prop.getJavaTypeName() + " a" + i);
            if (i + 1 >= fields.size()) continue;
            out.println(",");
        }
        out.println(")");
        out.println("{");
        out.pushDepth();
        out.println(this.getClassName() + " bean = new " + this.getClassName() + "();");
        for (i = 0; i < fields.size(); ++i) {
            prop = fields.get(i);
            out.println(prop.generateSuperSetter("bean", "a" + i) + ";");
        }
        out.println("return bean;");
        out.popDepth();
        out.println("}");
    }

    private void generateMakeFromLoad(JavaWriter out) throws IOException {
        ArrayList<AmberField> fields = this._embeddableType.getFields();
        out.println();
        out.println("public static " + this.getClassName() + " __caucho_make(");
        out.println("  com.caucho.amber.manager.AmberConnection aConn,");
        out.println("  java.sql.ResultSet rs,");
        out.println("  int index)");
        out.println("  throws java.sql.SQLException");
        out.println("{");
        out.pushDepth();
        out.println(this.getClassName() + " bean = new " + this.getClassName() + "();");
        out.println("bean.__caucho_load(aConn, rs, index);");
        out.println("return bean;");
        out.popDepth();
        out.println("}");
    }

    private void generateGetField(JavaWriter out) throws IOException {
        AmberField prop;
        out.println();
        out.println("public Object __caucho_get_field(int index)");
        out.println("{");
        out.pushDepth();
        out.println("switch (index) {");
        out.pushDepth();
        ArrayList<AmberField> fields = this._embeddableType.getFields();
        for (int i = 0; i < fields.size() && (prop = fields.get(i)) instanceof PropertyField; ++i) {
            out.println("case " + i + ":");
            out.println("  return " + prop.generateSuperGetter("this") + ";");
            out.println();
        }
        out.println("default:");
        out.println("  throw new IllegalStateException(\"invalid index: \" + index);");
        out.popDepth();
        out.println("}");
        out.popDepth();
        out.println("}");
    }

    private void generateLoad(JavaWriter out) throws IOException {
        out.println();
        out.println("public int __caucho_load(com.caucho.amber.manager.AmberConnection aConn,");
        out.println("                         java.sql.ResultSet rs,");
        out.println("                         int index)");
        out.println("  throws java.sql.SQLException");
        out.println("{");
        out.pushDepth();
        if (this._embeddableType.isIdClass()) {
            out.println("return 0;");
        } else {
            this._embeddableType.generateLoad(out, "rs", "index", 0, -1);
            out.println("return index;");
        }
        out.popDepth();
        out.println("}");
    }
}

