/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.gen;

import com.caucho.amber.entity.Embeddable;
import com.caucho.amber.entity.Entity;
import com.caucho.amber.entity.Listener;
import com.caucho.amber.gen.AmberGenerator;
import com.caucho.amber.gen.AmberMappedComponent;
import com.caucho.amber.gen.EmbeddableComponent;
import com.caucho.amber.gen.EntityGenerator;
import com.caucho.amber.gen.ListenerComponent;
import com.caucho.amber.manager.AmberPersistenceUnit;
import com.caucho.amber.type.AbstractEnhancedType;
import com.caucho.amber.type.EmbeddableType;
import com.caucho.amber.type.EntityType;
import com.caucho.amber.type.ListenerType;
import com.caucho.java.JavaCompilerUtil;
import com.caucho.java.gen.ClassComponent;
import com.caucho.java.gen.DependencyComponent;
import com.caucho.java.gen.GenClass;
import com.caucho.java.gen.JavaClassGenerator;
import com.caucho.util.L10N;
import java.util.ArrayList;
import java.util.logging.Logger;

public class AmberGeneratorImpl
implements AmberGenerator {
    private static final L10N L = new L10N(AmberGeneratorImpl.class);
    private static final Logger log = Logger.getLogger(AmberGeneratorImpl.class.getName());
    private AmberPersistenceUnit _amberPersistenceUnit;
    private ArrayList<String> _pendingClassNames = new ArrayList();

    public AmberGeneratorImpl(AmberPersistenceUnit manager) {
        this._amberPersistenceUnit = manager;
    }

    @Override
    public void configure(AbstractEnhancedType type) throws Exception {
    }

    @Override
    public void generate(AbstractEnhancedType type) throws Exception {
        this.generateJava(null, type);
    }

    @Override
    public void generateJava(JavaClassGenerator javaGen, AbstractEnhancedType type) throws Exception {
        if (this.isPreload(javaGen, type) || type.isGenerated()) {
            return;
        }
        type.setGenerated(true);
        GenClass genClass = new GenClass(type.getInstanceClassName());
        genClass.setSuperClassName(type.getBeanClass().getName());
        genClass.addImport("com.caucho.amber.manager.*");
        genClass.addImport("com.caucho.amber.entity.*");
        genClass.addImport("com.caucho.amber.type.*");
        AmberMappedComponent componentGenerator = (AmberMappedComponent)type.getComponentGenerator();
        if (componentGenerator != null) {
            genClass.addInterfaceName(type.getComponentInterfaceName());
            componentGenerator.setRelatedType((EntityType)type);
            componentGenerator.setBaseClassName(type.getBeanClass().getName());
            componentGenerator.setExtClassName(type.getInstanceClassName());
            genClass.addComponent((ClassComponent)componentGenerator);
            DependencyComponent depend = genClass.addDependencyComponent();
            depend.addDependencyList(componentGenerator.getDependencies());
        } else if (type instanceof EmbeddableType) {
            genClass.addInterfaceName("com.caucho.amber.entity.Embeddable");
            EmbeddableComponent embeddable = new EmbeddableComponent();
            embeddable.setEmbeddableType((EmbeddableType)type);
            embeddable.setBaseClassName(type.getBeanClass().getName());
            embeddable.setExtClassName(type.getInstanceClassName());
            genClass.addComponent((ClassComponent)embeddable);
        } else {
            genClass.addInterfaceName("com.caucho.amber.entity.Listener");
            ListenerComponent listener = new ListenerComponent();
            listener.setListenerType((ListenerType)type);
            listener.setBaseClassName(type.getBeanClass().getName());
            listener.setExtClassName(type.getInstanceClassName());
            genClass.addComponent((ClassComponent)listener);
        }
        javaGen.generate(genClass);
    }

    public boolean isPreload(JavaClassGenerator javaGen, AbstractEnhancedType type) throws Exception {
        Class cl = type.isEnhanced() ? javaGen.loadClass(type.getBeanClass().getName()) : javaGen.preload(type.getInstanceClassName());
        Class expectedClass = Listener.class;
        if (type instanceof EntityType) {
            expectedClass = Entity.class;
        } else if (type instanceof EmbeddableType) {
            expectedClass = Embeddable.class;
        }
        return cl != null && expectedClass.isAssignableFrom(cl);
    }

    @Override
    public void compile() throws Exception {
        if (this._pendingClassNames.size() == 0) {
            return;
        }
        String[] javaFiles = new String[this._pendingClassNames.size()];
        for (int i = 0; i < this._pendingClassNames.size(); ++i) {
            String name = this._pendingClassNames.get(i);
            javaFiles[i] = name = name.replace('.', '/') + ".java";
        }
        this._pendingClassNames.clear();
        EntityGenerator gen = new EntityGenerator();
        JavaCompilerUtil compiler = gen.getCompiler();
        compiler.compileBatch(javaFiles);
    }
}

