/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.field;

import com.caucho.amber.expr.AmberExpr;
import com.caucho.amber.expr.ElementCollectionExpr;
import com.caucho.amber.expr.PathExpr;
import com.caucho.amber.field.AssociationField;
import com.caucho.amber.query.QueryParser;
import com.caucho.amber.table.AmberTable;
import com.caucho.amber.table.LinkColumns;
import com.caucho.amber.type.AmberType;
import com.caucho.amber.type.ElementType;
import com.caucho.amber.type.EntityType;
import com.caucho.bytecode.JType;
import com.caucho.bytecode.JTypeWrapper;
import com.caucho.config.ConfigException;
import com.caucho.java.JavaWriter;
import com.caucho.util.L10N;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.persistence.CascadeType;

public class ElementCollectionField
extends AssociationField {
    private static final L10N L = new L10N(ElementCollectionField.class);
    private static final Logger log = Logger.getLogger(ElementCollectionField.class.getName());
    private String _mapKey;
    private AmberType _targetType;
    private AmberTable _associationTable;
    private LinkColumns _sourceLink;
    private ArrayList<String> _orderByFields;
    private ArrayList<Boolean> _orderByAscending;
    private ElementType _elementType;

    public ElementCollectionField(EntityType sourceType, String name) throws ConfigException {
        super(sourceType, name, null);
        this._elementType = new ElementType(sourceType.getPersistenceUnit(), this);
    }

    public String getMapKey() {
        return this._mapKey;
    }

    public void setMapKey(String mapKey) {
        this._mapKey = mapKey;
    }

    @Override
    public void setType(AmberType targetType) {
        this._targetType = targetType;
        super.setType(targetType);
    }

    public EntityType getRelatedType() {
        return (EntityType)this.getSourceType();
    }

    @Override
    public AmberType getTargetType() {
        return this._targetType;
    }

    public AmberTable getAssociationTable() {
        return this._associationTable;
    }

    public void setAssociationTable(AmberTable table) {
        this._associationTable = table;
    }

    public void setSourceLink(LinkColumns link) {
        this._sourceLink = link;
    }

    public LinkColumns getSourceLink() {
        return this._sourceLink;
    }

    public void setOrderBy(ArrayList<String> orderByFields, ArrayList<Boolean> orderByAscending) {
        this._orderByFields = orderByFields;
        this._orderByAscending = orderByAscending;
    }

    @Override
    public void init() throws ConfigException {
    }

    @Override
    public void generateStatementSet(JavaWriter out, String pstmt, String obj, String index) throws IOException {
    }

    @Override
    public String generateLoadSelect(String id) {
        return id + "." + this.getName();
    }

    @Override
    public int generatePostLoadSelect(JavaWriter out, int index) throws IOException {
        if (!this.isLazy()) {
            out.println(this.getGetterName() + "().size();");
        }
        return ++index;
    }

    @Override
    public AmberExpr createExpr(QueryParser parser, PathExpr parent) {
        return new ElementCollectionExpr(parser, parent, this._sourceLink, this._elementType);
    }

    @Override
    public void generateCopyLoadObject(JavaWriter out, String dst, String src, int loadIndex) throws IOException {
        String var;
        if (dst.equals("item")) {
            return;
        }
        String value = var = "_caucho_field_" + this.getGetterName();
        out.println(this.generateSet(dst, value) + ";");
        out.println(this.generateAccessor(dst, var) + " = " + this.generateAccessor(src, var) + ";");
        if (!dst.equals("super")) {
            String oThis = "((" + this.getRelatedType().getInstanceClassName() + ") " + dst + ")";
            out.println(this.generateSuperSetter(oThis, this.generateSuperGetter("this")) + ";");
        }
    }

    @Override
    public void generateMergeFrom(JavaWriter out, String dst, String src) throws IOException {
        int updateIndex = 0;
        this.generateCopyLoadObject(out, dst, src, updateIndex);
        out.println();
    }

    @Override
    public void generateGetterMethod(JavaWriter out) throws IOException {
        JType type;
        JType[] paramArgs;
        String var = "_caucho_field_" + this.getGetterName();
        boolean isSet = this.getJavaType().isAssignableTo(Set.class);
        boolean isMap = false;
        if (!isSet) {
            isMap = this.getJavaType().isAssignableTo(Map.class);
        }
        JType param = (paramArgs = (type = this.getJavaType()).getActualTypeArguments()).length > 0 ? paramArgs[0] : null;
        JType param2 = paramArgs.length > 1 ? paramArgs[1] : null;
        out.print("protected ");
        String collectionImpl = isSet ? "com.caucho.amber.collection.SetImpl" : (isMap ? "com.caucho.amber.collection.MapImpl" : "com.caucho.amber.collection.CollectionImpl");
        out.print(collectionImpl);
        if (param != null) {
            out.print('<' + param.getPrintName());
            if (isMap && param2 != null) {
                out.print(", " + param2.getPrintName());
            }
            out.print(">");
        }
        out.print(" " + var + ";");
        out.println();
        out.println("public " + this.getJavaTypeName() + " " + this.getGetterName() + "()");
        out.println("{");
        out.pushDepth();
        out.println("if (" + var + " != null) {");
        out.pushDepth();
        out.println("if (__caucho_state.isPersist()) {");
        out.pushDepth();
        out.println(var + ".setSession(__caucho_session);");
        out.println("return " + var + ";");
        out.popDepth();
        out.println("}");
        out.println();
        out.println("if (" + var + ".getSession() != null");
        out.println("    && " + var + ".getSession() == __caucho_session)");
        out.println("  return " + var + ";");
        out.popDepth();
        out.println("}");
        out.println();
        out.println("com.caucho.amber.AmberQuery query = null;");
        out.println();
        out.println("try {");
        out.pushDepth();
        out.println("if (__caucho_session == null) {");
        out.pushDepth();
        String newEmptyCollection = "new " + collectionImpl;
        if (param != null) {
            newEmptyCollection = newEmptyCollection + "<" + param.getPrintName();
            if (isMap) {
                newEmptyCollection = newEmptyCollection + ", ";
                newEmptyCollection = newEmptyCollection + param2.getPrintName();
            }
            newEmptyCollection = newEmptyCollection + ">";
        }
        newEmptyCollection = newEmptyCollection + "(query";
        if (isMap) {
            newEmptyCollection = newEmptyCollection + "," + this.getTargetType().getJavaTypeName();
            newEmptyCollection = newEmptyCollection + ".class.getDeclaredMethod(\"get";
            String getterMapKey = this.getMapKey();
            getterMapKey = Character.toUpperCase(getterMapKey.charAt(0)) + getterMapKey.substring(1);
            newEmptyCollection = newEmptyCollection + getterMapKey;
            newEmptyCollection = newEmptyCollection + "\", (Class []) null)";
        }
        newEmptyCollection = newEmptyCollection + ")";
        out.println("if (" + var + " == null)");
        out.println("  " + var + " = " + newEmptyCollection + ";");
        out.println();
        out.println("return " + var + ";");
        out.popDepth();
        out.println("}");
        out.println();
        out.print("String sql=\"");
        out.print("SELECT c");
        out.print(" FROM " + this.getSourceType().getName() + " o,");
        out.print("  IN(o." + this.getName() + ") c");
        out.print(" WHERE ");
        out.print(this.getRelatedType().getId().generateRawWhere("o"));
        if (this._orderByFields != null) {
            out.print(" ORDER BY ");
            for (int i = 0; i < this._orderByFields.size(); ++i) {
                if (i != 0) {
                    out.print(", ");
                }
                out.print("c." + this._orderByFields.get(i));
                if (!Boolean.FALSE.equals(this._orderByAscending.get(i))) continue;
                out.print(" DESC");
            }
        }
        out.println("\";");
        out.println("query = __caucho_session.prepareQuery(sql);");
        out.println("int index = 1;");
        this.getRelatedType().getId().generateSet(out, "query", "index", "this");
        out.print(var);
        out.print(" = " + newEmptyCollection + ";");
        out.println();
        out.println();
        out.println("return " + var + ";");
        out.popDepth();
        out.println("} catch (Exception e) {");
        out.println("  throw com.caucho.amber.AmberRuntimeException.create(e);");
        out.println("}");
        out.popDepth();
        out.println("}");
        this.generateAmberAdd(out);
        this.generateAmberRemove(out);
        this.generateAmberRemoveTargetAll(out);
    }

    private void generateAdd(JavaWriter out) throws IOException {
        JType type = this.getJavaType();
        JType[] paramArgs = type.getActualTypeArguments();
        String gType = paramArgs.length > 0 ? paramArgs[0].getPrintName() : "Object";
        out.println("public boolean add(" + gType + " o)");
        out.println("{");
        out.pushDepth();
        String ownerType = this.getRelatedType().getInstanceClassName();
        out.println("if (! (o instanceof " + ownerType + "))");
        out.println("  throw new java.lang.IllegalArgumentException((o == null ? \"null\" : o.getClass().getName()) + \" must be a " + ownerType + "\");");
        out.println(ownerType + " bean = (" + ownerType + ") o;");
        out.println("return true;");
        out.popDepth();
        out.println("}");
    }

    private void generateRemove(JavaWriter out) throws IOException {
        JType type = this.getJavaType();
        JType[] paramArgs = type.getActualTypeArguments();
        String gType = paramArgs.length > 0 ? paramArgs[0].getPrintName() : "Object";
        out.println("public boolean remove(" + gType + " o)");
        out.println("{");
        out.pushDepth();
        String ownerType = this.getSourceType().getInstanceClassName();
        out.println("if (! (o instanceof " + ownerType + "))");
        out.println("  throw new java.lang.IllegalArgumentException((o == null ? \"null\" : o.getClass().getName()) + \" must be a " + ownerType + "\");");
        out.println(ownerType + " bean = (" + ownerType + ") o;");
        out.println("return true;");
        out.popDepth();
        out.println("}");
    }

    private void generateClear(JavaWriter out) throws IOException {
        out.println("public void clear()");
        out.println("{");
        out.pushDepth();
        out.println("if (__caucho_session != null) {");
        out.pushDepth();
        out.println("try {");
        out.pushDepth();
        out.println("__caucho_session.flushNoChecks();");
        out.print("String sql=\"");
        out.print("UPDATE ");
        out.print(this.getSourceType().getName());
        out.print(" SET ");
        out.print(" WHERE ");
        out.println("\";");
        out.println("com.caucho.amber.AmberQuery query;");
        out.println("query = __caucho_session.prepareQuery(sql);");
        String ownerType = this.getSourceType().getInstanceClassName();
        out.println("int index = 1;");
        this.getRelatedType().getId().generateSet(out, "query", "index", ownerType + ".this");
        out.println("query.executeUpdate();");
        out.println("super.clear();");
        out.popDepth();
        out.println("} catch (java.sql.SQLException e) {");
        out.println("  throw com.caucho.amber.AmberRuntimeException.create(e);");
        out.println("}");
        out.popDepth();
        out.println("} else {");
        out.println("  super.clear();");
        out.println("}");
        out.popDepth();
        out.println("}");
    }

    private void generateSize(JavaWriter out) throws IOException {
        out.println("public int size()");
        out.println("{");
        out.pushDepth();
        out.println("if (__caucho_session == null || isValid())");
        out.println("  return super.size();");
        out.println("try {");
        out.pushDepth();
        out.println("__caucho_session.flushNoChecks();");
        out.print("String sql=\"");
        out.print("SELECT count(*) FROM ");
        out.print(this.getSourceType().getName());
        out.print(" AS o ");
        out.print(" WHERE ");
        out.println("\";");
        out.println("com.caucho.amber.AmberQuery query;");
        out.println("query = __caucho_session.prepareQuery(sql);");
        out.println("int index = 1;");
        this.getRelatedType().getId().generateSet(out, "query", this.getSourceType().getInstanceClassName() + ".this", "index");
        out.println("java.sql.ResultSet rs = query.executeQuery();");
        out.println("if (rs.next())");
        out.println("  return rs.getInt(1);");
        out.println("else");
        out.println("  return 0;");
        out.popDepth();
        out.println("} catch (java.sql.SQLException e) {");
        out.println("  throw com.caucho.amber.AmberRuntimeException.create(e);");
        out.println("}");
        out.popDepth();
        out.println("}");
    }

    @Override
    public void generatePostCascade(JavaWriter out, String aConn, CascadeType cascadeType) throws IOException {
        if (cascadeType != CascadeType.PERSIST && cascadeType != CascadeType.REMOVE) {
            return;
        }
        if (this.isCascade(cascadeType)) {
            out.println("if (__caucho_state.ordinal() <= com.caucho.amber.entity.EntityState.P_TRANSACTIONAL.ordinal()) {");
            out.pushDepth();
            String amberCascade = "__amber_" + this.getGetterName();
            amberCascade = cascadeType == CascadeType.PERSIST ? amberCascade + "_add" : amberCascade + "_remove";
            String getter = "_caucho_field_" + this.getGetterName();
            out.println("if (" + getter + " != null) {");
            out.pushDepth();
            if (cascadeType == CascadeType.PERSIST) {
                out.println("if (__caucho_state == com.caucho.amber.entity.EntityState.P_PERSISTING)");
                out.println("  __caucho_create(__caucho_session, __caucho_home);");
            }
            out.println();
            out.println("for (Object o : " + getter + ") {");
            out.pushDepth();
            if (cascadeType == CascadeType.PERSIST) {
                out.println("((com.caucho.amber.entity.Entity) o).__caucho_flush();");
                out.println(amberCascade + "(aConn, o);");
            } else {
                out.println(amberCascade + "(o);");
            }
            out.popDepth();
            out.println("}");
            out.popDepth();
            out.println("}");
            out.popDepth();
            out.println("}");
        }
    }

    public void generateAmberAdd(JavaWriter out) throws IOException {
        String targetType = this.getTargetType().getJavaTypeName();
        out.println();
        out.println("public boolean __amber_" + this.getGetterName() + "_add(com.caucho.amber.manager.AmberConnection aConn, Object o)");
        out.println("{");
        out.pushDepth();
        out.println("if (! (o instanceof " + targetType + "))");
        out.println("  return false;");
        out.println();
        out.println(targetType + " v = (" + targetType + ") o;");
        out.println();
        out.println("if (aConn == null)");
        out.println("  return false;");
        out.println();
        out.print("String sql = \"INSERT INTO ");
        out.print(this._associationTable.getName() + " (");
        out.print(this._sourceLink.generateSelectSQL(null));
        out.print(") VALUES (");
        int count = this.getRelatedType().getId().getKeyCount();
        for (int i = 0; i < count; ++i) {
            if (i != 0) {
                out.print(", ");
            }
            out.print("?");
        }
        out.println(")\";");
        out.println();
        out.println("try {");
        out.pushDepth();
        out.println("java.sql.PreparedStatement pstmt = aConn.prepareInsertStatement(sql, false);");
        out.println("int index = 1;");
        this.getRelatedType().getId().generateSet(out, "pstmt", "index", "this");
        out.popDepth();
        out.println("} catch (Exception e) {");
        out.println("  __caucho_log.log(java.util.logging.Level.FINE, e.toString(), e);");
        out.println("}");
        out.println("return false;");
        out.popDepth();
        out.println("}");
    }

    public void generateAmberRemove(JavaWriter out) throws IOException {
        String targetType = this.getTargetType().getJavaTypeName();
        out.println();
        out.println("public boolean __amber_" + this.getGetterName() + "_remove(Object o)");
        out.println("{");
        out.pushDepth();
        out.println("if (! (o instanceof " + targetType + "))");
        out.println("  return false;");
        out.println();
        out.println(targetType + " v = (" + targetType + ") o;");
        out.println();
        out.println("if (__caucho_session == null)");
        out.println("  return false;");
        out.println();
        out.print("String sql = \"DELETE FROM ");
        out.print(this._associationTable.getName() + " WHERE ");
        out.print(this._sourceLink.generateMatchArgSQL(null));
        out.println("\";");
        out.println();
        out.println("try {");
        out.pushDepth();
        out.println("java.sql.PreparedStatement pstmt = __caucho_session.prepareStatement(sql);");
        out.println("int index = 1;");
        this.getRelatedType().getId().generateSet(out, "pstmt", "index", "this");
        out.popDepth();
        out.println("} catch (Exception e) {");
        out.println("  __caucho_log.log(java.util.logging.Level.FINE, e.toString(), e);");
        out.println("}");
        out.println("return false;");
        out.popDepth();
        out.println("}");
    }

    public void generateAmberRemoveTargetAll(JavaWriter out) throws IOException {
        String targetType = this.getTargetType().getJavaTypeName();
        out.println();
        out.println("public boolean __amber_" + this.getGetterName() + "_remove_target(Object o)");
        out.println("{");
        out.pushDepth();
        out.println("if (! (o instanceof " + targetType + "))");
        out.println("  return false;");
        out.println();
        out.println(targetType + " v = (" + targetType + ") o;");
        out.println();
        out.println("if (__caucho_session == null)");
        out.println("  return false;");
        out.println();
        out.print("String sql = \"DELETE FROM ");
        out.print(this._associationTable.getName() + " WHERE ");
        out.println("\";");
        out.println();
        out.println("try {");
        out.pushDepth();
        out.println("java.sql.PreparedStatement pstmt = __caucho_session.prepareStatement(sql);");
        out.println("int index = 1;");
        out.println("if (pstmt.executeUpdate() == 1)");
        out.println("  return true;");
        out.popDepth();
        out.println("} catch (Exception e) {");
        out.println("  __caucho_log.log(java.util.logging.Level.FINE, e.toString(), e);");
        out.println("}");
        out.println("return false;");
        out.popDepth();
        out.println("}");
    }

    @Override
    public void generateSetterMethod(JavaWriter out) throws IOException {
        JType param2;
        JType[] paramArgs;
        JType type;
        ClassLoader loader = this.getSourceType().getPersistenceUnit().getTempClassLoader();
        if (!this.getSourceType().isFieldAccess()) {
            type = JTypeWrapper.create((Type)this.getGetterMethod().getGenericReturnType(), (ClassLoader)loader);
        } else {
            Field field = EntityType.getField(this.getBeanClass(), this.getName());
            type = JTypeWrapper.create((Type)field.getGenericType(), (ClassLoader)loader);
        }
        out.println();
        out.print("public void " + this.getSetterName() + "(");
        out.println(type.getPrintName() + " value)");
        out.println("{");
        out.pushDepth();
        out.println("if (" + this.generateSuperGetter("this") + " == value)");
        out.println("  return;");
        out.println();
        out.println("try {");
        out.pushDepth();
        String var = "_caucho_field_" + this.getGetterName();
        out.print(var + " = new ");
        type = this.getJavaType();
        boolean isSet = type.isAssignableTo(Set.class);
        boolean isMap = false;
        if (!isSet) {
            isMap = type.isAssignableTo(Map.class);
        }
        JType param = (paramArgs = type.getActualTypeArguments()).length > 0 ? paramArgs[0] : null;
        JType jType = param2 = paramArgs.length > 1 ? paramArgs[1] : null;
        String collectionImpl = isSet ? "com.caucho.amber.collection.SetImpl" : (isMap ? "com.caucho.amber.collection.MapImpl" : "com.caucho.amber.collection.CollectionImpl");
        out.print(collectionImpl);
        if (param != null) {
            out.print("<");
            out.print(param.getPrintName());
            if (isMap && param2 != null) {
                out.print(", ");
                out.print(param2.getPrintName());
            }
            out.print(">");
        }
        out.print("(__caucho_session, null");
        if (isMap) {
            out.print(", ");
            out.print(this.getTargetType().getJavaTypeName());
            out.print(".class.getDeclaredMethod(\"get");
            String getterMapKey = this.getMapKey();
            getterMapKey = Character.toUpperCase(getterMapKey.charAt(0)) + getterMapKey.substring(1);
            out.print(getterMapKey);
            out.print("\")");
        }
        out.println(");");
        out.print(var + ".");
        if (isMap) {
            out.println("putAll(value);");
        } else {
            out.println("addAll(0, value);");
        }
        out.popDepth();
        out.println("} catch(Exception e) {");
        out.println("  throw com.caucho.amber.AmberRuntimeException.create(e);");
        out.println("}");
        out.popDepth();
        out.println("}");
    }

    @Override
    public void generateInvalidateForeign(JavaWriter out) throws IOException {
        out.println("if (\"" + this._sourceLink.getSourceTable().getName() + "\".equals(table)) {");
        out.pushDepth();
        this.generateExpire(out);
        out.popDepth();
        out.println("}");
    }

    @Override
    public void generateExpire(JavaWriter out) throws IOException {
        String var = "_caucho_field_" + this.getGetterName();
        out.println("if (" + var + " != null)");
        out.println("  " + var + ".update();");
    }

    @Override
    public void generateDetach(JavaWriter out) throws IOException {
        String var = "_caucho_field_" + this.getGetterName();
        out.println("if (" + var + " != null)");
        out.println("  " + var + ".detach();");
    }

    private String generateAccessor(String src, String var) {
        if (src.equals("super")) {
            return var;
        }
        return "((" + this.getRelatedType().getInstanceClassName() + ") " + src + ")." + var;
    }
}

