/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.field;

import com.caucho.amber.field.AbstractField;
import com.caucho.amber.field.ManyToOneField;
import com.caucho.amber.type.EntityType;
import com.caucho.config.ConfigException;
import com.caucho.java.JavaWriter;
import com.caucho.util.L10N;
import java.io.IOException;
import java.util.logging.Logger;
import javax.persistence.CascadeType;

public abstract class CascadableField
extends AbstractField {
    private static final L10N L = new L10N(CascadableField.class);
    private static final Logger log = Logger.getLogger(CascadableField.class.getName());
    private CascadeType[] _cascadeTypes;

    CascadableField(EntityType sourceType) {
        super(sourceType);
    }

    CascadableField(EntityType sourceType, String name, CascadeType[] cascadeTypes) throws ConfigException {
        super(sourceType, name);
        this._cascadeTypes = cascadeTypes;
    }

    public boolean isCascade(CascadeType cascade) {
        if (this._cascadeTypes == null) {
            return false;
        }
        for (int i = 0; i < this._cascadeTypes.length; ++i) {
            if (this._cascadeTypes[i] == CascadeType.ALL) {
                return true;
            }
            if (this._cascadeTypes[i] != cascade) continue;
            return true;
        }
        return false;
    }

    public void setCascadeType(CascadeType[] cascadeTypes) {
        this._cascadeTypes = cascadeTypes;
    }

    public CascadeType[] getCascadeType() {
        return this._cascadeTypes;
    }

    public void generatePreCascade(JavaWriter out, String aConn, CascadeType cascadeType) throws IOException {
        if (cascadeType != CascadeType.PERSIST) {
            return;
        }
        this.generateInternalCascade(out, aConn, cascadeType);
    }

    public void generatePostCascade(JavaWriter out, String aConn, CascadeType cascadeType) throws IOException {
        if (cascadeType == CascadeType.PERSIST) {
            return;
        }
        this.generateInternalCascade(out, aConn, cascadeType);
    }

    @Override
    public boolean isCascadable() {
        return true;
    }

    public boolean generateFlushCheck(JavaWriter out) throws IOException {
        return false;
    }

    protected void generateInternalCascade(JavaWriter out, String aConn, CascadeType cascadeType) throws IOException {
        if (this.isCascade(cascadeType)) {
            String getter = this.generateSuperGetter("this");
            out.println("if (" + getter + " != null) {");
            out.pushDepth();
            out.print(aConn + ".");
            switch (cascadeType) {
                case PERSIST: {
                    out.print("persistFromCascade");
                    break;
                }
                case MERGE: {
                    out.print("merge");
                    break;
                }
                case REMOVE: {
                    out.print("remove");
                    break;
                }
                case REFRESH: {
                    out.print("refresh");
                }
            }
            out.println("(" + getter + ");");
            if (cascadeType == CascadeType.PERSIST && this instanceof ManyToOneField) {
                out.println("((com.caucho.amber.entity.Entity) " + getter + ").__caucho_flush();");
            }
            out.popDepth();
            out.println("}");
        }
    }
}

