/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.expr;

import com.caucho.amber.expr.AbstractAmberExpr;
import com.caucho.amber.expr.AmberExpr;
import com.caucho.amber.expr.ManyToOneExpr;
import com.caucho.amber.query.FromItem;
import com.caucho.amber.query.QueryParser;
import com.caucho.amber.table.ForeignColumn;
import com.caucho.util.CharBuffer;
import java.util.ArrayList;

public class UnaryExpr
extends AbstractAmberExpr {
    private AmberExpr _expr;
    private int _token;

    public UnaryExpr(int token, AmberExpr expr) {
        this._token = token;
        this._expr = expr;
    }

    @Override
    public boolean isBoolean() {
        return this._token == 174 || this._token == 139 || this._token == 200;
    }

    public Class getJavaType() {
        switch (this._token) {
            case 139: 
            case 174: {
                return Boolean.TYPE;
            }
        }
        return Double.TYPE;
    }

    @Override
    public AmberExpr bindSelect(QueryParser parser) {
        this._expr = this._expr.bindSelect(parser);
        return this;
    }

    @Override
    public boolean usesFrom(FromItem from, int type, boolean isNot) {
        switch (this._token) {
            case 43: 
            case 45: 
            case 139: 
            case 200: {
                return this._expr.usesFrom(from, type);
            }
            case 174: {
                return this._expr.usesFrom(from, type, !isNot);
            }
        }
        return false;
    }

    @Override
    public void generateWhere(CharBuffer cb) {
        this.generateInternalWhere(cb, true);
    }

    @Override
    public void generateUpdateWhere(CharBuffer cb) {
        this.generateInternalWhere(cb, false);
    }

    @Override
    public void generateHaving(CharBuffer cb) {
        this.generateWhere(cb);
    }

    public String toString() {
        String str = null;
        switch (this._token) {
            case 45: {
                str = "-";
                break;
            }
            case 43: {
                str = "+";
                break;
            }
            case 174: {
                str = "not";
                break;
            }
            case 139: {
                return this._expr + " is null";
            }
            case 200: {
                return this._expr + " is not null";
            }
        }
        return str + " " + this._expr;
    }

    private void generateInternalWhere(CharBuffer cb, boolean select) {
        switch (this._token) {
            case 45: {
                cb.append(" -");
                break;
            }
            case 43: {
                cb.append(" +");
                break;
            }
            case 174: {
                cb.append("NOT ");
                break;
            }
            case 139: 
            case 200: {
                if (this._expr instanceof ManyToOneExpr) {
                    ManyToOneExpr path = (ManyToOneExpr)this._expr;
                    cb.append('(');
                    ArrayList<ForeignColumn> keys = path.getLinkColumns().getColumns();
                    for (int i = 0; i < keys.size(); ++i) {
                        if (i != 0) {
                            cb.append(" and ");
                        }
                        cb.append(path.getFromItem().getName());
                        cb.append(".");
                        cb.append(keys.get(i).getName());
                        if (this._token == 139) {
                            cb.append(" is null");
                            continue;
                        }
                        cb.append(" is not null");
                    }
                    cb.append(')');
                } else {
                    if (select) {
                        this._expr.generateWhere(cb);
                    } else {
                        this._expr.generateUpdateWhere(cb);
                    }
                    if (this._token == 139) {
                        cb.append(" is null");
                    } else {
                        cb.append(" is not null");
                    }
                }
                return;
            }
        }
        if (select) {
            this._expr.generateWhere(cb);
        } else {
            this._expr.generateUpdateWhere(cb);
        }
    }
}

