/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.expr;

import com.caucho.amber.expr.AbstractAmberExpr;
import com.caucho.amber.expr.AmberExpr;
import com.caucho.amber.expr.ArgExpr;
import com.caucho.amber.expr.CollectionIdExpr;
import com.caucho.amber.expr.IdExpr;
import com.caucho.amber.expr.JoinExpr;
import com.caucho.amber.expr.ManyToOneExpr;
import com.caucho.amber.expr.ManyToOneJoinExpr;
import com.caucho.amber.expr.OneToManyExpr;
import com.caucho.amber.expr.PathExpr;
import com.caucho.amber.expr.UnaryExpr;
import com.caucho.amber.query.FromItem;
import com.caucho.amber.query.QueryParser;
import com.caucho.amber.table.AmberColumn;
import com.caucho.amber.table.AmberTable;
import com.caucho.amber.table.ForeignColumn;
import com.caucho.amber.table.LinkColumns;
import com.caucho.util.CharBuffer;
import java.util.ArrayList;

public class MemberExpr
extends AbstractAmberExpr {
    private boolean _isNot;
    private AmberExpr _itemExpr;
    private AmberExpr _collectionExpr;

    private MemberExpr(AmberExpr itemExpr, AmberExpr collectionExpr, boolean isNot) {
        this._itemExpr = itemExpr;
        this._collectionExpr = collectionExpr;
        this._isNot = isNot;
    }

    public static AmberExpr create(QueryParser parser, AmberExpr itemExpr, AmberExpr collectionExpr, boolean isNot) {
        if (collectionExpr instanceof IdExpr) {
            collectionExpr = ((CollectionIdExpr)collectionExpr).getPath();
        }
        if (!(itemExpr instanceof ArgExpr) && !(itemExpr instanceof ManyToOneExpr) && collectionExpr instanceof OneToManyExpr) {
            OneToManyExpr oneToMany = (OneToManyExpr)collectionExpr;
            PathExpr parent = oneToMany.getParent();
            FromItem childFromItem = ((PathExpr)itemExpr).getChildFromItem();
            ManyToOneJoinExpr expr = new ManyToOneJoinExpr(oneToMany.getLinkColumns(), childFromItem, parent.getChildFromItem());
            if (isNot) {
                return new UnaryExpr(174, expr);
            }
            return expr;
        }
        return new MemberExpr(itemExpr, collectionExpr, isNot);
    }

    @Override
    public AmberExpr bindSelect(QueryParser parser) {
        return this;
    }

    @Override
    public boolean isBoolean() {
        return true;
    }

    @Override
    public boolean usesFrom(FromItem from, int type, boolean isNot) {
        if (!(this._itemExpr instanceof PathExpr)) {
            return false;
        }
        return this._collectionExpr.usesFrom(from, type) || ((PathExpr)this._itemExpr).usesFrom(from, type);
    }

    @Override
    public AmberExpr replaceJoin(JoinExpr join) {
        if (this._itemExpr instanceof PathExpr) {
            this._collectionExpr = this._collectionExpr.replaceJoin(join);
            this._itemExpr = (PathExpr)this._itemExpr.replaceJoin(join);
        }
        return this;
    }

    @Override
    public void generateWhere(CharBuffer cb) {
        this.generateInternalWhere(cb, true);
    }

    @Override
    public void generateUpdateWhere(CharBuffer cb) {
        this.generateInternalWhere(cb, false);
    }

    @Override
    public void generateHaving(CharBuffer cb) {
        this.generateWhere(cb);
    }

    private void generateInternalWhere(CharBuffer cb, boolean select) {
        OneToManyExpr oneToMany = null;
        if (this._collectionExpr instanceof ManyToOneExpr) {
            PathExpr expr = ((ManyToOneExpr)this._collectionExpr).getParent();
            if (expr instanceof OneToManyExpr) {
                oneToMany = (OneToManyExpr)expr;
            }
        } else if (this._collectionExpr instanceof OneToManyExpr) {
            oneToMany = (OneToManyExpr)this._collectionExpr;
        } else {
            throw new UnsupportedOperationException();
        }
        LinkColumns join = oneToMany.getLinkColumns();
        if (this._isNot) {
            cb.append("NOT ");
        }
        ForeignColumn fk = join.getColumns().get(0);
        cb.append(oneToMany.getParent().getChildFromItem().getName());
        cb.append('.');
        cb.append(fk.getTargetColumn().getName());
        cb.append(" IN (SELECT ");
        cb.append(fk.getName());
        AmberTable table = join.getSourceTable();
        cb.append(" FROM " + table.getName() + " caucho");
        cb.append(" WHERE ");
        String targetTable = oneToMany.getParent().getChildFromItem().getName();
        cb.append(join.generateJoin("caucho", targetTable));
        if (this._itemExpr instanceof ArgExpr) {
            cb.append(" AND caucho.");
            if (this._collectionExpr instanceof ManyToOneExpr) {
                join = ((ManyToOneExpr)this._collectionExpr).getLinkColumns();
                String name = join.getColumns().get(0).getName();
                cb.append(name);
            } else {
                ArrayList<AmberColumn> idColumns = join.getSourceTable().getIdColumns();
                cb.append(idColumns.get(0).getName());
            }
            cb.append(" = ?");
        } else if (this._collectionExpr instanceof ManyToOneExpr) {
            String where;
            join = ((ManyToOneExpr)this._collectionExpr).getLinkColumns();
            boolean isArg = false;
            if (this._itemExpr instanceof ManyToOneExpr) {
                LinkColumns manyToOneJoin = ((ManyToOneExpr)this._itemExpr).getLinkColumns();
                String itemWhere = ((ManyToOneExpr)this._itemExpr).getParent().getChildFromItem().getName();
                where = join.generateJoin(manyToOneJoin, "caucho", itemWhere);
            } else {
                String itemWhere;
                if (this._itemExpr instanceof PathExpr) {
                    itemWhere = ((PathExpr)this._itemExpr).getChildFromItem().getName();
                } else {
                    isArg = true;
                    itemWhere = "?";
                }
                where = join.generateJoin("caucho", itemWhere, isArg);
            }
            cb.append(" AND " + where);
        } else if (this._collectionExpr instanceof OneToManyExpr) {
            if (this._itemExpr instanceof ManyToOneExpr) {
                join = ((ManyToOneExpr)this._itemExpr).getLinkColumns();
                String itemWhere = ((ManyToOneExpr)this._itemExpr).getParent().getChildFromItem().getName();
                String where = join.generateJoin(itemWhere, "caucho");
                cb.append(" AND " + where);
            } else {
                ArrayList<AmberColumn> idColumns = join.getSourceTable().getIdColumns();
                String id = idColumns.get(0).getName();
                cb.append(" AND (caucho." + id + " = ");
                FromItem childFromItem = ((PathExpr)this._itemExpr).getChildFromItem();
                if (childFromItem != null) {
                    cb.append(childFromItem.getName() + ".");
                    idColumns = childFromItem.getTable().getIdColumns();
                    cb.append(idColumns.get(0).getName() + ")");
                }
            }
        }
        cb.append(')');
    }
}

