/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.expr;

import com.caucho.amber.expr.AmberColumnExpr;
import com.caucho.amber.expr.AmberExpr;
import com.caucho.amber.expr.IdExpr;
import com.caucho.amber.expr.IdFieldExpr;
import com.caucho.amber.expr.JoinExpr;
import com.caucho.amber.query.FromItem;
import com.caucho.amber.query.QueryParser;
import com.caucho.amber.table.AmberColumn;
import com.caucho.util.CharBuffer;
import java.util.ArrayList;

public class EqualJoinExpr
extends JoinExpr {
    private ArrayList<AmberColumn> _keyColumns;
    private FromItem _fromItemA;
    private FromItem _fromItemB;

    EqualJoinExpr(ArrayList<AmberColumn> keyColumns, FromItem fromItemA, FromItem fromItemB) {
        this._keyColumns = keyColumns;
        this._fromItemA = fromItemA;
        this._fromItemB = fromItemB;
        if (fromItemA == null || fromItemB == null) {
            throw new NullPointerException();
        }
    }

    @Override
    public boolean isBoolean() {
        return true;
    }

    @Override
    public AmberExpr bindSelect(QueryParser parser) {
        return this;
    }

    @Override
    public boolean bindToFromItem() {
        if (this._fromItemA.getJoinExpr() == null || this._fromItemA.getJoinExpr().equals(this)) {
            this._fromItemA.setJoinExpr(this);
            return true;
        }
        if (this._fromItemB.getJoinExpr() == null) {
            this._fromItemB.setJoinExpr(this);
            return true;
        }
        return false;
    }

    @Override
    public FromItem getJoinTarget() {
        return this._fromItemA;
    }

    public AmberExpr replace(IdFieldExpr id) {
        IdExpr parent = (IdExpr)id.getParent();
        if (parent.getFromItem() == this._fromItemA) {
            return new AmberColumnExpr(new IdExpr(this._fromItemA), id.getColumn());
        }
        if (parent.getFromItem() == this._fromItemB) {
            return new AmberColumnExpr(new IdExpr(this._fromItemB), id.getColumn());
        }
        return id;
    }

    @Override
    public AmberExpr replace(IdExpr id) {
        return id;
    }

    @Override
    public void generateWhere(CharBuffer cb) {
        this.generateInternalWhere(cb, true);
    }

    @Override
    public void generateUpdateWhere(CharBuffer cb) {
        this.generateInternalWhere(cb, false);
    }

    @Override
    public void generateHaving(CharBuffer cb) {
        this.generateWhere(cb);
    }

    public boolean equals(Object o) {
        if (!(o instanceof EqualJoinExpr)) {
            return false;
        }
        EqualJoinExpr equalExpr = (EqualJoinExpr)o;
        return this._keyColumns.equals(equalExpr._keyColumns) && this._fromItemA.equals(equalExpr._fromItemA) && this._fromItemB.equals(equalExpr._fromItemB);
    }

    public String toString() {
        return "EqualJoinExpr[" + this._keyColumns + "," + this._fromItemA + "," + this._fromItemB + "]";
    }

    private void generateInternalWhere(CharBuffer cb, boolean select) {
        cb.append('(');
        for (int i = 0; i < this._keyColumns.size(); ++i) {
            AmberColumn column = this._keyColumns.get(i);
            if (i != 0) {
                cb.append(" AND ");
            }
            cb.append(this._fromItemA.getName());
            cb.append('.');
            cb.append(column.getName());
            cb.append('=');
            cb.append(this._fromItemB.getName());
            cb.append('.');
            cb.append(column.getName());
        }
        cb.append('(');
    }
}

