/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.expr;

import com.caucho.amber.expr.AbstractAmberExpr;
import com.caucho.amber.expr.AmberExpr;
import com.caucho.amber.query.FromItem;
import com.caucho.amber.query.QueryParser;
import com.caucho.amber.type.AmberType;
import com.caucho.amber.type.BooleanType;
import com.caucho.util.CharBuffer;

public class BetweenExpr
extends AbstractAmberExpr {
    private AmberExpr _expr;
    private AmberExpr _min;
    private AmberExpr _max;
    private boolean _isNot;

    public BetweenExpr(AmberExpr expr, AmberExpr min, AmberExpr max, boolean isNot) {
        this._expr = expr;
        this._min = min;
        this._max = max;
        this._isNot = isNot;
    }

    @Override
    public boolean isBoolean() {
        return true;
    }

    @Override
    public AmberType getType() {
        return BooleanType.create();
    }

    @Override
    public AmberExpr bindSelect(QueryParser parser) {
        this._expr = this._expr.bindSelect(parser);
        this._min = this._min.bindSelect(parser);
        this._max = this._max.bindSelect(parser);
        return this;
    }

    @Override
    public boolean usesFrom(FromItem from, int type, boolean isNot) {
        return this._expr.usesFrom(from, type) || this._min.usesFrom(from, type) || this._max.usesFrom(from, type);
    }

    @Override
    public void generateWhere(CharBuffer cb) {
        this.generateInternalWhere(cb, true);
    }

    @Override
    public void generateUpdateWhere(CharBuffer cb) {
        this.generateInternalWhere(cb, false);
    }

    private void generateInternalWhere(CharBuffer cb, boolean select) {
        cb.append('(');
        if (select) {
            this._expr.generateWhere(cb);
        } else {
            this._expr.generateUpdateWhere(cb);
        }
        if (this._isNot) {
            cb.append(" NOT");
        }
        cb.append(" BETWEEN ");
        if (select) {
            this._min.generateWhere(cb);
        } else {
            this._min.generateUpdateWhere(cb);
        }
        cb.append(" AND ");
        if (select) {
            this._max.generateWhere(cb);
        } else {
            this._max.generateUpdateWhere(cb);
        }
        cb.append(')');
    }

    @Override
    public void generateHaving(CharBuffer cb) {
        this.generateWhere(cb);
    }

    public String toString() {
        CharBuffer cb = CharBuffer.allocate();
        cb.append('(');
        cb.append((Object)this._expr);
        if (this._isNot) {
            cb.append(" NOT");
        }
        cb.append(" BETWEEN ");
        cb.append((Object)this._min);
        cb.append(" AND ");
        cb.append((Object)this._max);
        cb.append(')');
        return cb.close();
    }
}

