/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.cfg;

import com.caucho.amber.cfg.AbstractRelationConfig;
import com.caucho.amber.cfg.BaseConfigIntrospector;
import com.caucho.amber.cfg.JoinColumnConfig;
import com.caucho.amber.field.ManyToOneField;
import com.caucho.amber.manager.AmberPersistenceUnit;
import com.caucho.amber.type.EntityType;
import com.caucho.amber.type.MappedSuperclassType;
import com.caucho.config.ConfigException;
import com.caucho.util.L10N;
import java.lang.reflect.AccessibleObject;
import java.util.HashMap;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;

class ManyToOneConfig
extends AbstractRelationConfig {
    private static final L10N L = new L10N(ManyToOneConfig.class);
    private BaseConfigIntrospector _introspector;
    private EntityType _sourceType;
    private EntityType _targetType;
    private AccessibleObject _field;
    private String _fieldName;
    private Class _fieldType;
    private boolean _isOptional = true;
    private HashMap<String, JoinColumnConfig> _joinColumnMap = new HashMap();

    ManyToOneConfig(BaseConfigIntrospector introspector, EntityType sourceType, AccessibleObject field, String fieldName, Class fieldType) {
        this._introspector = introspector;
        this._sourceType = sourceType;
        this._field = field;
        this._fieldName = fieldName;
        this._fieldType = fieldType;
        this.introspect();
    }

    public boolean getOptional() {
        return this._isOptional;
    }

    public void setOptional(boolean isOptional) {
        this._isOptional = isOptional;
    }

    public JoinColumnConfig getJoinColumn(String name) {
        return this._joinColumnMap.get(name);
    }

    public void addJoinColumn(JoinColumnConfig joinColumn) {
        this._joinColumnMap.put(joinColumn.getReferencedColumnName(), joinColumn);
    }

    public HashMap<String, JoinColumnConfig> getJoinColumnMap() {
        return this._joinColumnMap;
    }

    @Override
    public EntityType getRelatedType() {
        return this._sourceType;
    }

    @Override
    public void complete() throws ConfigException {
        this.addManyToOne();
    }

    private void introspect() {
        ManyToOne manyToOne = this._field.getAnnotation(ManyToOne.class);
        if (manyToOne != null) {
            this.introspectManyToOne(manyToOne);
        }
        JoinColumn joinColumnAnn = this._field.getAnnotation(JoinColumn.class);
        JoinColumns joinColumnsAnn = this._field.getAnnotation(JoinColumns.class);
        if (joinColumnsAnn != null && joinColumnAnn != null) {
            throw ManyToOneConfig.error(this._field, L.l("{0} may not have both @JoinColumn and @JoinColumns", (Object)this._fieldName));
        }
        if (joinColumnsAnn != null) {
            this.introspectJoinColumns(joinColumnsAnn.value());
        } else if (joinColumnAnn != null) {
            this.introspectJoinColumns(new JoinColumn[]{joinColumnAnn});
        }
    }

    private void introspectManyToOne(ManyToOne manyToOne) {
        Class targetClass = manyToOne.targetEntity();
        if (Void.TYPE.equals(targetClass)) {
            targetClass = this._fieldType;
        }
        this.setTargetEntity(targetClass);
        this.setCascadeTypes(manyToOne.cascade());
        this.setFetch(manyToOne.fetch());
        this._isOptional = manyToOne.optional();
    }

    private void introspectJoinColumns(JoinColumn[] joinColumns) {
        for (JoinColumn joinColumn : joinColumns) {
            this.addJoinColumn(new JoinColumnConfig(joinColumn));
        }
    }

    void addManyToOne() throws ConfigException {
        AmberPersistenceUnit persistenceUnit = this._sourceType.getPersistenceUnit();
        String targetName = this._fieldType.getName();
        ManyToOneField manyToOneField = new ManyToOneField(this._sourceType, this._fieldName, this.getCascade(), true);
        EntityType targetType = persistenceUnit.createEntity(this.getTargetEntity());
        manyToOneField.setType(targetType);
        manyToOneField.setLazy(this.isFetchLazy());
        if (this._joinColumnMap.size() > 0) {
            manyToOneField.setJoinColumnMap(this._joinColumnMap);
        }
        this._sourceType.addField(manyToOneField);
        if (this._sourceType instanceof MappedSuperclassType) {
            return;
        }
        if (this._joinColumnMap.size() > 0) {
            this.validateJoinColumns(this._field, this._fieldName, this._joinColumnMap, targetType);
        }
        manyToOneField.init();
    }
}

