/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.cfg;

import com.caucho.amber.cfg.AbstractConfig;
import com.caucho.amber.cfg.CascadeConfig;
import com.caucho.amber.cfg.JoinColumnConfig;
import com.caucho.amber.cfg.JoinTableConfig;
import com.caucho.amber.field.Id;
import com.caucho.amber.field.IdField;
import com.caucho.amber.table.AmberColumn;
import com.caucho.amber.table.AmberTable;
import com.caucho.amber.table.ForeignColumn;
import com.caucho.amber.type.EntityType;
import com.caucho.config.ConfigException;
import com.caucho.util.L10N;
import java.lang.reflect.AccessibleObject;
import java.util.ArrayList;
import java.util.HashMap;
import javax.persistence.CascadeType;
import javax.persistence.FetchType;

abstract class AbstractRelationConfig
extends AbstractConfig {
    private static final L10N L = new L10N(AbstractRelationConfig.class);
    private String _name;
    private Class _targetEntity;
    private FetchType _fetch = FetchType.EAGER;
    private JoinTableConfig _joinTable;
    private CascadeType[] _cascade = new CascadeType[0];

    AbstractRelationConfig() {
    }

    @Override
    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public Class getTargetEntity() {
        return this._targetEntity;
    }

    public void setTargetEntity(Class targetEntity) {
        this._targetEntity = targetEntity;
    }

    public FetchType getFetch() {
        return this._fetch;
    }

    public void setFetch(FetchType fetch) {
        this._fetch = fetch;
    }

    public boolean isFetchLazy() {
        return this._fetch == FetchType.LAZY;
    }

    public CascadeType[] getCascade() {
        return this._cascade;
    }

    protected void setCascadeTypes(CascadeType[] cascade) {
        this._cascade = cascade;
    }

    public void setCascade(CascadeConfig cascade) {
        this._cascade = cascade.getCascadeTypes();
    }

    public JoinTableConfig getJoinTable() {
        return this._joinTable;
    }

    public void setJoinTable(JoinTableConfig joinTable) {
        this._joinTable = joinTable;
    }

    void validateJoinColumns(AccessibleObject field, String fieldName, HashMap<String, JoinColumnConfig> joinColumnMap, EntityType targetType) throws ConfigException {
        int idCols;
        if (joinColumnMap == null) {
            return;
        }
        Id id = targetType.getId();
        EntityType parentType = targetType;
        while ((idCols = id.getKeyCount()) == 0 && (parentType = parentType.getParentType()) != null) {
            id = parentType.getId();
        }
        Object[] joinColumnCfg = null;
        int size = joinColumnMap.size();
        joinColumnCfg = joinColumnMap.values().toArray();
        if (idCols != size) {
            throw AbstractRelationConfig.error(field, L.l("Number of @JoinColumns for '{1}' ({0}) does not match the number of primary key columns for '{3}' ({2}).", (Object)("" + size), (Object)fieldName, (Object)idCols, (Object)targetType.getName()));
        }
        for (int i = 0; i < size; ++i) {
            String ref = ((JoinColumnConfig)joinColumnCfg[i]).getReferencedColumnName();
            if ((ref == null || ref.equals("")) && size > 1) {
                throw AbstractRelationConfig.error(field, L.l("referencedColumnName is required when more than one @JoinColumn is specified."));
            }
            IdField key = this.getKey(id.getKeys(), ref);
            if (key != null) continue;
            throw AbstractRelationConfig.error(field, L.l("referencedColumnName '{0}' does not match any key column in '{1}'.", (Object)ref, (Object)targetType.getName()));
        }
    }

    @Override
    ArrayList<ForeignColumn> calculateColumns(AccessibleObject field, String fieldName, AmberTable mapTable, String prefix, EntityType type, HashMap<String, JoinColumnConfig> joinColumnsConfig) throws ConfigException {
        if (joinColumnsConfig == null || joinColumnsConfig.size() == 0) {
            return AbstractRelationConfig.calculateColumns(mapTable, prefix, type);
        }
        ArrayList<ForeignColumn> columns = new ArrayList<ForeignColumn>();
        if (type.getId() == null) {
            throw AbstractRelationConfig.error(field, L.l("Entity {0} has no primary key defined.", (Object)type.getName()));
        }
        ArrayList<IdField> idFields = type.getId().getKeys();
        int len = joinColumnsConfig.size();
        if (len != idFields.size()) {
            throw AbstractRelationConfig.error(field, L.l("@JoinColumns for {0} do not match number of the primary key columns in {1}.  The foreign key columns must match the primary key columns.", (Object)fieldName, (Object)type.getName()));
        }
        for (JoinColumnConfig joinColumn : joinColumnsConfig.values()) {
            String name = joinColumn.getName();
            String refName = joinColumn.getReferencedColumnName();
            IdField id = this.getField(idFields, refName);
            AmberColumn column = id.getColumns().get(0);
            ForeignColumn foreignColumn = mapTable.createForeignColumn(name, column);
            columns.add(foreignColumn);
        }
        return columns;
    }

    @Override
    IdField getField(ArrayList<IdField> fields, String name) {
        if (fields.size() == 1) {
            return fields.get(0);
        }
        for (IdField field : fields) {
            if (!field.getName().equals(name)) continue;
            return field;
        }
        if (name == null || name.equals("")) {
            throw new ConfigException(L.l("{0}: '{1}' requires a referencedColumnName value because it has multiple target keys.", (Object)this.getTargetEntity(), (Object)this.getName()));
        }
        throw new ConfigException(L.l("{0}: '{1}' is an unknown field for {2}", (Object)this.getTargetEntity(), (Object)name, (Object)this.getName()));
    }

    IdField getKey(ArrayList<IdField> keys, String name) {
        if (keys.size() == 1) {
            return keys.get(0);
        }
        for (IdField key : keys) {
            if (!key.getName().equals(name)) continue;
            return key;
        }
        return null;
    }

    static ArrayList<ForeignColumn> calculateColumns(AmberTable mapTable, String prefix, EntityType type) {
        ArrayList<ForeignColumn> columns = new ArrayList<ForeignColumn>();
        EntityType parentType = type;
        ArrayList<AmberColumn> targetIdColumns = type.getId().getColumns();
        while (targetIdColumns.size() == 0 && (parentType = parentType.getParentType()) != null) {
            targetIdColumns = parentType.getId().getColumns();
        }
        for (AmberColumn key : targetIdColumns) {
            columns.add(mapTable.createForeignColumn(prefix + key.getName(), key));
        }
        return columns;
    }

    @Override
    ArrayList<ForeignColumn> calculateColumns(AmberTable mapTable, EntityType type) {
        ArrayList<ForeignColumn> columns = new ArrayList<ForeignColumn>();
        EntityType parentType = type;
        ArrayList<AmberColumn> targetIdColumns = type.getId().getColumns();
        while (targetIdColumns.size() == 0 && (parentType = parentType.getParentType()) != null) {
            targetIdColumns = parentType.getId().getColumns();
        }
        for (AmberColumn key : targetIdColumns) {
            columns.add(mapTable.createForeignColumn(key.getName(), key));
        }
        return columns;
    }
}

