/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.admin.action;

import com.caucho.admin.action.AdminAction;
import com.caucho.util.Alarm;
import com.caucho.util.AlarmListener;
import com.caucho.util.L10N;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SetLogLevelAction
implements AdminAction {
    private static final Logger log = Logger.getLogger(SetLogLevelAction.class.getName());
    private static final L10N L = new L10N(SetLogLevelAction.class);
    private static ClassLoader _systemClassLoader = ClassLoader.getSystemClassLoader();

    public String execute(String[] loggerNames, Level newLevel, long time) {
        if (time > 0L) {
            final Map<String, Level> oldLevels = SetLogLevelAction.getLoggerLevels(loggerNames);
            AlarmListener listener = new AlarmListener(){

                public void handleAlarm(Alarm alarm) {
                    SetLogLevelAction.setLoggerLevels(oldLevels);
                }
            };
            new Alarm("log-level", listener, time);
        }
        SetLogLevelAction.setLoggerLevels(loggerNames, newLevel);
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < loggerNames.length; ++i) {
            if (loggerNames[i].length() == 0) {
                sb.append("{root}");
            } else {
                sb.append(loggerNames[i]);
            }
            if (i >= loggerNames.length - 1) continue;
            sb.append(", ");
        }
        if (time > 0L) {
            return L.l("Logger '{2}' level is set to '{0}', active time {1} seconds", (Object)newLevel, (Object)(time / 1000L), (Object)sb.toString());
        }
        return L.l("Logger '{1}' level is set to '{0}'", (Object)newLevel, (Object)sb.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setLoggerLevels(String[] loggerNames, Level level) {
        Thread thread = Thread.currentThread();
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            thread.setContextClassLoader(_systemClassLoader);
            for (String loggerName : loggerNames) {
                Logger logger = Logger.getLogger(loggerName);
                logger.setLevel(level);
            }
        }
        finally {
            thread.setContextClassLoader(loader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setLoggerLevels(Map<String, Level> levelsMap) {
        Thread thread = Thread.currentThread();
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            thread.setContextClassLoader(_systemClassLoader);
            for (Map.Entry<String, Level> entry : levelsMap.entrySet()) {
                Logger logger = Logger.getLogger(entry.getKey());
                logger.setLevel(entry.getValue());
            }
        }
        finally {
            thread.setContextClassLoader(loader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, Level> getLoggerLevels(String[] loggerNames) {
        HashMap<String, Level> oldLevels = new HashMap<String, Level>();
        Thread thread = Thread.currentThread();
        ClassLoader loader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(_systemClassLoader);
            for (String loggerName : loggerNames) {
                Logger logger = Logger.getLogger(loggerName);
                Level level = logger.getLevel();
                oldLevels.put(loggerName, level);
            }
        }
        finally {
            thread.setContextClassLoader(loader);
        }
        return oldLevels;
    }
}

