/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.admin.action;

import com.caucho.admin.action.AdminAction;
import com.caucho.config.ConfigException;
import com.caucho.hemp.services.MailService;
import com.caucho.quercus.QuercusContext;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.page.QuercusPage;
import com.caucho.quercus.servlet.api.QuercusHttpServletRequest;
import com.caucho.quercus.servlet.api.QuercusHttpServletRequestImpl;
import com.caucho.quercus.servlet.api.QuercusHttpServletResponse;
import com.caucho.quercus.servlet.api.QuercusHttpServletResponseImpl;
import com.caucho.server.http.StubServletRequest;
import com.caucho.server.http.StubServletResponse;
import com.caucho.server.resin.Resin;
import com.caucho.util.CurrentTime;
import com.caucho.util.IoUtil;
import com.caucho.util.L10N;
import com.caucho.util.QDate;
import com.caucho.vfs.Path;
import com.caucho.vfs.StreamImpl;
import com.caucho.vfs.TempOutputStream;
import com.caucho.vfs.TempStream;
import com.caucho.vfs.Vfs;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.mail.Address;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class PdfReportAction
implements AdminAction {
    private static final L10N L = new L10N(PdfReportAction.class);
    private static final Logger log = Logger.getLogger(PdfReportAction.class.getName());
    private static final long HOUR = 3600000L;
    private static final long DAY = 86400000L;
    private String _serverId;
    private String _logDirectory;
    private String _path;
    private long _period;
    private String _report;
    private String _title;
    private MailService _mailService;
    private String _mailTo;
    private String _mailFrom;
    private boolean _isSnapshot;
    private boolean _isSnapshotHeapDump = true;
    private long _profileTime;
    private long _profileTick;
    private boolean _isWatchdog;
    private boolean _isReturnPdf;
    private QuercusContext _quercus;
    private Path _phpPath;
    private Path _logPath;
    private String _fileName;
    private Session _session;
    private boolean _isSnapshotJmx;

    public String getPath() {
        return this._path;
    }

    public void setPath(String path) {
        this._path = path;
    }

    public String getReport() {
        return this._report;
    }

    public void setReport(String report) {
        this._report = report;
    }

    public void setServerId(String serverId) {
        this._serverId = serverId;
    }

    public String getTitle() {
        return this._title;
    }

    public void setTitle(String title) {
        this._title = title;
    }

    public long getPeriod() {
        return this._period;
    }

    public void setPeriod(long period) {
        this._period = period;
    }

    public boolean isSnapshot() {
        return this._isSnapshot;
    }

    public void setSnapshot(boolean isSnapshot) {
        this._isSnapshot = isSnapshot;
    }

    public void setSnapshotHeapDump(boolean isHeapDump) {
        this._isSnapshotHeapDump = isHeapDump;
    }

    public boolean isSnapshotHeapDump() {
        return this._isSnapshotHeapDump;
    }

    public void setSnapshotJmx(boolean isJmx) {
        this._isSnapshotJmx = isJmx;
    }

    public boolean isSnapshotJmx() {
        return this._isSnapshotJmx;
    }

    public void setWatchdog(boolean isWatchdog) {
        this._isWatchdog = isWatchdog;
    }

    public boolean isWatchdog() {
        return this._isWatchdog;
    }

    public long getProfileTime() {
        return this._profileTime;
    }

    public void setProfileTime(long profileTime) {
        this._profileTime = profileTime;
    }

    public long getProfileTick() {
        return this._profileTick;
    }

    public void setProfileTick(long profileTick) {
        this._profileTick = profileTick;
    }

    public String getLogDirectory() {
        return this._logDirectory;
    }

    public Path getLogPath() {
        return this._logPath;
    }

    public void setLogDirectory(String logDirectory) {
        this._logDirectory = logDirectory;
    }

    public String getMailTo() {
        return this._mailTo;
    }

    public void setMailTo(String mailTo) {
        if (!"".equals(mailTo)) {
            this._mailTo = mailTo;
        }
    }

    public String getMailFrom() {
        return this._mailFrom;
    }

    public void setMailFrom(String mailFrom) {
        if (!"".equals(mailFrom)) {
            this._mailFrom = mailFrom;
        }
    }

    public void setMailSession(Session session) {
        this._session = session;
    }

    public boolean isReturnPdf() {
        return this._isReturnPdf;
    }

    public void setReturnPdf(boolean returnPdf) {
        this._isReturnPdf = returnPdf;
    }

    private String calculateReport() {
        if (this._report != null) {
            return this._report;
        }
        if (this.isWatchdog()) {
            return "Watchdog";
        }
        return "Snapshot";
    }

    private String calculateTitle() {
        if (this._title != null) {
            return this._title;
        }
        return this.calculateReport();
    }

    private long calculatePeriod() {
        if (this._period != 0L) {
            return this._period;
        }
        if (this.isWatchdog()) {
            return 0x6DDD00L;
        }
        return 86400000L;
    }

    public void init() {
        Resin resin = Resin.getCurrent();
        if (resin != null) {
            if (this._serverId == null) {
                this._serverId = resin.getServerId();
            }
            if (this._logDirectory == null) {
                this._logPath = resin.getLogDirectory();
            }
        } else {
            if (this._serverId == null) {
                this._serverId = "unknown";
            }
            if (this._logDirectory == null) {
                this._logPath = Vfs.getPwd();
            }
        }
        if (this._path != null) {
            this._phpPath = Vfs.lookup((String)this._path);
        } else if (resin != null) {
            Path path;
            if (this._path == null && (path = resin.getRootDirectory().lookup("doc/admin/pdf-gen.php")).canRead()) {
                this._path = path.getNativePath();
            }
            if (this._path == null && (path = resin.getResinHome().lookup("doc/admin/pdf-gen.php")).canRead()) {
                this._path = path.getNativePath();
            }
            if (this._path == null && (path = resin.getResinHome().lookup("php/admin/pdf-gen.php")).canRead()) {
                this._path = path.getNativePath();
            }
            if (this._path != null) {
                this._phpPath = Vfs.lookup((String)this._path);
            }
        }
        if (this._phpPath == null) {
            log.warning(L.l("{0} requires a 'path' attribute to a PDF generating .php file or '{1}'", (Object)this.getClass().getSimpleName(), (Object)resin.getResinHome().lookup("php/admin/pdf-gen.php").getNativePath()));
        }
        if (this._logPath == null) {
            this._logPath = Vfs.lookup((String)this._logDirectory);
        }
        if (this._mailService == null) {
            this._mailService = new MailService();
        }
        if (this._mailTo != null) {
            try {
                this._mailService.addTo((Address)new InternetAddress(this._mailTo));
            }
            catch (Exception e) {
                log.log(Level.WARNING, e.toString(), e);
            }
        }
        if (this._mailFrom != null) {
            try {
                this._mailService.addFrom((Address)new InternetAddress(this._mailFrom));
            }
            catch (Exception e) {
                log.log(Level.WARNING, e.toString(), e);
            }
        }
        if (this._session != null) {
            this._mailService.setSession(this._session);
        }
        if (this._mailTo != null || this._mailFrom != null) {
            try {
                this._mailService.init();
            }
            catch (Exception e) {
                log.log(Level.WARNING, e.toString(), e);
            }
        }
    }

    public String getReportFileName() {
        if (this._fileName == null) {
            String date = QDate.formatLocal((long)CurrentTime.getCurrentTime(), (String)"%Y%m%dT%H%M");
            String serverId = "default";
            Resin resin = Resin.getCurrent();
            if (resin != null) {
                serverId = resin.getServerIdFilePart();
            }
            this._fileName = String.format("%s-%s-%s.pdf", serverId, this.calculateTitle(), date);
        }
        return this._fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PdfReportActionResult execute() throws IOException {
        PdfReportActionResult actionResult;
        TempStream ts;
        TempOutputStream pdfOut;
        WriteStream ws;
        Env env;
        block12: {
            PdfReportActionResult pdfReportActionResult;
            env = null;
            ws = null;
            pdfOut = null;
            if (this._phpPath == null) {
                Resin resin = Resin.getCurrent();
                Path path = resin.getRootDirectory().lookup("doc/admin/pdf-gen.php");
                throw new ConfigException(L.l("{0} report generation failed because the PHP file cannot be found.\n  Expected {1}", (Object)this.calculateReport(), (Object)path.getNativePath()));
            }
            try {
                PdfReportActionResult actionResult2;
                QuercusPage page = this.getQuercusContext().parse(this._phpPath);
                ts = new TempStream();
                ts.openWrite();
                ws = new WriteStream((StreamImpl)ts);
                StubServletRequest request = new StubServletRequest();
                StubServletResponse response = new StubServletResponse();
                QuercusHttpServletRequestImpl qRequest = new QuercusHttpServletRequestImpl((HttpServletRequest)request);
                QuercusHttpServletResponseImpl qResponse = new QuercusHttpServletResponseImpl((HttpServletResponse)response);
                env = this._quercus.createEnv(page, ws, (QuercusHttpServletRequest)qRequest, (QuercusHttpServletResponse)qResponse);
                if (this._serverId != null && !this._serverId.equals("unknown")) {
                    env.setGlobalValue("g_server_id", env.wrapJava((Object)this._serverId));
                }
                env.setGlobalValue("g_report", env.wrapJava((Object)this.calculateReport()));
                env.setGlobalValue("g_title", env.wrapJava((Object)this.calculateTitle()));
                env.setGlobalValue("period", env.wrapJava((Object)(this.calculatePeriod() / 1000L)));
                env.setGlobalValue("g_is_snapshot", env.wrapJava((Object)this.isSnapshot()));
                env.setGlobalValue("g_is_snapshot_heapdump", env.wrapJava((Object)this.isSnapshotHeapDump()));
                env.setGlobalValue("g_is_snapshot_jmx", env.wrapJava((Object)this.isSnapshotJmx()));
                env.setGlobalValue("g_is_watchdog", env.wrapJava((Object)this.isWatchdog()));
                if (this.getProfileTime() > 0L) {
                    env.setGlobalValue("profile_time", env.wrapJava((Object)(this.getProfileTime() / 1000L)));
                }
                if (this.getProfileTick() > 0L) {
                    env.setGlobalValue("profile_tick", env.wrapJava((Object)this.getProfileTick()));
                }
                env.start();
                Value result = env.executeTop();
                if (!result.toString().equals("ok")) {
                    throw new RuntimeException(L.l("{0} report generation failed: {1}", (Object)this.calculateReport(), (Object)result.toString()));
                }
                ws.flush();
                if (this._mailTo == null || "".equals(this._mailTo)) break block12;
                this.mailPdf(ts);
                String message = L.l("{0} report mailed to {1}", (Object)this.calculateReport(), (Object)this._mailTo);
                pdfReportActionResult = actionResult2 = new PdfReportActionResult(message, null, null);
            }
            catch (Throwable throwable) {
                IoUtil.close(ws);
                IoUtil.close(pdfOut);
                if (env != null) {
                    env.close();
                }
                throw throwable;
            }
            IoUtil.close((OutputStream)ws);
            IoUtil.close((OutputStream)pdfOut);
            if (env != null) {
                env.close();
            }
            return pdfReportActionResult;
        }
        Path path = this.writePdfToFile(ts);
        if (this._isReturnPdf) {
            pdfOut = new TempOutputStream();
            ts.writeToStream((OutputStream)pdfOut);
        }
        String message = L.l("{0} report generated at {1}", (Object)this.calculateReport(), (Object)path);
        PdfReportActionResult pdfReportActionResult = actionResult = new PdfReportActionResult(message, path.getPath(), pdfOut);
        IoUtil.close((OutputStream)ws);
        IoUtil.close((OutputStream)pdfOut);
        if (env != null) {
            env.close();
        }
        return pdfReportActionResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QuercusContext getQuercusContext() {
        PdfReportAction pdfReportAction = this;
        synchronized (pdfReportAction) {
            if (this._quercus == null) {
                this._quercus = new QuercusContext();
                this._quercus.setPwd(this._phpPath.getParent());
                this._quercus.init();
                this._quercus.start();
            }
        }
        return this._quercus;
    }

    private void mailPdf(TempStream ts) throws IOException {
        String fileName = this.getReportFileName();
        String userDate = QDate.formatLocal((long)CurrentTime.getCurrentTime(), (String)"%Y-%m-%d %H:%M");
        String subject = "[Resin] PDF Report: " + this.calculateTitle() + "@" + this._serverId + " " + userDate;
        StringBuilder text = new StringBuilder();
        text.append("Resin generated PDF Report");
        text.append("\n");
        text.append("\nReport: ").append(this.calculateReport());
        text.append("\nGenerated: ").append(userDate);
        text.append("\nServer: ").append(this._serverId);
        this._mailService.sendWithAttachment(subject, text.toString(), "application/pdf", fileName, ts.openInputStream());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Path writePdfToFile(TempStream ts) throws IOException {
        String fileName = this.getReportFileName();
        Path path = this._logPath.lookup(fileName);
        path.getParent().mkdirs();
        WriteStream os = path.openWrite();
        try {
            ts.writeToStream((OutputStream)os);
        }
        finally {
            IoUtil.close((OutputStream)os);
        }
        return path;
    }

    public static class PdfReportActionResult {
        private String _message;
        private String _fileName;
        private TempOutputStream _pdfOutputStream;

        public PdfReportActionResult(String message, String fileName, TempOutputStream out) {
            this._message = message;
            this._fileName = fileName;
            this._pdfOutputStream = out;
        }

        public String getMessage() {
            return this._message;
        }

        public TempOutputStream getPdfOutputStream() {
            return this._pdfOutputStream;
        }

        public String getFileName() {
            return this._fileName;
        }
    }
}

