/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.admin.action;

import com.caucho.admin.action.AbstractJmxAction;
import com.caucho.admin.action.AdminAction;
import com.caucho.config.ConfigException;
import com.caucho.jmx.Jmx;
import com.caucho.util.CurrentTime;
import com.caucho.util.QDate;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;

public class JmxDumpAction
extends AbstractJmxAction
implements AdminAction {
    public static void main(String[] args) throws Exception {
        System.out.println(new JmxDumpAction().execute());
    }

    public String execute() throws ConfigException, JMException, ClassNotFoundException {
        Object server = Jmx.getMBeanServer();
        if (server == null) {
            server = ManagementFactory.getPlatformMBeanServer();
        }
        if (server == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        long timestamp = CurrentTime.getCurrentTime();
        sb.append("{\n");
        sb.append("  \"create_time\": \"" + new Date(timestamp) + "\",\n");
        sb.append("  \"timestamp\": " + timestamp + ",\n");
        sb.append("  \"jmx\" : {\n");
        this.fillServer(sb, (MBeanServer)server);
        sb.append("\n  }");
        sb.append("\n}");
        return sb.toString();
    }

    private void fillServer(StringBuilder sb, MBeanServer server) {
        HashSet<ObjectName> beans = new HashSet<ObjectName>();
        ArrayList<ObjectName> objectNames = new ArrayList<ObjectName>();
        objectNames.addAll(server.queryNames(ObjectName.WILDCARD, null));
        Collections.sort(objectNames);
        boolean isFirst = true;
        for (ObjectName objectName : objectNames) {
            if (beans.contains(objectName)) continue;
            beans.add(objectName);
            if (!isFirst) {
                sb.append(",\n");
            }
            isFirst = false;
            sb.append("\"");
            this.escapeString(sb, String.valueOf(objectName));
            sb.append("\" : {\n");
            this.dumpMBean(sb, server, objectName);
            sb.append("\n}");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpMBean(StringBuilder sb, MBeanServer server, ObjectName objectName) {
        MBeanAttributeInfo[] attributes = null;
        try {
            MBeanServer mBeanServer = server;
            synchronized (mBeanServer) {
                attributes = server.getMBeanInfo(objectName).getAttributes();
            }
        }
        catch (Exception e) {
            sb.append("\"mbean_exception\": \"" + e + "\"\n");
            return;
        }
        boolean isFirst = true;
        for (MBeanAttributeInfo attribute : attributes) {
            if (!isFirst) {
                sb.append(",\n");
            }
            isFirst = false;
            Object value = null;
            try {
                value = server.getAttribute(objectName, attribute.getName());
            }
            catch (Throwable e) {
                value = e;
            }
            this.dumpNameValue(sb, attribute.getName(), value, "  ");
        }
    }

    private void dumpNameValue(StringBuilder sb, String name, Object value, String padding) {
        sb.append(padding);
        sb.append("\"");
        this.escapeString(sb, name);
        sb.append("\"");
        sb.append(": ");
        this.dumpValue(sb, value, padding);
    }

    private void dumpValue(StringBuilder sb, Object value, String padding) {
        if (value == null) {
            sb.append("null");
        } else if (value instanceof Object[]) {
            Object[] values = (Object[])value;
            sb.append("[");
            boolean isFirst = true;
            for (Object v : values) {
                if (!isFirst) {
                    sb.append(",");
                }
                isFirst = false;
                sb.append("\n" + padding + "  ");
                this.dumpValue(sb, v, padding + "  ");
            }
            sb.append("\n" + padding + "]");
        } else if (value instanceof CompositeData) {
            CompositeData data = (CompositeData)value;
            CompositeType type = data.getCompositeType();
            sb.append(" {\n");
            sb.append(padding);
            sb.append("  \"java_class\": \"" + type.getTypeName() + "\"");
            for (String key : type.keySet()) {
                sb.append(",\n");
                this.dumpNameValue(sb, key, data.get(key), padding + "  ");
            }
            sb.append("\n" + padding + "}");
        } else if (value instanceof Map) {
            Map data = (Map)value;
            sb.append("{\n");
            sb.append(padding);
            sb.append("  \"java_class\":\"" + value.getClass().getName() + "\"");
            for (Map.Entry entry : data.entrySet()) {
                sb.append(",\n");
                this.dumpNameValue(sb, entry.getKey().toString(), entry.getValue(), padding + "  ");
            }
            sb.append("\n" + padding);
            sb.append("}");
        } else if (value instanceof List) {
            List values = (List)value;
            sb.append("[\n");
            boolean isFirst = true;
            for (Object v : values) {
                if (!isFirst) {
                    sb.append(",\n");
                }
                isFirst = false;
                sb.append(padding + "  ");
                this.dumpValue(sb, v, padding + "  ");
            }
            sb.append(padding);
            sb.append("]");
        } else if (value instanceof Throwable) {
            Throwable e = (Throwable)value;
            if (e instanceof UnsupportedOperationException) {
                sb.append("\"Not supported\"");
            } else {
                Throwable cause = e.getCause();
                if (cause != null) {
                    this.dumpValue(sb, cause, padding);
                } else {
                    sb.append("\"" + e + "\"");
                }
            }
        } else if (value instanceof Number) {
            sb.append(value);
        } else if (value instanceof Boolean) {
            sb.append(value);
        } else if (value instanceof Date) {
            sb.append("\"" + QDate.formatISO8601((long)((Date)value).getTime()) + "\"");
        } else {
            sb.append("\"");
            this.escapeString(sb, String.valueOf(value));
            sb.append("\"");
        }
    }

    private void escapeString(StringBuilder sb, String value) {
        int len = value.length();
        block4: for (int i = 0; i < len; ++i) {
            char ch = value.charAt(i);
            switch (ch) {
                case '\"': {
                    sb.append("\\\"");
                    continue block4;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block4;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
    }
}

