/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.admin.action;

import com.caucho.admin.action.AdminAction;
import com.caucho.config.ConfigException;
import com.caucho.jmx.Jmx;
import com.caucho.profile.HeapDump;
import com.caucho.server.resin.Resin;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class HeapDumpAction
implements AdminAction {
    private static final L10N L = new L10N(HeapDumpAction.class);

    public String execute(boolean isJvmHprof, String serverId, Path hprofPath) throws ConfigException, JMException, IOException {
        if (isJvmHprof) {
            return this.doJvmHprofHeapDump(serverId, hprofPath);
        }
        return this.doProHeapDump();
    }

    private String doJvmHprofHeapDump(String serverId, Path hprofPath) throws ConfigException, JMException, IOException {
        ObjectName name = new ObjectName("com.sun.management:type=HotSpotDiagnostic");
        if (hprofPath == null) {
            Resin resin = Resin.getCurrent();
            hprofPath = resin == null ? Vfs.lookup((String)System.getProperty("java.io.tmpdir")) : resin.getLogDirectory();
            hprofPath = hprofPath.lookup("heap.hprof");
        } else if (hprofPath.isDirectory()) {
            hprofPath = hprofPath.lookup("heap.hprof");
        }
        hprofPath.getParent().mkdirs();
        if (hprofPath.exists() && hprofPath.isFile()) {
            hprofPath.remove();
        }
        MBeanServer mBeanServer = Jmx.getGlobalMBeanServer();
        mBeanServer.invoke(name, "dumpHeap", new Object[]{hprofPath.getPath(), Boolean.TRUE}, new String[]{String.class.getName(), Boolean.TYPE.getName()});
        String result = L.l("Heap dump is written to `{0}'.\nTo view the file on the target machine use\njvisualvm --openfile {0}", (Object)hprofPath.getPath());
        return result;
    }

    private String doProHeapDump() throws IOException {
        HeapDump dump = HeapDump.create();
        StringWriter buffer = new StringWriter();
        PrintWriter writer = new PrintWriter(buffer);
        dump.writeExtendedHeapDump(writer);
        writer.flush();
        return buffer.toString();
    }

    public String executeJson() throws IOException {
        HeapDump dump = HeapDump.create();
        return dump.jsonHeapDump();
    }
}

