/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.admin.action;

import com.caucho.admin.action.AdminAction;
import com.caucho.config.ConfigException;
import com.caucho.env.shutdown.ExitCode;
import com.caucho.env.shutdown.ShutdownSystem;
import com.caucho.server.resin.Resin;
import com.caucho.util.Alarm;
import com.caucho.util.AlarmListener;
import com.caucho.util.IoUtil;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AddLicenseAction
implements AdminAction {
    private static final Logger log = Logger.getLogger(AddLicenseAction.class.getName());
    private static final L10N L = new L10N(AddLicenseAction.class);

    public String execute(String licenseContent, String fileName, boolean overwrite, boolean restart) {
        try {
            Class<?> cl = null;
            cl = Class.forName("com.caucho.license.LicenseCheckImpl");
        }
        catch (ClassNotFoundException e) {
            throw new ConfigException(L.l("add-license requires the Resin Professional download"), (Throwable)e);
        }
        WriteStream out = null;
        try {
            Path licenseFile;
            Resin resin = Resin.getCurrent();
            Path resinRoot = resin.getRootDirectory();
            Path licensePath = resin.getLicenseDirectory();
            if (licensePath == null || !licensePath.isDirectory() || !licensePath.canWrite()) {
                licensePath = resinRoot.lookup("licenses");
            }
            if ((licenseFile = licensePath.lookup(fileName)).exists() && !overwrite) {
                log.log(Level.FINE, L.l("add-license will not overwrite {0} (use -overwrite)", (Object)licenseFile));
                String string = L.l("add-license will not overwrite {0} (use -overwrite)", (Object)licenseFile);
                return string;
            }
            licensePath.mkdirs();
            log.info(this + " adding license " + licenseFile.getNativePath());
            out = licenseFile.openWrite();
            out.print(licenseContent);
            IoUtil.close((OutputStream)out);
        }
        catch (IOException e) {
            throw new ConfigException(L.l("add-license failed to write {0}: {1}", (Object)fileName, (Object)e.toString()), (Throwable)e);
        }
        finally {
            IoUtil.close(out);
        }
        if (restart) {
            new Alarm(new AlarmListener(){

                public void handleAlarm(Alarm alarm) {
                    ShutdownSystem.shutdownActive((ExitCode)ExitCode.OK, (String)L.l("Resin restarting for add-license"));
                }
            }, 500L);
            log.log(Level.FINE, L.l("add-license wrote {0} successfully and restarting Resin", (Object)fileName));
            return L.l("add-license wrote {0} successfully and restarting Resin", (Object)fileName);
        }
        log.log(Level.FINE, L.l("add-license wrote {0} successfully", (Object)fileName));
        return L.l("add-license wrote {0} successfully", (Object)fileName);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[]";
    }
}

