/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.admin.action;

import com.caucho.admin.action.AdminAction;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;

public class AbstractJmxAction
implements AdminAction {
    private static Map<String, Class<?>> classMap = new HashMap();

    protected static void sort(List<MBeanOperationInfo> operations) {
        Collections.sort(operations, new Comparator<MBeanOperationInfo>(){

            @Override
            public int compare(MBeanOperationInfo o1, MBeanOperationInfo o2) {
                String signature1 = AbstractJmxAction.getSignature(o1);
                String signature2 = AbstractJmxAction.getSignature(o2);
                return signature1.compareTo(signature2);
            }
        });
    }

    protected static String getSignature(MBeanOperationInfo operation) {
        StringBuilder builder = new StringBuilder();
        builder.append(operation.getName()).append('(');
        MBeanParameterInfo[] params = operation.getSignature();
        for (int i = 0; i < params.length; ++i) {
            MBeanParameterInfo param = params[i];
            builder.append(param.getType());
            if (i + 1 >= params.length) continue;
            builder.append(", ");
        }
        builder.append(')');
        return builder.toString();
    }

    protected static Object toValue(String typeName, String value) throws ClassNotFoundException {
        Class<?> type = classMap.get(typeName);
        if (type == null) {
            type = Class.forName(typeName);
        }
        if (Boolean.TYPE.equals(type) || Boolean.class.equals(type)) {
            return Boolean.parseBoolean(value);
        }
        if (Byte.TYPE.equals(type) || Byte.class.equals(type)) {
            return Byte.parseByte(value);
        }
        if (Short.TYPE.equals(type) || Short.class.equals(type)) {
            return Short.parseShort(value);
        }
        if (Character.TYPE.equals(type) || Character.class.equals(type)) {
            return new Character((char)Integer.parseInt(value));
        }
        if (Integer.TYPE.equals(type) || Integer.class.equals(type)) {
            return Integer.parseInt(value);
        }
        if (Long.TYPE.equals(type) || Long.class.equals(type)) {
            return Long.parseLong(value);
        }
        if (Float.TYPE.equals(type) || Float.class.equals(type)) {
            return Float.valueOf(Float.parseFloat(value));
        }
        if (Double.TYPE.equals(type) || Double.class.equals(type)) {
            return Double.parseDouble(value);
        }
        if (type.isEnum()) {
            return Enum.valueOf(type, value);
        }
        return value;
    }

    static {
        classMap.put("boolean", Boolean.TYPE);
        classMap.put(Boolean.class.getName(), Boolean.class);
        classMap.put("byte", Byte.TYPE);
        classMap.put(Byte.class.getName(), Byte.class);
        classMap.put("short", Short.class);
        classMap.put(Short.class.getName(), Short.class);
        classMap.put("int", Integer.TYPE);
        classMap.put(Integer.class.getName(), Integer.class);
        classMap.put("long", Long.TYPE);
        classMap.put(Long.class.getName(), Long.class);
        classMap.put("float", Long.TYPE);
        classMap.put(Float.class.getName(), Float.class);
        classMap.put("double", Long.TYPE);
        classMap.put(Double.class.getName(), Double.class);
        classMap.put(String.class.getName(), String.class);
    }
}

