/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.burlap.io;

import com.caucho.burlap.io.AbstractBurlapOutput;
import com.caucho.burlap.io.Serializer;
import java.io.IOException;

public class ArraySerializer
extends Serializer {
    public void writeObject(Object obj, AbstractBurlapOutput out) throws IOException {
        if (out.addRef(obj)) {
            return;
        }
        Object[] array = (Object[])obj;
        out.writeListBegin(array.length, this.getArrayType(obj.getClass()));
        for (int i = 0; i < array.length; ++i) {
            out.writeObject(array[i]);
        }
        out.writeListEnd();
    }

    private String getArrayType(Class cl) {
        if (cl.isArray()) {
            return '[' + this.getArrayType(cl.getComponentType());
        }
        String name = cl.getName();
        if (name.equals("java.lang.String")) {
            return "string";
        }
        if (name.equals("java.lang.Object")) {
            return "object";
        }
        if (name.equals("java.util.Date")) {
            return "date";
        }
        return name;
    }
}

