/*
 * Decompiled with CFR 0.152.
 */
package com.catalogic.ecxjenkins.ecxjenkins;

import com.catalogic.ecx.sdk.ECXSdk;
import hudson.AbortException;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletException;
import jenkins.tasks.SimpleBuildStep;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class ECXCDMBuilder
extends Builder
implements SimpleBuildStep {
    private final String name;
    private final String password;
    private final String url;
    private final String job;
    private boolean production;
    private final int maxWaitTime;
    private static final int minWaitTime = 10;
    private static final int second = 1000;
    private static final int resolution = 2;

    @DataBoundConstructor
    public ECXCDMBuilder(String name, String password, String url, String job, boolean production, int maxWaitTime) {
        this.name = name;
        this.password = password;
        this.url = url;
        this.production = production;
        this.maxWaitTime = maxWaitTime;
        this.job = job;
    }

    public String getName() {
        return this.name;
    }

    public String getPassword() {
        return this.password;
    }

    public String getUrl() {
        return this.url;
    }

    public String getJob() {
        return this.job;
    }

    public int getMaxWaitTime() {
        return this.maxWaitTime;
    }

    public boolean getProduction() {
        return this.production;
    }

    public void perform(Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener) throws AbortException {
        if (this.getDescriptor().getProduction()) {
            listener.getLogger().println("Bonjour, " + this.name + "!");
        } else {
            listener.getLogger().println("Executing an ECX CDM Job using the following information, " + this.name + " " + this.url);
        }
        ECXSdk ecx = new ECXSdk(this.name, this.password, this.url, this.production);
        ecx.connect();
        ecx.runJob(this.job);
        String msg = "";
        String lastMessage = "";
        int wait = 0;
        while (msg.compareTo("PARTIAL") != 0 && msg.compareTo("FAILED") != 0 && msg.compareTo("COMPLETED") != 0 && msg.compareTo("IDLE") != 0 && wait < this.maxWaitTime * 2) {
            ++wait;
            msg = this.getECXJobInfo(ecx, true);
            if (!StringUtils.isEmpty((String)msg) && msg.compareTo(lastMessage) != 0) {
                listener.getLogger().println(msg);
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            lastMessage = msg;
        }
        if (!StringUtils.isEmpty((String)msg) && msg.compareTo("ACTIVE") == 0) {
            throw new AbortException("ECX CDM Build step for job " + this.job + " timed out waiting for the ECX job to complete! You may want to check ECX to see how long the job ran and potentially increase the configuration timeout.");
        }
        msg = this.getECXJobInfo(ecx, false);
        listener.getLogger().println(msg);
        if (!StringUtils.isEmpty((String)msg) && msg.compareTo("FAILED") == 0) {
            throw new AbortException("ECX " + this.job + " Failed!");
        }
    }

    private String getECXJobInfo(ECXSdk ecx, boolean monitor) {
        if (monitor) {
            ecx.monitorJob(this.job);
        } else {
            ecx.getJobResult(this.job);
        }
        Iterator<String> _i = ecx.getStatus();
        String msg = _i.next();
        _i.remove();
        return msg;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        private boolean production;

        public DescriptorImpl() {
            this.load();
        }

        public FormValidation doCheckName(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)"Please enter a valid ECX user name!");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckPassword(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)"Please enter a valid ECX password!");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckMaxWaitTime(@QueryParameter String value) {
            try {
                Integer time = Integer.parseInt(value);
                if (time < 10) {
                    return FormValidation.error((String)"The max wait time in seconds should be a number greater than 10.");
                }
                return FormValidation.ok();
            }
            catch (NumberFormatException e) {
                return FormValidation.error((String)"The max wait time needs to be a number.");
            }
        }

        public FormValidation doCheckJob(@QueryParameter String value) {
            try {
                Integer.parseInt(value);
                return FormValidation.ok();
            }
            catch (NumberFormatException e) {
                return FormValidation.error((String)"Please check to ensure you are using a valid job id.");
            }
        }

        public FormValidation doTestConnection(@QueryParameter(value="name") String name, @QueryParameter(value="password") String password, @QueryParameter(value="url") String url, @QueryParameter(value="production") boolean production) throws IOException, ServletException {
            try {
                ECXSdk ecx = new ECXSdk(name, password, url, production);
                ecx.connect();
                return FormValidation.ok((String)"Success");
            }
            catch (Exception e) {
                return FormValidation.error((String)("Client error : " + e.getMessage()));
            }
        }

        public ListBoxModel doFillJobListItems(@QueryParameter(value="name") String name, @QueryParameter(value="password") String password, @QueryParameter(value="url") String url, @QueryParameter(value="production") boolean production) {
            ListBoxModel _items = new ListBoxModel();
            ECXSdk ecx = new ECXSdk(name, password, url, production);
            ecx.connect();
            ecx.setJobList();
            Iterator<Map.Entry<String, String>> it = ecx.getJobList().entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, String> pair = it.next();
                _items.add(pair.getValue(), pair.getKey());
                it.remove();
            }
            return _items;
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return "Catalogic ECX CDM Integration";
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.production = formData.getBoolean("production");
            this.save();
            return super.configure(req, formData);
        }

        public boolean getProduction() {
            return this.production;
        }
    }
}

