/*
 * Decompiled with CFR 0.152.
 */
package com.catalogic.ecx.sdk;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContextBuilder;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ECXSdk {
    private static final Logger logger = LoggerFactory.getLogger(ECXSdk.class);
    private String user;
    private String pwd;
    private String url;
    private boolean production;
    private String sessionid;
    private LinkedHashMap<String, String> jobList;
    private LinkedHashSet<String> jobMessages = new LinkedHashSet();
    private static final String ACCEPTHEADER = "application/json";
    private static final String CONTENTTYPE = "application/json";
    private static final String ECXAUTHORIZATION_HEADER = "x-endeavour-sessionid";

    public ECXSdk(String user, String password, String url, boolean production) {
        this.user = user;
        this.pwd = password;
        this.url = url + "/api";
        this.production = production;
    }

    public void connect() {
        this.setSessionId();
    }

    private void setSessionId() {
        this.doPostForSessionId("/endeavour/session", "SESSIONID");
    }

    public void setJobList() {
        String q = "[{\"property\":\"name\",\"direction\":\"ASC\"}]";
        try {
            this.doGet("/endeavour/job?sort=" + URLEncoder.encode(q, "UTF-8"), "JOBS");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void runJob(String jobId) {
        this.jobMessages.clear();
        this.setStatus("Launching job with jobid " + jobId);
        this.doPost("/endeavour/job/" + jobId + "?action=start", "JOB");
    }

    public void monitorJob(String jobId) {
        this.doGet("/endeavour/job/" + jobId, "JOBMONITOR");
    }

    public void getJobResult(String jobId) {
        this.doGet("/endeavour/job/" + jobId, "JOBRESULT");
    }

    private void doPost(String endpoint, String jsonPropertyOfInterest) {
        HttpPost httpPost = new HttpPost(this.url + endpoint);
        httpPost.addHeader("Accept", "application/json");
        httpPost.addHeader("Content-Type", "application/json");
        httpPost.addHeader(ECXAUTHORIZATION_HEADER, this.getSessionId());
        this.processRESTRequest((HttpUriRequest)httpPost, jsonPropertyOfInterest);
    }

    private void doPostForSessionId(String endpoint, String jsonPropertyOfInterest) {
        HttpPost httpPost = new HttpPost(this.url + endpoint);
        httpPost.addHeader("Accept", "application/json");
        httpPost.addHeader("Content-Type", "application/json");
        String auth = this.user + ":" + this.pwd;
        byte[] encodedAuth = Base64.encodeBase64((byte[])auth.getBytes(Charset.forName("ISO-8859-1")));
        String authHeader = "Basic " + new String(encodedAuth, Charset.forName("UTF-8"));
        httpPost.addHeader("Authorization", authHeader);
        this.processRESTRequest((HttpUriRequest)httpPost, jsonPropertyOfInterest);
    }

    private void doGet(String endpoint, String property) {
        HttpGet httpGet = new HttpGet(this.url + endpoint);
        httpGet.addHeader("Accept", "application/json");
        httpGet.addHeader("Content-Type", "application/json");
        httpGet.addHeader(ECXAUTHORIZATION_HEADER, this.getSessionId());
        this.processRESTRequest((HttpUriRequest)httpGet, property);
    }

    private void processRESTRequest(HttpUriRequest request, String jsonPropertyOfInterest) {
        try {
            this._processRESTRequest(request, jsonPropertyOfInterest);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _processRESTRequest(HttpUriRequest request, String jsonPropertyOfInterest) throws Exception {
        CloseableHttpClient client;
        if (this.production) {
            client = HttpClients.createDefault();
        } else {
            SSLContextBuilder builder = new SSLContextBuilder();
            builder.loadTrustMaterial(null, (TrustStrategy)new TrustSelfSignedStrategy());
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(builder.build(), SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
            client = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).build();
        }
        try (CloseableHttpResponse response = client.execute(request);){
            this.validateStatusLine(response, jsonPropertyOfInterest);
            this.processRESTResponse(response, jsonPropertyOfInterest);
        }
        finally {
            client.close();
        }
    }

    private void processRESTResponse(CloseableHttpResponse httpResponse, String jsonPropertyOfInterest) {
        HttpEntity entity = httpResponse.getEntity();
        if (entity != null) {
            try (InputStream inputStream = entity.getContent();){
                String result = this.convertStreamToString(inputStream);
                this.parseJSONStreamForPropertyOfInterest(jsonPropertyOfInterest, result);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void validateStatusLine(CloseableHttpResponse response, String jsonPropertyOfInterest) {
        int expectedResponse = -1;
        switch (jsonPropertyOfInterest) {
            case "JOBRESULT": 
            case "SESSIONID": 
            case "JOBS": 
            case "JOB": 
            case "JOBMONITOR": {
                expectedResponse = 200;
                break;
            }
        }
        if (response.getStatusLine().getStatusCode() != expectedResponse) {
            throw new RuntimeException("Failed : HTTP error code : " + response.getStatusLine().getStatusCode());
        }
    }

    private String convertStreamToString(InputStream is) {
        StringBuilder sb = new StringBuilder();
        String line = null;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(is, Charset.forName("UTF-8")));){
            while ((line = reader.readLine()) != null) {
                sb.append(line + "\n");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return sb.toString();
    }

    private void parseJSONStreamForPropertyOfInterest(String jsonPropertyOfInterest, String jsonRestResponse) {
        JSONParser parser = new JSONParser();
        try {
            JSONObject data = (JSONObject)parser.parse(jsonRestResponse);
            switch (jsonPropertyOfInterest) {
                case "SESSIONID": {
                    this.sessionid = (String)data.get((Object)"sessionid");
                    break;
                }
                case "JOBS": {
                    this.jobList = new LinkedHashMap();
                    JSONArray jobArray = (JSONArray)data.get((Object)"jobs");
                    for (Object object : jobArray) {
                        JSONObject aJson = (JSONObject)object;
                        String jobName = (String)aJson.get((Object)"name");
                        String jobId = (String)aJson.get((Object)"id");
                        this.jobList.put(jobId, jobName.toLowerCase() + " [" + jobId + "] ");
                    }
                    break;
                }
                case "JOB": {
                    this.setStatus((String)data.get((Object)"status"));
                    break;
                }
                case "JOBMONITOR": {
                    this.setStatus((String)data.get((Object)"status"));
                    break;
                }
                case "JOBRESULT": {
                    this.setStatus((String)data.get((Object)"lastSessionStatus"));
                    break;
                }
            }
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    private void setStatus(String status) {
        this.jobMessages.add(status);
    }

    public Iterator<String> getStatus() {
        return this.jobMessages.iterator();
    }

    private String getSessionId() {
        return this.sessionid;
    }

    public Map<String, String> getJobList() {
        return this.jobList;
    }
}

