/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.randomizedtesting;

import java.util.regex.Pattern;
import org.junit.runner.Description;
import org.junit.runner.manipulation.Filter;

public abstract class GlobFilter
extends Filter {
    protected final String globPattern;
    private final Pattern pattern;

    public GlobFilter(String glob) {
        this.globPattern = glob;
        this.pattern = this.globToPattern(glob);
    }

    protected final boolean globMatches(String string) {
        boolean result = this.pattern.matcher(string).matches();
        return result;
    }

    private Pattern globToPattern(String glob) {
        StringBuilder pattern = new StringBuilder("^");
        block6: for (char c : glob.toCharArray()) {
            switch (c) {
                case '*': {
                    pattern.append(".*");
                    continue block6;
                }
                case '?': {
                    pattern.append('.');
                    continue block6;
                }
                case '$': 
                case '-': 
                case '.': 
                case '[': 
                case ']': 
                case '{': 
                case '}': {
                    pattern.append("\\");
                    pattern.append(c);
                    continue block6;
                }
                case '\\': {
                    pattern.append("\\\\");
                    continue block6;
                }
                default: {
                    pattern.append(c);
                }
            }
        }
        pattern.append('$');
        return Pattern.compile(pattern.toString());
    }

    public abstract boolean shouldRun(Description var1);

    public abstract String describe();
}

