/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.org.objectweb.asm;

import com.carrotsearch.ant.tasks.junit4.dependencies.org.objectweb.asm.ByteVector;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.objectweb.asm.ClassReader;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.objectweb.asm.ClassWriter;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.objectweb.asm.Handle;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.objectweb.asm.Symbol;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.objectweb.asm.SymbolTable$Entry;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.objectweb.asm.Type;

final class SymbolTable {
    final ClassWriter classWriter;
    private final ClassReader sourceClassReader;
    private int majorVersion;
    private String className;
    private int entryCount;
    private SymbolTable$Entry[] entries;
    private int constantPoolCount;
    private ByteVector constantPool;
    private int bootstrapMethodCount;
    private ByteVector bootstrapMethods;
    private int typeCount;
    private SymbolTable$Entry[] typeTable;

    ClassReader getSource() {
        return this.sourceClassReader;
    }

    int getMajorVersion() {
        return this.majorVersion;
    }

    String getClassName() {
        return this.className;
    }

    int setMajorVersionAndClassName(int n, String string) {
        this.majorVersion = n;
        this.className = string;
        return this.addConstantClass((String)string).index;
    }

    private SymbolTable$Entry get(int n) {
        return this.entries[n % this.entries.length];
    }

    private SymbolTable$Entry put(SymbolTable$Entry symbolTable$Entry) {
        int n;
        if (this.entryCount > this.entries.length * 3 / 4) {
            n = this.entries.length;
            int n2 = n * 2 + 1;
            SymbolTable$Entry[] symbolTable$EntryArray = new SymbolTable$Entry[n2];
            for (int i = n - 1; i >= 0; --i) {
                SymbolTable$Entry symbolTable$Entry2 = this.entries[i];
                while (symbolTable$Entry2 != null) {
                    int n3 = symbolTable$Entry2.hashCode % n2;
                    SymbolTable$Entry symbolTable$Entry3 = symbolTable$Entry2.next;
                    symbolTable$Entry2.next = symbolTable$EntryArray[n3];
                    symbolTable$EntryArray[n3] = symbolTable$Entry2;
                    symbolTable$Entry2 = symbolTable$Entry3;
                }
            }
            this.entries = symbolTable$EntryArray;
        }
        ++this.entryCount;
        n = symbolTable$Entry.hashCode % this.entries.length;
        symbolTable$Entry.next = this.entries[n];
        this.entries[n] = symbolTable$Entry;
        return this.entries[n];
    }

    Symbol addConstant(Object object) {
        if (object instanceof Integer) {
            return this.addConstantInteger((Integer)object);
        }
        if (object instanceof Byte) {
            return this.addConstantInteger(((Byte)object).intValue());
        }
        if (object instanceof Character) {
            return this.addConstantInteger(((Character)object).charValue());
        }
        if (object instanceof Short) {
            return this.addConstantInteger(((Short)object).intValue());
        }
        if (object instanceof Boolean) {
            return this.addConstantInteger((Boolean)object != false ? 1 : 0);
        }
        if (object instanceof Float) {
            return this.addConstantFloat(((Float)object).floatValue());
        }
        if (object instanceof Long) {
            return this.addConstantLong((Long)object);
        }
        if (object instanceof Double) {
            return this.addConstantDouble((Double)object);
        }
        if (object instanceof String) {
            return this.addConstantString((String)object);
        }
        if (object instanceof Type) {
            Type type = (Type)object;
            int n = type.getSort();
            if (n == 10) {
                return this.addConstantClass(type.getInternalName());
            }
            if (n == 11) {
                return this.addConstantMethodType(type.getDescriptor());
            }
            return this.addConstantClass(type.getDescriptor());
        }
        if (object instanceof Handle) {
            Handle handle = (Handle)object;
            return this.addConstantMethodHandle(handle.tag, handle.owner, handle.name, handle.descriptor, handle.isInterface);
        }
        throw new IllegalArgumentException("value " + object);
    }

    Symbol addConstantClass(String string) {
        return this.addConstantUtf8Reference(7, string);
    }

    Symbol addConstantFieldref(String string, String string2, String string3) {
        return this.addConstantMemberReference(9, string, string2, string3);
    }

    Symbol addConstantMethodref(String string, String string2, String string3, boolean bl) {
        int n = bl ? 11 : 10;
        return this.addConstantMemberReference(n, string, string2, string3);
    }

    private SymbolTable$Entry addConstantMemberReference(int n, String string, String string2, String string3) {
        int n2 = SymbolTable.hash(n, string, string2, string3);
        SymbolTable$Entry symbolTable$Entry = this.get(n2);
        while (symbolTable$Entry != null) {
            if (symbolTable$Entry.tag == n && symbolTable$Entry.hashCode == n2 && symbolTable$Entry.owner.equals(string) && symbolTable$Entry.name.equals(string2) && symbolTable$Entry.value.equals(string3)) {
                return symbolTable$Entry;
            }
            symbolTable$Entry = symbolTable$Entry.next;
        }
        this.constantPool.put122(n, this.addConstantClass((String)string).index, this.addConstantNameAndType(string2, string3));
        return this.put(new SymbolTable$Entry(this.constantPoolCount++, n, string, string2, string3, 0L, n2));
    }

    Symbol addConstantString(String string) {
        return this.addConstantUtf8Reference(8, string);
    }

    Symbol addConstantInteger(int n) {
        return this.addConstantInteger(3, n);
    }

    Symbol addConstantFloat(float f) {
        return this.addConstantInteger(4, Float.floatToRawIntBits(f));
    }

    private Symbol addConstantInteger(int n, int n2) {
        int n3 = SymbolTable.hash(n, n2);
        SymbolTable$Entry symbolTable$Entry = this.get(n3);
        while (symbolTable$Entry != null) {
            if (symbolTable$Entry.tag == n && symbolTable$Entry.hashCode == n3 && symbolTable$Entry.data == (long)n2) {
                return symbolTable$Entry;
            }
            symbolTable$Entry = symbolTable$Entry.next;
        }
        this.constantPool.putByte(n).putInt(n2);
        return this.put(new SymbolTable$Entry(this.constantPoolCount++, n, n2, n3));
    }

    Symbol addConstantLong(long l) {
        return this.addConstantLong(5, l);
    }

    Symbol addConstantDouble(double d) {
        return this.addConstantLong(6, Double.doubleToRawLongBits(d));
    }

    private Symbol addConstantLong(int n, long l) {
        int n2 = SymbolTable.hash(n, l);
        SymbolTable$Entry symbolTable$Entry = this.get(n2);
        while (symbolTable$Entry != null) {
            if (symbolTable$Entry.tag == n && symbolTable$Entry.hashCode == n2 && symbolTable$Entry.data == l) {
                return symbolTable$Entry;
            }
            symbolTable$Entry = symbolTable$Entry.next;
        }
        int n3 = this.constantPoolCount;
        this.constantPool.putByte(n).putLong(l);
        this.constantPoolCount += 2;
        return this.put(new SymbolTable$Entry(n3, n, l, n2));
    }

    int addConstantNameAndType(String string, String string2) {
        int n = 12;
        int n2 = SymbolTable.hash(12, string, string2);
        SymbolTable$Entry symbolTable$Entry = this.get(n2);
        while (symbolTable$Entry != null) {
            if (symbolTable$Entry.tag == 12 && symbolTable$Entry.hashCode == n2 && symbolTable$Entry.name.equals(string) && symbolTable$Entry.value.equals(string2)) {
                return symbolTable$Entry.index;
            }
            symbolTable$Entry = symbolTable$Entry.next;
        }
        this.constantPool.put122(12, this.addConstantUtf8(string), this.addConstantUtf8(string2));
        return this.put((SymbolTable$Entry)new SymbolTable$Entry((int)this.constantPoolCount++, (int)12, (String)string, (String)string2, (int)n2)).index;
    }

    int addConstantUtf8(String string) {
        int n = SymbolTable.hash(1, string);
        SymbolTable$Entry symbolTable$Entry = this.get(n);
        while (symbolTable$Entry != null) {
            if (symbolTable$Entry.tag == 1 && symbolTable$Entry.hashCode == n && symbolTable$Entry.value.equals(string)) {
                return symbolTable$Entry.index;
            }
            symbolTable$Entry = symbolTable$Entry.next;
        }
        this.constantPool.putByte(1).putUTF8(string);
        return this.put((SymbolTable$Entry)new SymbolTable$Entry((int)this.constantPoolCount++, (int)1, (String)string, (int)n)).index;
    }

    Symbol addConstantMethodHandle(int n, String string, String string2, String string3, boolean bl) {
        int n2 = 15;
        int n3 = SymbolTable.hash(15, string, string2, string3, n);
        SymbolTable$Entry symbolTable$Entry = this.get(n3);
        while (symbolTable$Entry != null) {
            if (symbolTable$Entry.tag == 15 && symbolTable$Entry.hashCode == n3 && symbolTable$Entry.data == (long)n && symbolTable$Entry.owner.equals(string) && symbolTable$Entry.name.equals(string2) && symbolTable$Entry.value.equals(string3)) {
                return symbolTable$Entry;
            }
            symbolTable$Entry = symbolTable$Entry.next;
        }
        if (n <= 4) {
            this.constantPool.put112(15, n, this.addConstantFieldref((String)string, (String)string2, (String)string3).index);
        } else {
            this.constantPool.put112(15, n, this.addConstantMethodref((String)string, (String)string2, (String)string3, (boolean)bl).index);
        }
        return this.put(new SymbolTable$Entry(this.constantPoolCount++, 15, string, string2, string3, n, n3));
    }

    Symbol addConstantMethodType(String string) {
        return this.addConstantUtf8Reference(16, string);
    }

    Symbol addConstantInvokeDynamic(String string, String string2, Handle handle, Object ... objectArray) {
        Symbol symbol = this.addBootstrapMethod(handle, objectArray);
        return this.addConstantInvokeDynamic(string, string2, symbol.index);
    }

    private Symbol addConstantInvokeDynamic(String string, String string2, int n) {
        int n2 = 18;
        int n3 = SymbolTable.hash(18, string, string2, n);
        SymbolTable$Entry symbolTable$Entry = this.get(n3);
        while (symbolTable$Entry != null) {
            if (symbolTable$Entry.tag == 18 && symbolTable$Entry.hashCode == n3 && symbolTable$Entry.data == (long)n && symbolTable$Entry.name.equals(string) && symbolTable$Entry.value.equals(string2)) {
                return symbolTable$Entry;
            }
            symbolTable$Entry = symbolTable$Entry.next;
        }
        this.constantPool.put122(18, n, this.addConstantNameAndType(string, string2));
        return this.put(new SymbolTable$Entry(this.constantPoolCount++, 18, null, string, string2, n, n3));
    }

    Symbol addConstantModule(String string) {
        return this.addConstantUtf8Reference(19, string);
    }

    Symbol addConstantPackage(String string) {
        return this.addConstantUtf8Reference(20, string);
    }

    private Symbol addConstantUtf8Reference(int n, String string) {
        int n2 = SymbolTable.hash(n, string);
        SymbolTable$Entry symbolTable$Entry = this.get(n2);
        while (symbolTable$Entry != null) {
            if (symbolTable$Entry.tag == n && symbolTable$Entry.hashCode == n2 && symbolTable$Entry.value.equals(string)) {
                return symbolTable$Entry;
            }
            symbolTable$Entry = symbolTable$Entry.next;
        }
        this.constantPool.put12(n, this.addConstantUtf8(string));
        return this.put(new SymbolTable$Entry(this.constantPoolCount++, n, string, n2));
    }

    Symbol addBootstrapMethod(Handle handle, Object ... objectArray) {
        int n;
        ByteVector byteVector = this.bootstrapMethods;
        if (byteVector == null) {
            byteVector = this.bootstrapMethods = new ByteVector();
        }
        int n2 = byteVector.length;
        byteVector.putShort(this.addConstantMethodHandle((int)handle.tag, (String)handle.owner, (String)handle.name, (String)handle.descriptor, (boolean)handle.isInterface()).index);
        int n3 = objectArray.length;
        byteVector.putShort(n3);
        for (n = 0; n < n3; ++n) {
            byteVector.putShort(this.addConstant((Object)objectArray[n]).index);
        }
        n = byteVector.length - n2;
        int n4 = handle.hashCode();
        for (int i = 0; i < n3; ++i) {
            n4 ^= objectArray[i].hashCode();
        }
        return this.addBootstrapMethod(n2, n, n4 &= Integer.MAX_VALUE);
    }

    private Symbol addBootstrapMethod(int n, int n2, int n3) {
        byte[] byArray = this.bootstrapMethods.data;
        SymbolTable$Entry symbolTable$Entry = this.get(n3);
        while (symbolTable$Entry != null) {
            if (symbolTable$Entry.tag == 64 && symbolTable$Entry.hashCode == n3) {
                int n4 = (int)symbolTable$Entry.data;
                boolean bl = true;
                for (int i = 0; i < n2; ++i) {
                    if (byArray[n + i] == byArray[n4 + i]) continue;
                    bl = false;
                    break;
                }
                if (bl) {
                    this.bootstrapMethods.length = n;
                    return symbolTable$Entry;
                }
            }
            symbolTable$Entry = symbolTable$Entry.next;
        }
        return this.put(new SymbolTable$Entry(this.bootstrapMethodCount++, 64, n, n3));
    }

    Symbol getType(int n) {
        return this.typeTable[n];
    }

    int addType(String string) {
        int n = SymbolTable.hash(128, string);
        SymbolTable$Entry symbolTable$Entry = this.get(n);
        while (symbolTable$Entry != null) {
            if (symbolTable$Entry.tag == 128 && symbolTable$Entry.hashCode == n && symbolTable$Entry.value.equals(string)) {
                return symbolTable$Entry.index;
            }
            symbolTable$Entry = symbolTable$Entry.next;
        }
        return this.addType(new SymbolTable$Entry(this.typeCount, 128, string, n));
    }

    int addUninitializedType(String string, int n) {
        int n2 = SymbolTable.hash(129, string, n);
        SymbolTable$Entry symbolTable$Entry = this.get(n2);
        while (symbolTable$Entry != null) {
            if (symbolTable$Entry.tag == 129 && symbolTable$Entry.hashCode == n2 && symbolTable$Entry.data == (long)n && symbolTable$Entry.value.equals(string)) {
                return symbolTable$Entry.index;
            }
            symbolTable$Entry = symbolTable$Entry.next;
        }
        return this.addType(new SymbolTable$Entry(this.typeCount, 129, string, n, n2));
    }

    int addMergedType(int n, int n2) {
        int n3;
        long l = (long)n | (long)n2 << 32;
        int n4 = SymbolTable.hash(130, n + n2);
        SymbolTable$Entry symbolTable$Entry = this.get(n4);
        while (symbolTable$Entry != null) {
            if (symbolTable$Entry.tag == 130 && symbolTable$Entry.hashCode == n4 && symbolTable$Entry.data == l) {
                return symbolTable$Entry.info;
            }
            symbolTable$Entry = symbolTable$Entry.next;
        }
        String string = this.typeTable[n].value;
        String string2 = this.typeTable[n2].value;
        this.put((SymbolTable$Entry)new SymbolTable$Entry((int)this.typeCount, (int)130, (long)l, (int)n4)).info = n3 = this.addType(this.classWriter.getCommonSuperClass(string, string2));
        return n3;
    }

    private int addType(SymbolTable$Entry symbolTable$Entry) {
        if (this.typeTable == null) {
            this.typeTable = new SymbolTable$Entry[16];
        }
        if (this.typeCount == this.typeTable.length) {
            SymbolTable$Entry[] symbolTable$EntryArray = new SymbolTable$Entry[2 * this.typeTable.length];
            System.arraycopy(this.typeTable, 0, symbolTable$EntryArray, 0, this.typeTable.length);
            this.typeTable = symbolTable$EntryArray;
        }
        this.typeTable[this.typeCount++] = symbolTable$Entry;
        return this.put((SymbolTable$Entry)symbolTable$Entry).index;
    }

    private static int hash(int n, int n2) {
        return Integer.MAX_VALUE & n + n2;
    }

    private static int hash(int n, long l) {
        return Integer.MAX_VALUE & n + (int)l + (int)(l >>> 32);
    }

    private static int hash(int n, String string) {
        return Integer.MAX_VALUE & n + string.hashCode();
    }

    private static int hash(int n, String string, int n2) {
        return Integer.MAX_VALUE & n + string.hashCode() + n2;
    }

    private static int hash(int n, String string, String string2) {
        return Integer.MAX_VALUE & n + string.hashCode() * string2.hashCode();
    }

    private static int hash(int n, String string, String string2, int n2) {
        return Integer.MAX_VALUE & n + string.hashCode() * string2.hashCode() * (n2 + 1);
    }

    private static int hash(int n, String string, String string2, String string3) {
        return Integer.MAX_VALUE & n + string.hashCode() * string2.hashCode() * string3.hashCode();
    }

    private static int hash(int n, String string, String string2, String string3, int n2) {
        return Integer.MAX_VALUE & n + string.hashCode() * string2.hashCode() * string3.hashCode() * n2;
    }
}

