/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.convert;

import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.convert.Convert;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.convert.ConvertException;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.convert.Converter;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.util.Cache;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.util.ConcurrentCache;
import java.lang.reflect.Constructor;

class ConverterFactory {
    private final Cache cache = new ConcurrentCache();

    public Converter getInstance(Class clazz) {
        Converter converter = (Converter)this.cache.fetch(clazz);
        if (converter == null) {
            return this.getConverter(clazz);
        }
        return converter;
    }

    public Converter getInstance(Convert convert) {
        Class clazz = convert.value();
        if (clazz.isInterface()) {
            throw new ConvertException("Can not instantiate %s", clazz);
        }
        return this.getInstance(clazz);
    }

    private Converter getConverter(Class clazz) {
        Constructor constructor = this.getConstructor(clazz);
        if (constructor == null) {
            throw new ConvertException("No default constructor for %s", clazz);
        }
        return this.getConverter(clazz, constructor);
    }

    private Converter getConverter(Class clazz, Constructor constructor) {
        Converter converter = (Converter)constructor.newInstance(new Object[0]);
        if (converter != null) {
            this.cache.cache(clazz, converter);
        }
        return converter;
    }

    private Constructor getConstructor(Class clazz) {
        Constructor constructor = clazz.getDeclaredConstructor(new Class[0]);
        if (!constructor.isAccessible()) {
            constructor.setAccessible(true);
        }
        return constructor;
    }
}

