/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect;

import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Objects;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Preconditions;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.CollectPreconditions;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.Collections2;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.Iterators;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.RandomAccess;
import javax.annotation.Nullable;

public final class Lists {
    public static ArrayList newArrayList() {
        return new ArrayList();
    }

    public static ArrayList newArrayList(Iterable iterable) {
        Preconditions.checkNotNull(iterable);
        return iterable instanceof Collection ? new ArrayList(Collections2.cast(iterable)) : Lists.newArrayList(iterable.iterator());
    }

    public static ArrayList newArrayList(Iterator iterator) {
        ArrayList arrayList = Lists.newArrayList();
        Iterators.addAll(arrayList, iterator);
        return arrayList;
    }

    public static ArrayList newArrayListWithCapacity(int n) {
        CollectPreconditions.checkNonnegative(n, "initialArraySize");
        return new ArrayList(n);
    }

    public static LinkedList newLinkedList() {
        return new LinkedList();
    }

    static boolean equalsImpl(List list, @Nullable Object object) {
        if (object == Preconditions.checkNotNull(list)) {
            return true;
        }
        if (!(object instanceof List)) {
            return false;
        }
        List list2 = (List)object;
        int n = list.size();
        if (n != list2.size()) {
            return false;
        }
        if (list instanceof RandomAccess && list2 instanceof RandomAccess) {
            for (int i = 0; i < n; ++i) {
                if (Objects.equal(list.get(i), list2.get(i))) continue;
                return false;
            }
            return true;
        }
        return Iterators.elementsEqual(list.iterator(), list2.iterator());
    }

    static int indexOfImpl(List list, @Nullable Object object) {
        if (list instanceof RandomAccess) {
            return Lists.indexOfRandomAccess(list, object);
        }
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            if (!Objects.equal(object, listIterator.next())) continue;
            return listIterator.previousIndex();
        }
        return -1;
    }

    private static int indexOfRandomAccess(List list, @Nullable Object object) {
        int n = list.size();
        if (object == null) {
            for (int i = 0; i < n; ++i) {
                if (list.get(i) != null) continue;
                return i;
            }
        } else {
            for (int i = 0; i < n; ++i) {
                if (!object.equals(list.get(i))) continue;
                return i;
            }
        }
        return -1;
    }

    static int lastIndexOfImpl(List list, @Nullable Object object) {
        if (list instanceof RandomAccess) {
            return Lists.lastIndexOfRandomAccess(list, object);
        }
        ListIterator listIterator = list.listIterator(list.size());
        while (listIterator.hasPrevious()) {
            if (!Objects.equal(object, listIterator.previous())) continue;
            return listIterator.nextIndex();
        }
        return -1;
    }

    private static int lastIndexOfRandomAccess(List list, @Nullable Object object) {
        if (object == null) {
            for (int i = list.size() - 1; i >= 0; --i) {
                if (list.get(i) != null) continue;
                return i;
            }
        } else {
            for (int i = list.size() - 1; i >= 0; --i) {
                if (!object.equals(list.get(i))) continue;
                return i;
            }
        }
        return -1;
    }
}

