/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.com.carrotsearch.randomizedtesting;

import com.carrotsearch.ant.tasks.junit4.dependencies.com.carrotsearch.randomizedtesting.CloseableResourceInfo;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.carrotsearch.randomizedtesting.GroupEvaluator;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.carrotsearch.randomizedtesting.LifecycleScope;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.carrotsearch.randomizedtesting.ObjectProcedure;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.carrotsearch.randomizedtesting.RandomizedContext$PerThreadResources;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.carrotsearch.randomizedtesting.RandomizedRunner;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.carrotsearch.randomizedtesting.RandomizedTest;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.carrotsearch.randomizedtesting.Randomness;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.carrotsearch.randomizedtesting.Threads;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.carrotsearch.randomizedtesting.annotations.Nightly;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.carrotsearch.randomizedtesting.annotations.TestGroup;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.carrotsearch.randomizedtesting.annotations.TestGroup$Utilities;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.EnumMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.WeakHashMap;

public final class RandomizedContext {
    private static final Object _globalLock = new Object();
    private final Object _contextLock = new Object();
    static final IdentityHashMap contexts = new IdentityHashMap();
    final WeakHashMap perThreadResources = new WeakHashMap();
    private final ThreadGroup threadGroup;
    private final Class suiteClass;
    private final RandomizedRunner runner;
    private volatile boolean disposed;
    private EnumMap disposableResources = new EnumMap(LifecycleScope.class);
    private final boolean nightly;
    private Method currentMethod;

    private RandomizedContext(ThreadGroup threadGroup, Class clazz, RandomizedRunner randomizedRunner) {
        boolean bl;
        this.threadGroup = threadGroup;
        this.suiteClass = clazz;
        this.runner = randomizedRunner;
        try {
            bl = RandomizedTest.systemPropertyAsBoolean(TestGroup$Utilities.getSysProperty(Nightly.class), Nightly.class.getAnnotation(TestGroup.class).enabled());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            bl = false;
        }
        this.nightly = bl;
    }

    public Class getTargetClass() {
        this.checkDisposed();
        return this.suiteClass;
    }

    Randomness[] getRandomnesses() {
        ArrayDeque arrayDeque = this.getPerThread().randomnesses;
        Randomness[] randomnessArray = arrayDeque.toArray(new Randomness[arrayDeque.size()]);
        int n = 0;
        for (int i = randomnessArray.length - 1; n < i; ++n, --i) {
            Randomness randomness = randomnessArray[n];
            randomnessArray[n] = randomnessArray[i];
            randomnessArray[i] = randomness;
        }
        return randomnessArray;
    }

    public static RandomizedContext current() {
        return RandomizedContext.context(Thread.currentThread());
    }

    public GroupEvaluator getGroupEvaluator() {
        return this.runner.groupEvaluator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeResources(ObjectProcedure objectProcedure, LifecycleScope lifecycleScope) {
        List list;
        Iterator iterator = this._contextLock;
        synchronized (iterator) {
            list = (List)this.disposableResources.remove((Object)lifecycleScope);
        }
        if (list != null) {
            for (CloseableResourceInfo closeableResourceInfo : list) {
                objectProcedure.apply(closeableResourceInfo);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static RandomizedContext context(Thread thread) {
        ThreadGroup threadGroup = thread.getThreadGroup();
        if (threadGroup == null) {
            throw new IllegalStateException("No context for a terminated thread: " + Threads.threadName(thread));
        }
        Object object = _globalLock;
        synchronized (object) {
            RandomizedContext randomizedContext;
            while ((randomizedContext = (RandomizedContext)contexts.get(threadGroup)) == null && threadGroup.getParent() != null) {
                threadGroup = threadGroup.getParent();
            }
            if (randomizedContext == null) {
                throw new IllegalStateException("No context information for thread: " + Threads.threadName(thread) + ". " + "Is this thread running under a " + RandomizedRunner.class + " runner context? Add @RunWith(" + RandomizedRunner.class + ".class)" + " to your test class. Make sure your code accesses random contexts within " + "@BeforeClass and @AfterClass boundary (for example, static test class initializers are " + "not permitted to access random contexts).");
            }
            Object object2 = randomizedContext._contextLock;
            synchronized (object2) {
                if (!randomizedContext.perThreadResources.containsKey(thread)) {
                    RandomizedContext$PerThreadResources randomizedContext$PerThreadResources = new RandomizedContext$PerThreadResources(null);
                    randomizedContext$PerThreadResources.randomnesses.push(randomizedContext.runner.runnerRandomness.clone(thread));
                    randomizedContext.perThreadResources.put(thread, randomizedContext$PerThreadResources);
                }
            }
            return randomizedContext;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static RandomizedContext create(ThreadGroup threadGroup, Class clazz, RandomizedRunner randomizedRunner) {
        assert (Thread.currentThread().getThreadGroup() == threadGroup);
        Object object = _globalLock;
        synchronized (object) {
            RandomizedContext randomizedContext = new RandomizedContext(threadGroup, clazz, randomizedRunner);
            contexts.put(threadGroup, randomizedContext);
            randomizedContext.perThreadResources.put(Thread.currentThread(), new RandomizedContext$PerThreadResources(null));
            return randomizedContext;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dispose() {
        Object object = _globalLock;
        synchronized (object) {
            this.checkDisposed();
            this.disposed = true;
            contexts.remove(this.threadGroup);
            Object object2 = this._contextLock;
            synchronized (object2) {
                for (RandomizedContext$PerThreadResources randomizedContext$PerThreadResources : this.perThreadResources.values()) {
                    if (randomizedContext$PerThreadResources == null) continue;
                    for (Randomness randomness : randomizedContext$PerThreadResources.randomnesses) {
                        randomness.destroy();
                    }
                }
            }
        }
    }

    void push(Randomness randomness) {
        this.getPerThread().randomnesses.push(randomness);
    }

    void popAndDestroy() {
        ((Randomness)this.getPerThread().randomnesses.pop()).destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RandomizedContext$PerThreadResources getPerThread() {
        this.checkDisposed();
        Object object = this._contextLock;
        synchronized (object) {
            return (RandomizedContext$PerThreadResources)this.perThreadResources.get(Thread.currentThread());
        }
    }

    private void checkDisposed() {
        if (this.disposed) {
            throw new IllegalStateException("Context disposed: " + this.toString() + " for thread: " + Thread.currentThread());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void cloneFor(Thread thread) {
        if (thread.getState() != Thread.State.NEW) {
            throw new IllegalStateException("The thread to share context with is not in NEW state: " + thread);
        }
        ThreadGroup threadGroup = thread.getThreadGroup();
        if (threadGroup == null) {
            throw new IllegalStateException("No thread group for thread: " + thread);
        }
        Thread thread2 = Thread.currentThread();
        if (thread2.getThreadGroup() != threadGroup) {
            throw new IllegalArgumentException("Both threads must share the thread group.");
        }
        Object object = _globalLock;
        synchronized (object) {
            RandomizedContext randomizedContext = (RandomizedContext)contexts.get(threadGroup);
            if (randomizedContext == null) {
                throw new IllegalStateException("No context information for thread: " + thread);
            }
            Object object2 = randomizedContext._contextLock;
            synchronized (object2) {
                if (randomizedContext.perThreadResources.containsKey(thread)) {
                    throw new IllegalStateException("Context already initialized for thread: " + thread);
                }
                if (!randomizedContext.perThreadResources.containsKey(thread2)) {
                    throw new IllegalStateException("Context not initialized for thread: " + thread2);
                }
                RandomizedContext$PerThreadResources randomizedContext$PerThreadResources = new RandomizedContext$PerThreadResources(null);
                for (Randomness randomness : ((RandomizedContext$PerThreadResources)randomizedContext.perThreadResources.get((Object)thread2)).randomnesses) {
                    randomizedContext$PerThreadResources.randomnesses.addLast(randomness.clone(thread));
                }
                randomizedContext.perThreadResources.put(thread, randomizedContext$PerThreadResources);
            }
        }
    }

    void setTargetMethod(Method method) {
        this.currentMethod = method;
    }
}

