/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.balancers;

import com.carrotsearch.ant.tasks.junit4.balancers.TopHints$1;
import com.carrotsearch.ant.tasks.junit4.balancers.TopHints$Entry;
import com.carrotsearch.ant.tasks.junit4.listeners.ExecutionTimesReport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.ResourceCollection;

public class TopHints
extends Task {
    private static final Comparator byDescHint = new TopHints$1();
    private List resources = new ArrayList();
    private int max = 10;

    public void setMax(int n) {
        this.max = n;
    }

    public void add(ResourceCollection resourceCollection) {
        if (resourceCollection instanceof FileSet) {
            FileSet fileSet = (FileSet)resourceCollection;
            fileSet.setProject(this.getProject());
        }
        this.resources.add(resourceCollection);
    }

    public void execute() {
        Map map = ExecutionTimesReport.mergeHints(this.resources, null);
        ArrayList<TopHints$Entry> arrayList = new ArrayList<TopHints$Entry>();
        for (Map.Entry entry : map.entrySet()) {
            double d = 0.0;
            for (Long l : (List)entry.getValue()) {
                d += (double)l.longValue();
            }
            arrayList.add(new TopHints$Entry((String)entry.getKey(), d / (double)((List)entry.getValue()).size()));
        }
        Collections.sort(arrayList, byDescHint);
        int n = Math.min(this.max, arrayList.size());
        for (int i = 0; i < n; ++i) {
            this.log(String.format(Locale.ENGLISH, "%6.2fs | %s", ((TopHints$Entry)arrayList.get((int)i)).averageHint / 1000.0, ((TopHints$Entry)arrayList.get((int)i)).suiteName));
        }
    }
}

