/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.AbstractObjectCollection;
import com.carrotsearch.hppc.Accountable;
import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.BufferAllocationException;
import com.carrotsearch.hppc.HashContainers;
import com.carrotsearch.hppc.ObjectBufferVisualizer;
import com.carrotsearch.hppc.ObjectContainer;
import com.carrotsearch.hppc.ObjectLookupContainer;
import com.carrotsearch.hppc.ObjectSet;
import com.carrotsearch.hppc.Preallocable;
import com.carrotsearch.hppc.RamUsageEstimator;
import com.carrotsearch.hppc.cursors.ObjectCursor;
import com.carrotsearch.hppc.predicates.ObjectPredicate;
import com.carrotsearch.hppc.procedures.ObjectProcedure;
import java.util.Arrays;
import java.util.Iterator;

public class ObjectHashSet<KType>
extends AbstractObjectCollection<KType>
implements ObjectLookupContainer<KType>,
ObjectSet<KType>,
Preallocable,
Cloneable,
Accountable {
    public Object[] keys;
    protected int assigned;
    protected int mask;
    protected int resizeAt;
    protected boolean hasEmptyKey;
    protected double loadFactor;
    protected int iterationSeed;

    public ObjectHashSet() {
        this(4, 0.75);
    }

    public ObjectHashSet(int expectedElements) {
        this(expectedElements, 0.75);
    }

    public ObjectHashSet(int expectedElements, double loadFactor) {
        this.loadFactor = this.verifyLoadFactor(loadFactor);
        this.iterationSeed = HashContainers.nextIterationSeed();
        this.ensureCapacity(expectedElements);
    }

    public ObjectHashSet(ObjectContainer<? extends KType> container) {
        this(container.size());
        this.addAll(container);
    }

    @Override
    public boolean add(KType key) {
        Object existing;
        if (key == null) {
            assert (this.keys[this.mask + 1] == null);
            boolean added = !this.hasEmptyKey;
            this.hasEmptyKey = true;
            return added;
        }
        Object[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys[slot]) != null) {
            if (this.equals(existing, key)) {
                return false;
            }
            slot = slot + 1 & mask;
        }
        if (this.assigned == this.resizeAt) {
            this.allocateThenInsertThenRehash(slot, key);
        } else {
            keys[slot] = key;
        }
        ++this.assigned;
        return true;
    }

    @SafeVarargs
    public final int addAll(KType ... elements) {
        this.ensureCapacity(elements.length);
        int count = 0;
        for (KType e : elements) {
            if (!this.add(e)) continue;
            ++count;
        }
        return count;
    }

    public int addAll(ObjectContainer<? extends KType> container) {
        this.ensureCapacity(container.size());
        return this.addAll((Iterable<? extends ObjectCursor<? extends KType>>)container);
    }

    public int addAll(Iterable<? extends ObjectCursor<? extends KType>> iterable) {
        int count = 0;
        for (ObjectCursor<KType> objectCursor : iterable) {
            if (!this.add(objectCursor.value)) continue;
            ++count;
        }
        return count;
    }

    @Override
    public Object[] toArray() {
        Object[] cloned = new Object[this.size()];
        int j = 0;
        if (this.hasEmptyKey) {
            cloned[j++] = null;
        }
        Object[] keys = this.keys;
        int seed = this.nextIterationSeed();
        int inc = HashContainers.iterationIncrement(seed);
        int mask = this.mask;
        int slot = seed & mask;
        for (int i = 0; i <= mask; ++i) {
            Object existing = keys[slot];
            if (existing != null) {
                cloned[j++] = existing;
            }
            slot = slot + inc & mask;
        }
        return cloned;
    }

    public boolean remove(KType key) {
        Object existing;
        if (key == null) {
            boolean hadEmptyKey = this.hasEmptyKey;
            this.hasEmptyKey = false;
            return hadEmptyKey;
        }
        Object[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys[slot]) != null) {
            if (this.equals(existing, key)) {
                this.shiftConflictingKeys(slot);
                return true;
            }
            slot = slot + 1 & mask;
        }
        return false;
    }

    @Override
    public int removeAll(KType key) {
        return this.remove(key) ? 1 : 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int removeAll(ObjectContainer<? super KType> other) {
        int before = this.size();
        if (other.size() >= this.size() && other instanceof ObjectLookupContainer) {
            void var4_6;
            if (this.hasEmptyKey && other.contains(null)) {
                this.hasEmptyKey = false;
            }
            Object[] keys = this.keys;
            boolean bl = false;
            int max = this.mask;
            while (var4_6 <= max) {
                Object existing = keys[var4_6];
                if (existing != null && other.contains(existing)) {
                    this.shiftConflictingKeys((int)var4_6);
                    continue;
                }
                ++var4_6;
            }
        } else {
            for (ObjectCursor<Object> objectCursor : other) {
                this.remove(objectCursor.value);
            }
        }
        return before - this.size();
    }

    @Override
    public int removeAll(ObjectPredicate<? super KType> predicate) {
        int before = this.size();
        if (this.hasEmptyKey && predicate.apply(null)) {
            this.hasEmptyKey = false;
        }
        Object[] keys = this.keys;
        int slot = 0;
        int max = this.mask;
        while (slot <= max) {
            Object existing = keys[slot];
            if (existing != null && predicate.apply(existing)) {
                this.shiftConflictingKeys(slot);
                continue;
            }
            ++slot;
        }
        return before - this.size();
    }

    @Override
    public boolean contains(KType key) {
        Object existing;
        if (key == null) {
            return this.hasEmptyKey;
        }
        Object[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys[slot]) != null) {
            if (this.equals(existing, key)) {
                return true;
            }
            slot = slot + 1 & mask;
        }
        return false;
    }

    @Override
    public void clear() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        Arrays.fill(this.keys, null);
    }

    @Override
    public void release() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        this.keys = null;
        this.ensureCapacity(4);
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public void ensureCapacity(int expectedElements) {
        if (expectedElements > this.resizeAt || this.keys == null) {
            Object[] prevKeys = this.keys;
            this.allocateBuffers(HashContainers.minBufferSize(expectedElements, this.loadFactor));
            if (prevKeys != null && !this.isEmpty()) {
                this.rehash(prevKeys);
            }
        }
    }

    @Override
    public int size() {
        return this.assigned + (this.hasEmptyKey ? 1 : 0);
    }

    public int hashCode() {
        int h = this.hasEmptyKey ? -559038737 : 0;
        Object[] keys = this.keys;
        for (int slot = this.mask; slot >= 0; --slot) {
            Object existing = keys[slot];
            if (existing == null) continue;
            h += BitMixer.mix(existing);
        }
        return h;
    }

    public boolean equals(Object obj) {
        return obj != null && this.getClass() == obj.getClass() && this.sameKeys((ObjectSet)this.getClass().cast(obj));
    }

    private boolean sameKeys(ObjectSet<?> other) {
        if (other.size() != this.size()) {
            return false;
        }
        for (ObjectCursor objectCursor : other) {
            if (this.contains(objectCursor.value)) continue;
            return false;
        }
        return true;
    }

    public ObjectHashSet<KType> clone() {
        try {
            ObjectHashSet cloned = (ObjectHashSet)super.clone();
            cloned.keys = (Object[])this.keys.clone();
            cloned.hasEmptyKey = this.hasEmptyKey;
            cloned.iterationSeed = HashContainers.nextIterationSeed();
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Iterator<ObjectCursor<KType>> iterator() {
        return new EntryIterator();
    }

    @Override
    public long ramBytesAllocated() {
        return (long)(RamUsageEstimator.NUM_BYTES_OBJECT_HEADER + 16 + 8 + 1) + RamUsageEstimator.shallowSizeOfArray(this.keys);
    }

    @Override
    public long ramBytesUsed() {
        return (long)(RamUsageEstimator.NUM_BYTES_OBJECT_HEADER + 16 + 8 + 1) + RamUsageEstimator.shallowUsedSizeOfArray(this.keys, this.size());
    }

    protected int nextIterationSeed() {
        this.iterationSeed = BitMixer.mixPhi(this.iterationSeed);
        return this.iterationSeed;
    }

    @Override
    public <T extends ObjectProcedure<? super KType>> T forEach(T procedure) {
        if (this.hasEmptyKey) {
            procedure.apply(null);
        }
        Object[] keys = this.keys;
        int seed = this.nextIterationSeed();
        int inc = HashContainers.iterationIncrement(seed);
        int mask = this.mask;
        int slot = seed & mask;
        for (int i = 0; i <= mask; ++i) {
            Object existing = keys[slot];
            if (existing != null) {
                procedure.apply((Object)existing);
            }
            slot = slot + inc & mask;
        }
        return procedure;
    }

    @Override
    public <T extends ObjectPredicate<? super KType>> T forEach(T predicate) {
        Object existing;
        if (this.hasEmptyKey && !predicate.apply(null)) {
            return predicate;
        }
        Object[] keys = this.keys;
        int seed = this.nextIterationSeed();
        int inc = HashContainers.iterationIncrement(seed);
        int mask = this.mask;
        int slot = seed & mask;
        for (int i = 0; i <= mask && ((existing = keys[slot]) == null || predicate.apply((Object)existing)); ++i) {
            slot = slot + inc & mask;
        }
        return predicate;
    }

    @SafeVarargs
    public static <KType> ObjectHashSet<KType> from(KType ... elements) {
        ObjectHashSet<KType> set = new ObjectHashSet<KType>(elements.length);
        set.addAll(elements);
        return set;
    }

    protected int hashKey(KType key) {
        assert (key != null);
        return BitMixer.mixPhi(key);
    }

    public int indexOf(KType key) {
        Object existing;
        int mask = this.mask;
        if (key == null) {
            return this.hasEmptyKey ? mask + 1 : ~(mask + 1);
        }
        Object[] keys = this.keys;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys[slot]) != null) {
            if (this.equals(existing, key)) {
                return slot;
            }
            slot = slot + 1 & mask;
        }
        return ~slot;
    }

    public boolean indexExists(int index) {
        assert (index < 0 || index >= 0 && index <= this.mask || index == this.mask + 1 && this.hasEmptyKey);
        return index >= 0;
    }

    public KType indexGet(int index) {
        assert (index >= 0) : "The index must point at an existing key.";
        assert (index <= this.mask || index == this.mask + 1 && this.hasEmptyKey);
        return (KType)this.keys[index];
    }

    public KType indexReplace(int index, KType equivalentKey) {
        assert (index >= 0) : "The index must point at an existing key.";
        assert (index <= this.mask || index == this.mask + 1 && this.hasEmptyKey);
        assert (this.equals(equivalentKey, this.keys[index]));
        Object previousValue = this.keys[index];
        this.keys[index] = equivalentKey;
        return (KType)previousValue;
    }

    public void indexInsert(int index, KType key) {
        assert (index < 0) : "The index must not point at an existing key.";
        index ^= 0xFFFFFFFF;
        if (key == null) {
            assert (index == this.mask + 1);
            assert (this.keys[index] == null);
            this.hasEmptyKey = true;
        } else {
            assert (this.keys[index] == null);
            if (this.assigned == this.resizeAt) {
                this.allocateThenInsertThenRehash(index, key);
            } else {
                this.keys[index] = key;
            }
            ++this.assigned;
        }
    }

    @Override
    public String visualizeKeyDistribution(int characters) {
        return ObjectBufferVisualizer.visualizeKeyDistribution(this.keys, this.mask, characters);
    }

    protected double verifyLoadFactor(double loadFactor) {
        HashContainers.checkLoadFactor(loadFactor, 0.01f, 0.99f);
        return loadFactor;
    }

    protected void rehash(KType[] fromKeys) {
        assert (HashContainers.checkPowerOfTwo(fromKeys.length - 1));
        Object[] keys = this.keys;
        int mask = this.mask;
        int i = fromKeys.length - 1;
        while (--i >= 0) {
            KType existing = fromKeys[i];
            if (existing == null) continue;
            int slot = this.hashKey(existing) & mask;
            while (keys[slot] != null) {
                slot = slot + 1 & mask;
            }
            keys[slot] = existing;
        }
    }

    protected void allocateBuffers(int arraySize) {
        assert (Integer.bitCount(arraySize) == 1);
        Object[] prevKeys = this.keys;
        try {
            int emptyElementSlot = 1;
            this.keys = new Object[arraySize + emptyElementSlot];
        }
        catch (OutOfMemoryError e) {
            this.keys = prevKeys;
            throw new BufferAllocationException("Not enough memory to allocate buffers for rehashing: %,d -> %,d", (Throwable)e, this.keys == null ? 0 : this.size(), arraySize);
        }
        this.resizeAt = HashContainers.expandAtCount(arraySize, this.loadFactor);
        this.mask = arraySize - 1;
    }

    protected void allocateThenInsertThenRehash(int slot, KType pendingKey) {
        assert (this.assigned == this.resizeAt && this.keys[slot] == null && pendingKey != null);
        Object[] prevKeys = this.keys;
        this.allocateBuffers(HashContainers.nextBufferSize(this.mask + 1, this.size(), this.loadFactor));
        assert (this.keys.length > prevKeys.length);
        prevKeys[slot] = pendingKey;
        this.rehash(prevKeys);
    }

    protected void shiftConflictingKeys(int gapSlot) {
        int slot;
        Object existing;
        Object[] keys = this.keys;
        int mask = this.mask;
        int distance = 0;
        while ((existing = keys[slot = gapSlot + ++distance & mask]) != null) {
            int idealSlot = this.hashKey(existing);
            int shift = slot - idealSlot & mask;
            if (shift < distance) continue;
            keys[gapSlot] = existing;
            gapSlot = slot;
            distance = 0;
        }
        keys[gapSlot] = null;
        --this.assigned;
    }

    protected final class EntryIterator
    extends AbstractIterator<ObjectCursor<KType>> {
        private final ObjectCursor<KType> cursor = new ObjectCursor();
        private final int increment;
        private int index;
        private int slot;

        public EntryIterator() {
            int seed = ObjectHashSet.this.nextIterationSeed();
            this.increment = HashContainers.iterationIncrement(seed);
            this.slot = seed & ObjectHashSet.this.mask;
        }

        @Override
        protected ObjectCursor<KType> fetch() {
            int mask = ObjectHashSet.this.mask;
            while (this.index <= mask) {
                ++this.index;
                this.slot = this.slot + this.increment & mask;
                Object existing = ObjectHashSet.this.keys[this.slot];
                if (existing == null) continue;
                this.cursor.index = this.slot;
                this.cursor.value = existing;
                return this.cursor;
            }
            if (this.index == mask + 1 && ObjectHashSet.this.hasEmptyKey) {
                this.cursor.index = this.index++;
                this.cursor.value = null;
                return this.cursor;
            }
            return (ObjectCursor)this.done();
        }
    }
}

