/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractByteCollection;
import com.carrotsearch.hppc.AbstractCharCollection;
import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.Accountable;
import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.BitUtil;
import com.carrotsearch.hppc.BufferAllocationException;
import com.carrotsearch.hppc.ByteCollection;
import com.carrotsearch.hppc.CharBufferVisualizer;
import com.carrotsearch.hppc.CharByteAssociativeContainer;
import com.carrotsearch.hppc.CharByteMap;
import com.carrotsearch.hppc.CharContainer;
import com.carrotsearch.hppc.CharLookupContainer;
import com.carrotsearch.hppc.HashContainers;
import com.carrotsearch.hppc.Preallocable;
import com.carrotsearch.hppc.RamUsageEstimator;
import com.carrotsearch.hppc.WormUtil;
import com.carrotsearch.hppc.cursors.ByteCursor;
import com.carrotsearch.hppc.cursors.CharByteCursor;
import com.carrotsearch.hppc.cursors.CharCursor;
import com.carrotsearch.hppc.predicates.BytePredicate;
import com.carrotsearch.hppc.predicates.CharBytePredicate;
import com.carrotsearch.hppc.predicates.CharPredicate;
import com.carrotsearch.hppc.procedures.ByteProcedure;
import com.carrotsearch.hppc.procedures.CharByteProcedure;
import com.carrotsearch.hppc.procedures.CharProcedure;
import java.util.Arrays;
import java.util.Iterator;

public class CharByteWormMap
implements CharByteMap,
Preallocable,
Cloneable,
Accountable {
    public char[] keys;
    public byte[] values;
    public byte[] next;
    protected int size;
    protected int iterationSeed;

    public CharByteWormMap() {
        this(4);
    }

    public CharByteWormMap(int expectedElements) {
        if (expectedElements < 0) {
            throw new IllegalArgumentException("Invalid expectedElements=" + expectedElements);
        }
        this.iterationSeed = HashContainers.nextIterationSeed();
        this.ensureCapacity(expectedElements);
    }

    public CharByteWormMap(CharByteAssociativeContainer container) {
        this(container.size());
        this.putAll(container);
    }

    public static CharByteWormMap from(char[] keys, byte[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        CharByteWormMap map = new CharByteWormMap(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }

    public CharByteWormMap clone() {
        try {
            CharByteWormMap cloneMap = (CharByteWormMap)super.clone();
            cloneMap.keys = (char[])this.keys.clone();
            cloneMap.values = (byte[])this.values.clone();
            cloneMap.next = (byte[])this.next.clone();
            cloneMap.iterationSeed = HashContainers.nextIterationSeed();
            return cloneMap;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public byte noValue() {
        return 0;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public byte get(char key) {
        int hashIndex = this.hashMod(key);
        byte nextOffset = this.next[hashIndex];
        if (nextOffset <= 0) {
            return this.noValue();
        }
        int entryIndex = this.searchInChain(key, hashIndex, nextOffset);
        return entryIndex < 0 ? this.noValue() : this.values[entryIndex];
    }

    @Override
    public byte getOrDefault(char key, byte defaultValue) {
        byte value = this.get(key);
        return value == this.noValue() ? defaultValue : value;
    }

    @Override
    public byte put(char key, byte value) {
        return this.put(key, value, WormUtil.PutPolicy.NEW_OR_REPLACE, true);
    }

    @Override
    public int putAll(CharByteAssociativeContainer container) {
        int initialSize = this.size();
        for (CharByteCursor c : container) {
            this.put(c.key, c.value);
        }
        return this.size() - initialSize;
    }

    @Override
    public int putAll(Iterable<? extends CharByteCursor> iterable) {
        int initialSize = this.size();
        for (CharByteCursor charByteCursor : iterable) {
            this.put(charByteCursor.key, charByteCursor.value);
        }
        return this.size() - initialSize;
    }

    @Override
    public byte putOrAdd(char key, byte putValue, byte incrementValue) {
        int keyIndex = this.indexOf(key);
        if (this.indexExists(keyIndex)) {
            putValue = (byte)(this.values[keyIndex] + incrementValue);
            this.indexReplace(keyIndex, putValue);
        } else {
            this.indexInsert(keyIndex, key, putValue);
        }
        return putValue;
    }

    @Override
    public byte addTo(char key, byte additionValue) {
        return this.putOrAdd(key, additionValue, additionValue);
    }

    public boolean putIfAbsent(char key, byte value) {
        return this.noValue() == this.put(key, value, WormUtil.PutPolicy.NEW_ONLY_IF_ABSENT, true);
    }

    @Override
    public byte remove(char key) {
        byte[] next = this.next;
        int hashIndex = this.hashMod(key);
        byte nextOffset = next[hashIndex];
        if (nextOffset <= 0) {
            return this.noValue();
        }
        int previousEntryIndex = this.searchInChainReturnPrevious(key, hashIndex, nextOffset);
        if (previousEntryIndex < 0) {
            return this.noValue();
        }
        int entryToRemoveIndex = previousEntryIndex == Integer.MAX_VALUE ? hashIndex : WormUtil.addOffset(previousEntryIndex, Math.abs(next[previousEntryIndex]), next.length);
        return this.remove(hashIndex, previousEntryIndex, entryToRemoveIndex);
    }

    @Override
    public int removeAll(CharContainer other) {
        int size = this.size();
        if (other.size() >= size && other instanceof CharLookupContainer) {
            char[] keys = this.keys;
            byte[] next = this.next;
            int capacity = next.length;
            int entryIndex = 0;
            while (entryIndex < capacity) {
                char key;
                if (next[entryIndex] != 0 && other.contains(key = keys[entryIndex])) {
                    this.remove(key);
                    continue;
                }
                ++entryIndex;
            }
        } else {
            for (CharCursor c : other) {
                this.remove(c.value);
            }
        }
        return size - this.size();
    }

    @Override
    public int removeAll(CharPredicate predicate) {
        char[] keys = this.keys;
        byte[] next = this.next;
        int capacity = next.length;
        int size = this.size();
        int entryIndex = 0;
        while (entryIndex < capacity) {
            char key;
            if (next[entryIndex] != 0 && predicate.apply(key = keys[entryIndex])) {
                this.remove(key);
                continue;
            }
            ++entryIndex;
        }
        return size - this.size();
    }

    @Override
    public int removeAll(CharBytePredicate predicate) {
        char[] keys = this.keys;
        byte[] values = this.values;
        byte[] next = this.next;
        int capacity = next.length;
        int size = this.size();
        int entryIndex = 0;
        while (entryIndex < capacity) {
            char key;
            if (next[entryIndex] != 0 && predicate.apply(key = keys[entryIndex], values[entryIndex])) {
                this.remove(key);
                continue;
            }
            ++entryIndex;
        }
        return size - this.size();
    }

    @Override
    public <T extends CharByteProcedure> T forEach(T procedure) {
        char[] keys = this.keys;
        byte[] values = this.values;
        byte[] next = this.next;
        int seed = this.nextIterationSeed();
        int inc = HashContainers.iterationIncrement(seed);
        int mask = next.length - 1;
        int slot = seed & mask;
        for (int i = 0; i <= mask; ++i) {
            if (next[slot] != 0) {
                procedure.apply(keys[slot], values[slot]);
            }
            slot = slot + inc & mask;
        }
        return procedure;
    }

    @Override
    public <T extends CharBytePredicate> T forEach(T predicate) {
        char[] keys = this.keys;
        byte[] values = this.values;
        byte[] next = this.next;
        int seed = this.nextIterationSeed();
        int inc = HashContainers.iterationIncrement(seed);
        int mask = next.length - 1;
        int slot = seed & mask;
        for (int i = 0; i <= mask && (next[slot] == 0 || predicate.apply(keys[slot], values[slot])); ++i) {
            slot = slot + inc & mask;
        }
        return predicate;
    }

    @Override
    public KeysContainer keys() {
        return new KeysContainer();
    }

    @Override
    public ByteCollection values() {
        return new ValuesContainer();
    }

    @Override
    public Iterator<CharByteCursor> iterator() {
        return new EntryIterator();
    }

    @Override
    public boolean containsKey(char key) {
        int hashIndex = this.hashMod(key);
        byte nextOffset = this.next[hashIndex];
        if (nextOffset <= 0) {
            return false;
        }
        return this.searchInChain(key, hashIndex, nextOffset) >= 0;
    }

    @Override
    public void clear() {
        Arrays.fill(this.next, (byte)0);
        this.size = 0;
    }

    @Override
    public void release() {
        this.keys = null;
        this.values = null;
        this.next = null;
        this.size = 0;
        this.ensureCapacity(4);
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        int size = this.size;
        CharByteMap map = (CharByteMap)o;
        if (size != map.size()) {
            return false;
        }
        char[] keys = this.keys;
        byte[] values = this.values;
        byte[] next = this.next;
        int index = 0;
        int entryCount = 0;
        while (entryCount < size) {
            if (next[index] != 0) {
                if (map.get(keys[index]) != values[index]) {
                    return false;
                }
                ++entryCount;
            }
            ++index;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        int size = this.size;
        int index = 0;
        int entryCount = 0;
        while (entryCount < size) {
            if (this.next[index] != 0) {
                hashCode += BitMixer.mixPhi(this.keys[index]) ^ BitMixer.mixPhi(this.values[index]);
                ++entryCount;
            }
            ++index;
        }
        return hashCode;
    }

    protected int hashKey(char key) {
        return BitMixer.mixPhi(key);
    }

    private int hashMod(char key) {
        return this.hashKey(key) & this.next.length - 1;
    }

    @Override
    public int indexOf(char key) {
        int hashIndex = this.hashMod(key);
        byte nextOffset = this.next[hashIndex];
        if (nextOffset <= 0) {
            return ~hashIndex;
        }
        return this.searchInChain(key, hashIndex, nextOffset);
    }

    @Override
    public boolean indexExists(int index) {
        assert (index < this.next.length);
        return index >= 0;
    }

    @Override
    public byte indexGet(int index) {
        assert (WormUtil.checkIndex(index, this.next.length));
        return this.values[index];
    }

    @Override
    public byte indexReplace(int index, byte newValue) {
        assert (WormUtil.checkIndex(index, this.next.length));
        byte previousValue = this.values[index];
        this.values[index] = newValue;
        return previousValue;
    }

    @Override
    public void indexInsert(int index, char key, byte value) {
        assert (index < 0) : "The index must not point at an existing key.";
        if (this.next[index ^= 0xFFFFFFFF] == 0) {
            this.keys[index] = key;
            this.values[index] = value;
            this.next[index] = 127;
            ++this.size;
        } else {
            this.put(key, value, WormUtil.PutPolicy.NEW_GUARANTEED, true);
        }
    }

    public String toString() {
        StringBuilder sBuilder = new StringBuilder();
        sBuilder.append('[');
        int index = 0;
        int entryCount = 0;
        while (entryCount < this.size) {
            if (this.next[index] != 0) {
                if (entryCount > 0) {
                    sBuilder.append(", ");
                }
                sBuilder.append(this.keys[index]);
                sBuilder.append("=>");
                sBuilder.append(this.values[index]);
                ++entryCount;
            }
            ++index;
        }
        sBuilder.append(']');
        return sBuilder.toString();
    }

    @Override
    public void ensureCapacity(int expectedElements) {
        this.allocateBuffers((int)((float)expectedElements / 0.75f));
    }

    @Override
    public String visualizeKeyDistribution(int characters) {
        return CharBufferVisualizer.visualizeKeyDistribution(this.keys, this.next.length - 1, characters);
    }

    @Override
    public long ramBytesAllocated() {
        return (long)(RamUsageEstimator.NUM_BYTES_OBJECT_HEADER + 8) + RamUsageEstimator.shallowSizeOfArray(this.keys) + RamUsageEstimator.shallowSizeOfArray(this.values) + RamUsageEstimator.shallowSizeOfArray(this.next);
    }

    @Override
    public long ramBytesUsed() {
        return (long)(RamUsageEstimator.NUM_BYTES_OBJECT_HEADER + 8) + RamUsageEstimator.shallowUsedSizeOfArray(this.keys, this.size()) + RamUsageEstimator.shallowUsedSizeOfArray(this.values, this.size()) + RamUsageEstimator.shallowUsedSizeOfArray(this.next, this.size());
    }

    protected void allocateBuffers(int capacity) {
        capacity = Math.max(capacity, this.size);
        if ((capacity = Math.max(BitUtil.nextHighestPowerOfTwo(capacity), 4)) > 0x40000000) {
            throw new BufferAllocationException("Maximum array size exceeded (capacity: %d)", capacity);
        }
        if (this.keys != null && this.keys.length == capacity) {
            return;
        }
        char[] oldKeys = this.keys;
        byte[] oldValues = this.values;
        byte[] oldNext = this.next;
        this.keys = new char[capacity];
        this.values = new byte[capacity];
        this.next = new byte[capacity];
        if (oldKeys != null) {
            this.putOldEntries(oldKeys, oldValues, oldNext, this.size);
        }
    }

    private void putOldEntries(char[] oldKeys, byte[] oldValues, byte[] oldNext, int entryNum) {
        int entryCount = 0;
        int endIndex = oldNext.length;
        for (int index = 0; entryCount < entryNum && index < endIndex; ++index) {
            if (oldNext[index] == 0) continue;
            char oldKey = oldKeys[index];
            int hashIndex = this.hashMod(oldKey);
            this.putNewEntry(hashIndex, this.next[hashIndex], oldKey, oldValues[index]);
            ++entryCount;
        }
    }

    private byte put(char key, byte value, WormUtil.PutPolicy policy, boolean sizeIncrease) {
        int hashIndex = this.hashMod(key);
        byte nextOffset = this.next[hashIndex];
        boolean added = false;
        if (nextOffset > 0 && policy != WormUtil.PutPolicy.NEW_GUARANTEED) {
            int entryIndex = this.searchInChain(key, hashIndex, nextOffset);
            if (entryIndex >= 0) {
                byte previousValue = this.values[entryIndex];
                if (policy != WormUtil.PutPolicy.NEW_ONLY_IF_ABSENT) {
                    this.values[entryIndex] = value;
                }
                return previousValue;
            }
            if (this.enlargeIfNeeded()) {
                hashIndex = this.hashMod(key);
                nextOffset = this.next[hashIndex];
            } else {
                if (!this.appendTailOfChain(~entryIndex, key, value)) {
                    this.enlargeAndPutNewEntry(key, value);
                }
                added = true;
            }
        } else if (this.enlargeIfNeeded()) {
            hashIndex = this.hashMod(key);
            nextOffset = this.next[hashIndex];
        }
        if (!added) {
            this.putNewEntry(hashIndex, nextOffset, key, value);
        }
        if (sizeIncrease) {
            ++this.size;
        }
        return this.noValue();
    }

    private boolean enlargeIfNeeded() {
        if (this.size >= this.next.length) {
            this.allocateBuffers(this.next.length << 1);
            return true;
        }
        return false;
    }

    private void enlargeAndPutNewEntry(char key, byte value) {
        this.allocateBuffers(this.next.length << 1);
        this.put(key, value, WormUtil.PutPolicy.NEW_GUARANTEED, false);
    }

    private byte remove(int headIndex, int previousEntryIndex, int entryToRemoveIndex) {
        int lastIndex;
        assert (WormUtil.checkIndex(headIndex, this.next.length));
        assert (this.next[headIndex] > 0);
        assert (previousEntryIndex == Integer.MAX_VALUE || WormUtil.checkIndex(previousEntryIndex, this.next.length));
        assert (WormUtil.checkIndex(entryToRemoveIndex, this.next.length));
        byte[] next = this.next;
        byte previousValue = this.values[entryToRemoveIndex];
        int beforeLastIndex = WormUtil.findLastOfChain(entryToRemoveIndex, next[entryToRemoveIndex], true, next);
        if (beforeLastIndex == Integer.MAX_VALUE) {
            beforeLastIndex = previousEntryIndex;
            lastIndex = entryToRemoveIndex;
        } else {
            lastIndex = WormUtil.addOffset(beforeLastIndex, Math.abs(next[beforeLastIndex]), next.length);
        }
        if (entryToRemoveIndex != lastIndex) {
            this.keys[entryToRemoveIndex] = this.keys[lastIndex];
            this.values[entryToRemoveIndex] = this.values[lastIndex];
        }
        if (lastIndex != headIndex) {
            next[beforeLastIndex] = (byte)(beforeLastIndex == headIndex ? 127 : -127);
        }
        this.keys[lastIndex] = '\u0000';
        this.values[lastIndex] = this.noValue();
        next[lastIndex] = 0;
        --this.size;
        return previousValue;
    }

    private boolean appendTailOfChain(int lastEntryIndex, char key, byte value) {
        return this.appendTailOfChain(lastEntryIndex, key, value, WormUtil.ExcludedIndexes.NONE, 0);
    }

    private boolean appendTailOfChain(int lastEntryIndex, char key, byte value, WormUtil.ExcludedIndexes excludedIndexes, int recursiveCallLevel) {
        int capacity = this.next.length;
        int searchFromIndex = WormUtil.addOffset(lastEntryIndex, 1, capacity);
        int freeIndex = WormUtil.searchFreeBucket(searchFromIndex, WormUtil.maxOffset(capacity), -1, this.next);
        if (freeIndex == -1 && (freeIndex = this.searchAndMoveBucket(searchFromIndex, WormUtil.maxOffset(capacity), excludedIndexes, recursiveCallLevel)) == -1) {
            return false;
        }
        this.keys[freeIndex] = key;
        this.values[freeIndex] = value;
        this.next[freeIndex] = -127;
        int nextOffset = WormUtil.getOffsetBetweenIndexes(lastEntryIndex, freeIndex, this.next.length);
        this.next[lastEntryIndex] = (byte)(this.next[lastEntryIndex] > 0 ? nextOffset : -nextOffset);
        return true;
    }

    private int searchAndMoveBucket(int fromIndex, int range, WormUtil.ExcludedIndexes excludedIndexes, int recursiveCallLevel) {
        assert (WormUtil.checkIndex(fromIndex, this.next.length));
        assert (range >= 0 && range <= WormUtil.maxOffset(this.next.length)) : "range=" + range + ", maxOffset=" + WormUtil.maxOffset(this.next.length);
        int remainingAttempts = WormUtil.RECURSIVE_MOVE_ATTEMPTS[recursiveCallLevel];
        if (remainingAttempts <= 0 || range <= 0) {
            return -1;
        }
        byte[] next = this.next;
        int capacity = next.length;
        int nextRecursiveCallLevel = recursiveCallLevel + 1;
        for (int index = fromIndex + range - 1; index >= fromIndex; --index) {
            byte nextOffset;
            int rolledIndex = index & capacity - 1;
            if (excludedIndexes.isIndexExcluded(rolledIndex) || (nextOffset = next[rolledIndex]) >= 0) continue;
            if (this.moveTailOfChain(rolledIndex, nextOffset, excludedIndexes, nextRecursiveCallLevel)) {
                return rolledIndex;
            }
            if (--remainingAttempts > 0) continue;
            return -1;
        }
        return -1;
    }

    private void putNewEntry(int hashIndex, int nextOffset, char key, byte value) {
        assert (hashIndex == this.hashMod(key)) : "hashIndex=" + hashIndex + ", hashReduce(key)=" + this.hashMod(key);
        assert (WormUtil.checkIndex(hashIndex, this.next.length));
        assert (Math.abs(nextOffset) <= 127) : "nextOffset=" + nextOffset;
        assert (nextOffset == this.next[hashIndex]) : "nextOffset=" + nextOffset + ", next[hashIndex]=" + this.next[hashIndex];
        if (nextOffset > 0) {
            if (!this.appendTailOfChain(WormUtil.findLastOfChain(hashIndex, nextOffset, false, this.next), key, value)) {
                this.enlargeAndPutNewEntry(key, value);
            }
        } else {
            if (nextOffset < 0 && !this.moveTailOfChain(hashIndex, nextOffset, WormUtil.ExcludedIndexes.NONE, 0)) {
                this.enlargeAndPutNewEntry(key, value);
                return;
            }
            this.keys[hashIndex] = key;
            this.values[hashIndex] = value;
            this.next[hashIndex] = 127;
        }
    }

    private boolean moveTailOfChain(int tailIndex, int nextOffset, WormUtil.ExcludedIndexes excludedIndexes, int recursiveCallLevel) {
        boolean nextIndexWithinRange;
        int searchRange;
        int searchFromIndex;
        assert (WormUtil.checkIndex(tailIndex, this.next.length));
        assert (nextOffset < 0 && nextOffset >= -127) : "nextOffset=" + nextOffset;
        assert (nextOffset == this.next[tailIndex]) : "nextOffset=" + nextOffset + ", next[tailIndex]=" + this.next[tailIndex];
        byte[] next = this.next;
        int capacity = next.length;
        int maxOffset = WormUtil.maxOffset(capacity);
        int previousIndex = WormUtil.findPreviousInChain(tailIndex, next);
        int absPreviousOffset = Math.abs(next[previousIndex]);
        int nextIndex = nextOffset == -127 ? -1 : WormUtil.addOffset(tailIndex, -nextOffset, capacity);
        int offsetFromPreviousToNext = absPreviousOffset - nextOffset;
        if (offsetFromPreviousToNext <= maxOffset) {
            searchFromIndex = WormUtil.addOffset(previousIndex, 1, capacity);
            searchRange = offsetFromPreviousToNext - 1;
            nextIndexWithinRange = true;
        } else {
            if (nextIndex == -1) {
                searchFromIndex = WormUtil.addOffset(previousIndex, 1, capacity);
                searchRange = maxOffset;
            } else {
                searchFromIndex = WormUtil.addOffset(nextIndex, -maxOffset, capacity);
                int searchToIndex = WormUtil.addOffset(previousIndex, maxOffset, capacity);
                searchRange = WormUtil.getOffsetBetweenIndexes(searchFromIndex, searchToIndex, capacity) + 1;
            }
            nextIndexWithinRange = false;
        }
        int freeIndex = WormUtil.searchFreeBucket(searchFromIndex, searchRange, tailIndex, next);
        if (freeIndex == -1) {
            if (nextIndexWithinRange && this.appendTailOfChain(WormUtil.findLastOfChain(nextIndex, next[nextIndex], false, next), this.keys[tailIndex], this.values[tailIndex], excludedIndexes, recursiveCallLevel)) {
                int previousOffset = WormUtil.getOffsetBetweenIndexes(previousIndex, nextIndex, capacity);
                next[previousIndex] = (byte)(next[previousIndex] > 0 ? previousOffset : -previousOffset);
                return true;
            }
            WormUtil.ExcludedIndexes recursiveExcludedIndexes = excludedIndexes.union(WormUtil.ExcludedIndexes.fromChain(previousIndex, next));
            freeIndex = this.searchAndMoveBucket(searchFromIndex, searchRange, recursiveExcludedIndexes, recursiveCallLevel);
            if (freeIndex == -1) {
                return false;
            }
        }
        this.keys[freeIndex] = this.keys[tailIndex];
        this.values[freeIndex] = this.values[tailIndex];
        next[freeIndex] = (byte)(nextOffset == -127 ? nextOffset : -WormUtil.getOffsetBetweenIndexes(freeIndex, nextIndex, capacity));
        int previousOffset = WormUtil.getOffsetBetweenIndexes(previousIndex, freeIndex, capacity);
        next[previousIndex] = (byte)(next[previousIndex] > 0 ? previousOffset : -previousOffset);
        assert (next[freeIndex] < 0) : "freeIndex=" + freeIndex + ", next[freeIndex]=" + next[freeIndex];
        return true;
    }

    private int searchInChain(char key, int index, int nextOffset) {
        assert (WormUtil.checkIndex(index, this.next.length));
        assert (nextOffset > 0 && nextOffset <= 127) : "nextOffset=" + nextOffset;
        assert (nextOffset == this.next[index]) : "nextOffset=" + nextOffset + ", next[index]=" + this.next[index];
        if (key == this.keys[index]) {
            return index;
        }
        int capacity = this.next.length;
        while (nextOffset != 127) {
            if (key == this.keys[index = WormUtil.addOffset(index, nextOffset, capacity)]) {
                return index;
            }
            nextOffset = -this.next[index];
            assert (nextOffset > 0) : "nextOffset=" + nextOffset;
        }
        return ~index;
    }

    private int searchInChainReturnPrevious(char key, int index, int nextOffset) {
        assert (WormUtil.checkIndex(index, this.next.length));
        assert (nextOffset > 0 && nextOffset <= 127) : "nextOffset=" + nextOffset;
        assert (nextOffset == this.next[index]) : "nextOffset=" + nextOffset + ", next[index]=" + this.next[index];
        if (key == this.keys[index]) {
            return Integer.MAX_VALUE;
        }
        int capacity = this.next.length;
        while (nextOffset != 127) {
            int previousIndex = index;
            if (key == this.keys[index = WormUtil.addOffset(index, nextOffset, capacity)]) {
                return previousIndex;
            }
            nextOffset = -this.next[index];
            assert (nextOffset > 0) : "nextOffset=" + nextOffset;
        }
        return ~index;
    }

    protected int nextIterationSeed() {
        this.iterationSeed = BitMixer.mixPhi(this.iterationSeed);
        return this.iterationSeed;
    }

    final class KeysContainer
    extends AbstractCharCollection
    implements CharLookupContainer {
        KeysContainer() {
        }

        @Override
        public boolean contains(char e) {
            return CharByteWormMap.this.containsKey(e);
        }

        @Override
        public <T extends CharProcedure> T forEach(T procedure) {
            CharByteWormMap.this.forEach((key, value) -> procedure.apply(key));
            return procedure;
        }

        @Override
        public <T extends CharPredicate> T forEach(T predicate) {
            CharByteWormMap.this.forEach((key, value) -> predicate.apply(key));
            return predicate;
        }

        @Override
        public boolean isEmpty() {
            return CharByteWormMap.this.isEmpty();
        }

        @Override
        public Iterator<CharCursor> iterator() {
            return new KeysIterator();
        }

        @Override
        public int size() {
            return CharByteWormMap.this.size();
        }

        @Override
        public void clear() {
            CharByteWormMap.this.clear();
        }

        @Override
        public void release() {
            CharByteWormMap.this.release();
        }

        @Override
        public int removeAll(CharPredicate predicate) {
            return CharByteWormMap.this.removeAll(predicate);
        }

        @Override
        public int removeAll(char e) {
            return CharByteWormMap.this.remove(e) == CharByteWormMap.this.noValue() ? 0 : 1;
        }
    }

    private class ValuesContainer
    extends AbstractByteCollection {
        private ValuesContainer() {
        }

        @Override
        public int size() {
            return CharByteWormMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return CharByteWormMap.this.isEmpty();
        }

        @Override
        public boolean contains(byte value) {
            for (CharByteCursor c : CharByteWormMap.this) {
                if (c.value != value) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends ByteProcedure> T forEach(T procedure) {
            for (CharByteCursor c : CharByteWormMap.this) {
                procedure.apply(c.value);
            }
            return procedure;
        }

        @Override
        public <T extends BytePredicate> T forEach(T predicate) {
            for (CharByteCursor c : CharByteWormMap.this) {
                if (predicate.apply(c.value)) continue;
                break;
            }
            return predicate;
        }

        @Override
        public Iterator<ByteCursor> iterator() {
            return new ValuesIterator();
        }

        @Override
        public int removeAll(byte e) {
            return CharByteWormMap.this.removeAll((char key, byte value) -> value == e);
        }

        @Override
        public int removeAll(BytePredicate predicate) {
            return CharByteWormMap.this.removeAll((char key, byte value) -> predicate.apply(value));
        }

        @Override
        public void clear() {
            CharByteWormMap.this.clear();
        }

        @Override
        public void release() {
            CharByteWormMap.this.release();
        }
    }

    private class EntryIterator
    extends AbstractIterator<CharByteCursor> {
        private final CharByteCursor cursor = new CharByteCursor();
        private final int increment;
        private int index;
        private int slot;

        public EntryIterator() {
            int seed = CharByteWormMap.this.nextIterationSeed();
            this.increment = HashContainers.iterationIncrement(seed);
            this.slot = seed & CharByteWormMap.this.next.length - 1;
        }

        @Override
        protected CharByteCursor fetch() {
            int mask = CharByteWormMap.this.next.length - 1;
            while (this.index <= mask) {
                ++this.index;
                this.slot = this.slot + this.increment & mask;
                if (CharByteWormMap.this.next[this.slot] == 0) continue;
                this.cursor.index = this.slot;
                this.cursor.key = CharByteWormMap.this.keys[this.slot];
                this.cursor.value = CharByteWormMap.this.values[this.slot];
                return this.cursor;
            }
            return (CharByteCursor)this.done();
        }
    }

    private class ValuesIterator
    extends AbstractIterator<ByteCursor> {
        private final ByteCursor cursor = new ByteCursor();
        private final int increment;
        private int index;
        private int slot;

        public ValuesIterator() {
            int seed = CharByteWormMap.this.nextIterationSeed();
            this.increment = HashContainers.iterationIncrement(seed);
            this.slot = seed & CharByteWormMap.this.next.length - 1;
        }

        @Override
        protected ByteCursor fetch() {
            int mask = CharByteWormMap.this.next.length - 1;
            while (this.index <= mask) {
                ++this.index;
                this.slot = this.slot + this.increment & mask;
                if (CharByteWormMap.this.next[this.slot] == 0) continue;
                this.cursor.index = this.slot;
                this.cursor.value = CharByteWormMap.this.values[this.slot];
                return this.cursor;
            }
            return (ByteCursor)this.done();
        }
    }

    private class KeysIterator
    extends AbstractIterator<CharCursor> {
        private final CharCursor cursor = new CharCursor();
        private final int increment;
        private int index;
        private int slot;

        public KeysIterator() {
            int seed = CharByteWormMap.this.nextIterationSeed();
            this.increment = HashContainers.iterationIncrement(seed);
            this.slot = seed & CharByteWormMap.this.next.length - 1;
        }

        @Override
        protected CharCursor fetch() {
            int mask = CharByteWormMap.this.next.length - 1;
            while (this.index <= mask) {
                ++this.index;
                this.slot = this.slot + this.increment & mask;
                if (CharByteWormMap.this.next[this.slot] == 0) continue;
                this.cursor.index = this.slot;
                this.cursor.value = CharByteWormMap.this.keys[this.slot];
                return this.cursor;
            }
            return (CharCursor)this.done();
        }
    }
}

