package com.carrotsearch.hppc;

/**
 * A set of <code>int</code>s.
 */
 @javax.annotation.Generated(
    date = "2017-10-22T12:19:54+0200",
    value = "KTypeSet.java") 
public interface IntSet extends IntCollection {
  /**
   * Adds <code>k</code> to the set.
   * 
   * @return Returns <code>true</code> if this element was not part of the set
   *         before. Returns <code>false</code> if an equal element is already part of
   *         the set, <b>does not replace the existing element</b> with the argument.
   */
  public boolean add(int k);

  /**
   * Visually depict the distribution of keys.
   * 
   * @param characters
   *          The number of characters to "squeeze" the entire buffer into.
   * @return Returns a sequence of characters where '.' depicts an empty
   *         fragment of the internal buffer and 'X' depicts full or nearly full
   *         capacity within the buffer's range and anything between 1 and 9 is between.
   */
  public String visualizeKeyDistribution(int characters);
}
