/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.AbstractShortCollection;
import com.carrotsearch.hppc.HashContainerUtils;
import com.carrotsearch.hppc.Internals;
import com.carrotsearch.hppc.ShortContainer;
import com.carrotsearch.hppc.ShortLookupContainer;
import com.carrotsearch.hppc.ShortSet;
import com.carrotsearch.hppc.cursors.ShortCursor;
import com.carrotsearch.hppc.predicates.ShortPredicate;
import com.carrotsearch.hppc.procedures.ShortProcedure;
import java.util.Arrays;
import java.util.Iterator;

public class ShortOpenHashSet
extends AbstractShortCollection
implements ShortLookupContainer,
ShortSet,
Cloneable {
    public static final int MIN_CAPACITY = 4;
    public static final int DEFAULT_CAPACITY = 16;
    public static final float DEFAULT_LOAD_FACTOR = 0.75f;
    public short[] keys;
    public boolean[] allocated;
    public int assigned;
    public final float loadFactor;
    protected int resizeAt;
    protected int lastSlot;
    protected int perturbation;

    public ShortOpenHashSet() {
        this(16, 0.75f);
    }

    public ShortOpenHashSet(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public ShortOpenHashSet(int initialCapacity, float loadFactor) {
        initialCapacity = Math.max(initialCapacity, 4);
        assert (initialCapacity > 0) : "Initial capacity must be between (0, 2147483647].";
        assert (loadFactor > 0.0f && loadFactor <= 1.0f) : "Load factor must be between (0, 1].";
        this.loadFactor = loadFactor;
        this.allocateBuffers(HashContainerUtils.roundCapacity(initialCapacity));
    }

    public ShortOpenHashSet(ShortContainer container) {
        this((int)((float)container.size() * 1.75f));
        this.addAll(container);
    }

    @Override
    public boolean add(short e) {
        assert (this.assigned < this.allocated.length);
        int mask = this.allocated.length - 1;
        int slot = Internals.rehash(e, this.perturbation) & mask;
        while (this.allocated[slot]) {
            if (e == this.keys[slot]) {
                return false;
            }
            slot = slot + 1 & mask;
        }
        if (this.assigned == this.resizeAt) {
            this.expandAndAdd(e, slot);
        } else {
            ++this.assigned;
            this.allocated[slot] = true;
            this.keys[slot] = e;
        }
        return true;
    }

    public int add(short e1, short e2) {
        int count = 0;
        if (this.add(e1)) {
            ++count;
        }
        if (this.add(e2)) {
            ++count;
        }
        return count;
    }

    public int add(short ... elements) {
        int count = 0;
        for (short e : elements) {
            if (!this.add(e)) continue;
            ++count;
        }
        return count;
    }

    public int addAll(ShortContainer container) {
        return this.addAll((Iterable<? extends ShortCursor>)container);
    }

    public int addAll(Iterable<? extends ShortCursor> iterable) {
        int count = 0;
        for (ShortCursor shortCursor : iterable) {
            if (!this.add(shortCursor.value)) continue;
            ++count;
        }
        return count;
    }

    private void expandAndAdd(short pendingKey, int freeSlot) {
        assert (this.assigned == this.resizeAt);
        assert (!this.allocated[freeSlot]);
        short[] oldKeys = this.keys;
        boolean[] oldAllocated = this.allocated;
        this.allocateBuffers(HashContainerUtils.nextCapacity(this.keys.length));
        this.lastSlot = -1;
        ++this.assigned;
        oldAllocated[freeSlot] = true;
        oldKeys[freeSlot] = pendingKey;
        short[] keys = this.keys;
        boolean[] allocated = this.allocated;
        int mask = allocated.length - 1;
        int i = oldAllocated.length;
        while (--i >= 0) {
            if (!oldAllocated[i]) continue;
            short k = oldKeys[i];
            int slot = Internals.rehash(k, this.perturbation) & mask;
            while (allocated[slot]) {
                slot = slot + 1 & mask;
            }
            allocated[slot] = true;
            keys[slot] = k;
        }
    }

    private void allocateBuffers(int capacity) {
        short[] keys = new short[capacity];
        boolean[] allocated = new boolean[capacity];
        this.keys = keys;
        this.allocated = allocated;
        this.resizeAt = Math.max(2, (int)Math.ceil((float)capacity * this.loadFactor)) - 1;
        this.perturbation = this.computePerturbationValue(capacity);
    }

    protected int computePerturbationValue(int capacity) {
        return HashContainerUtils.PERTURBATIONS[Integer.numberOfLeadingZeros(capacity)];
    }

    @Override
    public int removeAllOccurrences(short key) {
        return this.remove(key) ? 1 : 0;
    }

    public boolean remove(short key) {
        int mask = this.allocated.length - 1;
        int slot = Internals.rehash(key, this.perturbation) & mask;
        while (this.allocated[slot]) {
            if (key == this.keys[slot]) {
                --this.assigned;
                this.shiftConflictingKeys(slot);
                return true;
            }
            slot = slot + 1 & mask;
        }
        return false;
    }

    protected void shiftConflictingKeys(int slotCurr) {
        int mask = this.allocated.length - 1;
        while (true) {
            int slotPrev = slotCurr;
            slotCurr = slotPrev + 1 & mask;
            while (this.allocated[slotCurr]) {
                int slotOther = Internals.rehash(this.keys[slotCurr], this.perturbation) & mask;
                if (slotPrev <= slotCurr ? slotPrev >= slotOther || slotOther > slotCurr : slotPrev >= slotOther && slotOther > slotCurr) break;
                slotCurr = slotCurr + 1 & mask;
            }
            if (!this.allocated[slotCurr]) break;
            this.keys[slotPrev] = this.keys[slotCurr];
        }
        this.allocated[slotPrev] = false;
    }

    public int lslot() {
        assert (this.lastSlot >= 0) : "Call contains() first.";
        return this.lastSlot;
    }

    @Override
    public boolean contains(short key) {
        int mask = this.allocated.length - 1;
        int slot = Internals.rehash(key, this.perturbation) & mask;
        while (this.allocated[slot]) {
            if (key == this.keys[slot]) {
                this.lastSlot = slot;
                return true;
            }
            slot = slot + 1 & mask;
        }
        this.lastSlot = -1;
        return false;
    }

    @Override
    public void clear() {
        this.assigned = 0;
        Arrays.fill(this.allocated, false);
        Arrays.fill(this.keys, (short)0);
    }

    @Override
    public int size() {
        return this.assigned;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public int hashCode() {
        int h = 0;
        short[] keys = this.keys;
        boolean[] states = this.allocated;
        int i = states.length;
        while (--i >= 0) {
            if (!states[i]) continue;
            h += Internals.rehash(keys[i], this.perturbation);
        }
        return h;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null) {
            ShortSet other;
            if (obj == this) {
                return true;
            }
            if (obj instanceof ShortSet && (other = (ShortSet)obj).size() == this.size()) {
                for (ShortCursor c : this) {
                    if (other.contains(c.value)) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public Iterator<ShortCursor> iterator() {
        return new EntryIterator();
    }

    @Override
    public <T extends ShortProcedure> T forEach(T procedure) {
        short[] keys = this.keys;
        boolean[] states = this.allocated;
        for (int i = 0; i < states.length; ++i) {
            if (!states[i]) continue;
            procedure.apply(keys[i]);
        }
        return procedure;
    }

    @Override
    public short[] toArray() {
        short[] cloned = new short[this.assigned];
        int j = 0;
        for (int i = 0; i < this.keys.length; ++i) {
            if (!this.allocated[i]) continue;
            cloned[j++] = this.keys[i];
        }
        return cloned;
    }

    public ShortOpenHashSet clone() {
        try {
            ShortOpenHashSet cloned = (ShortOpenHashSet)super.clone();
            cloned.keys = (short[])this.keys.clone();
            cloned.allocated = (boolean[])this.allocated.clone();
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <T extends ShortPredicate> T forEach(T predicate) {
        short[] keys = this.keys;
        boolean[] states = this.allocated;
        for (int i = 0; i < states.length && (!states[i] || predicate.apply(keys[i])); ++i) {
        }
        return predicate;
    }

    @Override
    public int removeAll(ShortPredicate predicate) {
        short[] keys = this.keys;
        boolean[] allocated = this.allocated;
        int before = this.assigned;
        int i = 0;
        while (i < allocated.length) {
            if (allocated[i] && predicate.apply(keys[i])) {
                --this.assigned;
                this.shiftConflictingKeys(i);
                continue;
            }
            ++i;
        }
        return before - this.assigned;
    }

    public static ShortOpenHashSet from(short ... elements) {
        ShortOpenHashSet set = new ShortOpenHashSet((int)((float)elements.length * 1.75f));
        set.add(elements);
        return set;
    }

    public static ShortOpenHashSet from(ShortContainer container) {
        return new ShortOpenHashSet(container);
    }

    public static ShortOpenHashSet newInstance() {
        return new ShortOpenHashSet();
    }

    public static ShortOpenHashSet newInstanceWithoutPerturbations() {
        return new ShortOpenHashSet(){

            @Override
            protected int computePerturbationValue(int capacity) {
                return 0;
            }
        };
    }

    public static ShortOpenHashSet newInstanceWithCapacity(int initialCapacity, float loadFactor) {
        return new ShortOpenHashSet(initialCapacity, loadFactor);
    }

    private final class EntryIterator
    extends AbstractIterator<ShortCursor> {
        private final ShortCursor cursor = new ShortCursor();

        public EntryIterator() {
            this.cursor.index = -1;
        }

        @Override
        protected ShortCursor fetch() {
            int i;
            int max = ShortOpenHashSet.this.keys.length;
            for (i = this.cursor.index + 1; i < ShortOpenHashSet.this.keys.length && !ShortOpenHashSet.this.allocated[i]; ++i) {
            }
            if (i == max) {
                return (ShortCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.value = ShortOpenHashSet.this.keys[i];
            return this.cursor;
        }
    }
}

