/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.AbstractShortCollection;
import com.carrotsearch.hppc.ArraySizingStrategy;
import com.carrotsearch.hppc.BoundedProportionalArraySizingStrategy;
import com.carrotsearch.hppc.Internals;
import com.carrotsearch.hppc.ShortContainer;
import com.carrotsearch.hppc.ShortIndexedContainer;
import com.carrotsearch.hppc.cursors.ShortCursor;
import com.carrotsearch.hppc.predicates.ShortPredicate;
import com.carrotsearch.hppc.procedures.ShortProcedure;
import java.util.Arrays;
import java.util.Iterator;

public class ShortArrayList
extends AbstractShortCollection
implements ShortIndexedContainer,
Cloneable {
    public static final int DEFAULT_CAPACITY = 5;
    private static final Object EMPTY = new short[0];
    public short[] buffer;
    public int elementsCount;
    protected final ArraySizingStrategy resizer;

    public ShortArrayList() {
        this(5);
    }

    public ShortArrayList(int initialCapacity) {
        this(initialCapacity, new BoundedProportionalArraySizingStrategy());
    }

    public ShortArrayList(int initialCapacity, ArraySizingStrategy resizer) {
        assert (initialCapacity >= 0) : "initialCapacity must be >= 0: " + initialCapacity;
        assert (resizer != null);
        this.resizer = resizer;
        this.ensureBufferSpace(resizer.round(initialCapacity));
    }

    public ShortArrayList(ShortContainer container) {
        this(container.size());
        this.addAll(container);
    }

    @Override
    public void add(short e1) {
        this.ensureBufferSpace(1);
        this.buffer[this.elementsCount++] = e1;
    }

    public void add(short e1, short e2) {
        this.ensureBufferSpace(2);
        this.buffer[this.elementsCount++] = e1;
        this.buffer[this.elementsCount++] = e2;
    }

    public void add(short[] elements, int start, int length) {
        assert (length >= 0) : "Length must be >= 0";
        this.ensureBufferSpace(length);
        System.arraycopy(elements, start, this.buffer, this.elementsCount, length);
        this.elementsCount += length;
    }

    public void add(short ... elements) {
        this.add(elements, 0, elements.length);
    }

    public int addAll(ShortContainer container) {
        int size = container.size();
        this.ensureBufferSpace(size);
        for (ShortCursor cursor : container) {
            this.add(cursor.value);
        }
        return size;
    }

    public int addAll(Iterable<? extends ShortCursor> iterable) {
        int size = 0;
        for (ShortCursor shortCursor : iterable) {
            this.add(shortCursor.value);
            ++size;
        }
        return size;
    }

    @Override
    public void insert(int index, short e1) {
        assert (index >= 0 && index <= this.size()) : "Index " + index + " out of bounds [" + 0 + ", " + this.size() + "].";
        this.ensureBufferSpace(1);
        System.arraycopy(this.buffer, index, this.buffer, index + 1, this.elementsCount - index);
        this.buffer[index] = e1;
        ++this.elementsCount;
    }

    @Override
    public short get(int index) {
        assert (index >= 0 && index < this.size()) : "Index " + index + " out of bounds [" + 0 + ", " + this.size() + ").";
        return this.buffer[index];
    }

    @Override
    public short set(int index, short e1) {
        assert (index >= 0 && index < this.size()) : "Index " + index + " out of bounds [" + 0 + ", " + this.size() + ").";
        short v = this.buffer[index];
        this.buffer[index] = e1;
        return v;
    }

    @Override
    public short remove(int index) {
        assert (index >= 0 && index < this.size()) : "Index " + index + " out of bounds [" + 0 + ", " + this.size() + ").";
        short v = this.buffer[index];
        if (index + 1 < this.elementsCount) {
            System.arraycopy(this.buffer, index + 1, this.buffer, index, this.elementsCount - index - 1);
        }
        --this.elementsCount;
        this.buffer[this.elementsCount] = 0;
        return v;
    }

    @Override
    public void removeRange(int fromIndex, int toIndex) {
        assert (fromIndex >= 0 && fromIndex <= this.size()) : "Index " + fromIndex + " out of bounds [" + 0 + ", " + this.size() + ").";
        assert (toIndex >= 0 && toIndex <= this.size()) : "Index " + toIndex + " out of bounds [" + 0 + ", " + this.size() + "].";
        assert (fromIndex <= toIndex) : "fromIndex must be <= toIndex: " + fromIndex + ", " + toIndex;
        System.arraycopy(this.buffer, toIndex, this.buffer, fromIndex, this.elementsCount - toIndex);
        int count = toIndex - fromIndex;
        this.elementsCount -= count;
        Arrays.fill(this.buffer, this.elementsCount, this.elementsCount + count, (short)0);
    }

    @Override
    public int removeFirstOccurrence(short e1) {
        int index = this.indexOf(e1);
        if (index >= 0) {
            this.remove(index);
        }
        return index;
    }

    @Override
    public int removeLastOccurrence(short e1) {
        int index = this.lastIndexOf(e1);
        if (index >= 0) {
            this.remove(index);
        }
        return index;
    }

    @Override
    public int removeAllOccurrences(short e1) {
        int to = 0;
        for (int from = 0; from < this.elementsCount; ++from) {
            if (e1 == this.buffer[from]) {
                this.buffer[from] = 0;
                continue;
            }
            if (to != from) {
                this.buffer[to] = this.buffer[from];
                this.buffer[from] = 0;
            }
            ++to;
        }
        int deleted = this.elementsCount - to;
        this.elementsCount = to;
        return deleted;
    }

    @Override
    public boolean contains(short e1) {
        return this.indexOf(e1) >= 0;
    }

    @Override
    public int indexOf(short e1) {
        for (int i = 0; i < this.elementsCount; ++i) {
            if (e1 != this.buffer[i]) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(short e1) {
        for (int i = this.elementsCount - 1; i >= 0; --i) {
            if (e1 != this.buffer[i]) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean isEmpty() {
        return this.elementsCount == 0;
    }

    public void ensureCapacity(int minCapacity) {
        if (minCapacity > this.buffer.length) {
            this.ensureBufferSpace(minCapacity - this.size());
        }
    }

    protected void ensureBufferSpace(int expectedAdditions) {
        int bufferLen;
        int n = bufferLen = this.buffer == null ? 0 : this.buffer.length;
        if (this.elementsCount + expectedAdditions >= bufferLen) {
            int newSize = this.resizer.grow(bufferLen, this.elementsCount, expectedAdditions);
            assert (newSize >= this.elementsCount + expectedAdditions) : "Resizer failed to return sensible new size: " + newSize + " <= " + (this.elementsCount + expectedAdditions);
            short[] newBuffer = new short[newSize];
            if (bufferLen > 0) {
                System.arraycopy(this.buffer, 0, newBuffer, 0, this.buffer.length);
            }
            this.buffer = newBuffer;
        }
    }

    public void resize(int newSize) {
        if (newSize <= this.buffer.length) {
            if (newSize < this.elementsCount) {
                Arrays.fill(this.buffer, newSize, this.elementsCount, (short)0);
            } else {
                Arrays.fill(this.buffer, this.elementsCount, newSize, (short)0);
            }
        } else {
            this.ensureCapacity(newSize);
        }
        this.elementsCount = newSize;
    }

    @Override
    public int size() {
        return this.elementsCount;
    }

    public void trimToSize() {
        if (this.size() != this.buffer.length) {
            this.buffer = this.toArray();
        }
    }

    @Override
    public void clear() {
        Arrays.fill(this.buffer, 0, this.elementsCount, (short)0);
        this.elementsCount = 0;
    }

    public void release() {
        this.buffer = (short[])EMPTY;
        this.elementsCount = 0;
    }

    @Override
    public short[] toArray() {
        return Arrays.copyOf(this.buffer, this.elementsCount);
    }

    public ShortArrayList clone() {
        try {
            ShortArrayList cloned = (ShortArrayList)super.clone();
            cloned.buffer = (short[])this.buffer.clone();
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int hashCode() {
        int h = 1;
        int max = this.elementsCount;
        for (int i = 0; i < max; ++i) {
            h = 31 * h + Internals.rehash(this.buffer[i]);
        }
        return h;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null) {
            if (obj instanceof ShortArrayList) {
                ShortArrayList other = (ShortArrayList)obj;
                return other.size() == this.size() && this.rangeEquals(other.buffer, this.buffer, this.size());
            }
            if (obj instanceof ShortIndexedContainer) {
                ShortIndexedContainer other = (ShortIndexedContainer)obj;
                return other.size() == this.size() && this.allIndexesEqual(this, other, this.size());
            }
        }
        return false;
    }

    private boolean rangeEquals(short[] b1, short[] b2, int length) {
        for (int i = 0; i < length; ++i) {
            if (b1[i] == b2[i]) continue;
            return false;
        }
        return true;
    }

    private boolean allIndexesEqual(ShortIndexedContainer b1, ShortIndexedContainer b2, int length) {
        for (int i = 0; i < length; ++i) {
            short o2;
            short o1 = b1.get(i);
            if (o1 == (o2 = b2.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public Iterator<ShortCursor> iterator() {
        return new ValueIterator(this.buffer, this.size());
    }

    @Override
    public <T extends ShortProcedure> T forEach(T procedure) {
        return this.forEach(procedure, 0, this.size());
    }

    public <T extends ShortProcedure> T forEach(T procedure, int fromIndex, int toIndex) {
        assert (fromIndex >= 0 && fromIndex <= this.size()) : "Index " + fromIndex + " out of bounds [" + 0 + ", " + this.size() + ").";
        assert (toIndex >= 0 && toIndex <= this.size()) : "Index " + toIndex + " out of bounds [" + 0 + ", " + this.size() + "].";
        assert (fromIndex <= toIndex) : "fromIndex must be <= toIndex: " + fromIndex + ", " + toIndex;
        short[] buffer = this.buffer;
        for (int i = fromIndex; i < toIndex; ++i) {
            procedure.apply(buffer[i]);
        }
        return procedure;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int removeAll(ShortPredicate predicate) {
        int from;
        int elementsCount = this.elementsCount;
        int to = 0;
        try {
            for (from = 0; from < elementsCount; ++from) {
                if (predicate.apply(this.buffer[from])) {
                    this.buffer[from] = 0;
                    continue;
                }
                if (to != from) {
                    this.buffer[to] = this.buffer[from];
                    this.buffer[from] = 0;
                }
                ++to;
            }
        }
        finally {
            while (from < elementsCount) {
                if (to != from) {
                    this.buffer[to] = this.buffer[from];
                    this.buffer[from] = 0;
                }
                ++to;
                ++from;
            }
            this.elementsCount = to;
        }
        return elementsCount - to;
    }

    @Override
    public <T extends ShortPredicate> T forEach(T predicate) {
        return this.forEach(predicate, 0, this.size());
    }

    public <T extends ShortPredicate> T forEach(T predicate, int fromIndex, int toIndex) {
        assert (fromIndex >= 0 && fromIndex <= this.size()) : "Index " + fromIndex + " out of bounds [" + 0 + ", " + this.size() + ").";
        assert (toIndex >= 0 && toIndex <= this.size()) : "Index " + toIndex + " out of bounds [" + 0 + ", " + this.size() + "].";
        assert (fromIndex <= toIndex) : "fromIndex must be <= toIndex: " + fromIndex + ", " + toIndex;
        short[] buffer = this.buffer;
        for (int i = fromIndex; i < toIndex && predicate.apply(buffer[i]); ++i) {
        }
        return predicate;
    }

    public static ShortArrayList newInstance() {
        return new ShortArrayList();
    }

    public static ShortArrayList newInstanceWithCapacity(int initialCapacity) {
        return new ShortArrayList(initialCapacity);
    }

    public static ShortArrayList from(short ... elements) {
        ShortArrayList list = new ShortArrayList(elements.length);
        list.add(elements);
        return list;
    }

    public static ShortArrayList from(ShortContainer container) {
        return new ShortArrayList(container);
    }

    static final class ValueIterator
    extends AbstractIterator<ShortCursor> {
        private final ShortCursor cursor = new ShortCursor();
        private final short[] buffer;
        private final int size;

        public ValueIterator(short[] buffer, int size) {
            this.cursor.index = -1;
            this.size = size;
            this.buffer = buffer;
        }

        @Override
        protected ShortCursor fetch() {
            if (this.cursor.index + 1 == this.size) {
                return (ShortCursor)this.done();
            }
            this.cursor.value = this.buffer[++this.cursor.index];
            return this.cursor;
        }
    }
}

