/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.AbstractObjectCollection;
import com.carrotsearch.hppc.HashContainerUtils;
import com.carrotsearch.hppc.Internals;
import com.carrotsearch.hppc.ObjectContainer;
import com.carrotsearch.hppc.ObjectLookupContainer;
import com.carrotsearch.hppc.ObjectObjectAssociativeContainer;
import com.carrotsearch.hppc.ObjectObjectMap;
import com.carrotsearch.hppc.cursors.ObjectCursor;
import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import com.carrotsearch.hppc.predicates.ObjectPredicate;
import com.carrotsearch.hppc.procedures.ObjectObjectProcedure;
import com.carrotsearch.hppc.procedures.ObjectProcedure;
import java.util.Arrays;
import java.util.Iterator;

public class ObjectObjectOpenHashMap<KType, VType>
implements ObjectObjectMap<KType, VType>,
Cloneable {
    public static final int MIN_CAPACITY = 4;
    public static final int DEFAULT_CAPACITY = 16;
    public static final float DEFAULT_LOAD_FACTOR = 0.75f;
    public KType[] keys;
    public VType[] values;
    public boolean[] allocated;
    public int assigned;
    public final float loadFactor;
    private int resizeAt;
    private int lastSlot;

    public ObjectObjectOpenHashMap() {
        this(16);
    }

    public ObjectObjectOpenHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public ObjectObjectOpenHashMap(int initialCapacity, float loadFactor) {
        initialCapacity = Math.max(initialCapacity, 4);
        assert (initialCapacity > 0) : "Initial capacity must be between (0, 2147483647].";
        assert (loadFactor > 0.0f && loadFactor <= 1.0f) : "Load factor must be between (0, 1].";
        this.loadFactor = loadFactor;
        this.allocateBuffers(HashContainerUtils.roundCapacity(initialCapacity));
    }

    public ObjectObjectOpenHashMap(ObjectObjectAssociativeContainer<KType, VType> container) {
        this((int)((float)container.size() * 1.75f));
        this.putAll(container);
    }

    @Override
    public VType put(KType key, VType value) {
        assert (this.assigned < this.allocated.length);
        int mask = this.allocated.length - 1;
        int slot = Internals.rehash(key) & mask;
        while (this.allocated[slot]) {
            if (key == null ? this.keys[slot] == null : key.equals(this.keys[slot])) {
                VType oldValue = this.values[slot];
                this.values[slot] = value;
                return oldValue;
            }
            slot = slot + 1 & mask;
        }
        if (this.assigned == this.resizeAt) {
            this.expandAndPut(key, value, slot);
        } else {
            ++this.assigned;
            this.allocated[slot] = true;
            this.keys[slot] = key;
            this.values[slot] = value;
        }
        return null;
    }

    @Override
    public int putAll(ObjectObjectAssociativeContainer<? extends KType, ? extends VType> container) {
        int count = this.assigned;
        for (ObjectObjectCursor<KType, VType> objectObjectCursor : container) {
            this.put(objectObjectCursor.key, objectObjectCursor.value);
        }
        return this.assigned - count;
    }

    @Override
    public int putAll(Iterable<? extends ObjectObjectCursor<? extends KType, ? extends VType>> iterable) {
        int count = this.assigned;
        for (ObjectObjectCursor<KType, VType> objectObjectCursor : iterable) {
            this.put(objectObjectCursor.key, objectObjectCursor.value);
        }
        return this.assigned - count;
    }

    public boolean putIfAbsent(KType key, VType value) {
        if (!this.containsKey(key)) {
            this.put(key, value);
            return true;
        }
        return false;
    }

    private void expandAndPut(KType pendingKey, VType pendingValue, int freeSlot) {
        assert (this.assigned == this.resizeAt);
        assert (!this.allocated[freeSlot]);
        Object[] oldKeys = this.keys;
        Object[] oldValues = this.values;
        boolean[] oldAllocated = this.allocated;
        this.allocateBuffers(HashContainerUtils.nextCapacity(this.keys.length));
        this.lastSlot = -1;
        ++this.assigned;
        oldAllocated[freeSlot] = true;
        oldKeys[freeSlot] = pendingKey;
        oldValues[freeSlot] = pendingValue;
        KType[] keys = this.keys;
        VType[] values = this.values;
        boolean[] allocated = this.allocated;
        int mask = allocated.length - 1;
        int i = oldAllocated.length;
        while (--i >= 0) {
            if (!oldAllocated[i]) continue;
            Object k = oldKeys[i];
            Object v = oldValues[i];
            int slot = Internals.rehash(k) & mask;
            while (allocated[slot]) {
                slot = slot + 1 & mask;
            }
            allocated[slot] = true;
            keys[slot] = k;
            values[slot] = v;
        }
        Arrays.fill(oldKeys, null);
        Arrays.fill(oldValues, null);
    }

    private void allocateBuffers(int capacity) {
        Object[] keys = (Object[])Internals.newArray(capacity);
        Object[] values = (Object[])Internals.newArray(capacity);
        boolean[] allocated = new boolean[capacity];
        this.keys = keys;
        this.values = values;
        this.allocated = allocated;
        this.resizeAt = Math.max(2, (int)Math.ceil((float)capacity * this.loadFactor)) - 1;
    }

    @Override
    public VType remove(KType key) {
        int slot;
        int mask = this.allocated.length - 1;
        int wrappedAround = slot = Internals.rehash(key) & mask;
        while (this.allocated[slot]) {
            if (key == null ? this.keys[slot] == null : key.equals(this.keys[slot])) {
                --this.assigned;
                VType v = this.values[slot];
                this.shiftConflictingKeys(slot);
                return v;
            }
            if ((slot = slot + 1 & mask) != wrappedAround) continue;
            break;
        }
        return null;
    }

    protected void shiftConflictingKeys(int slotCurr) {
        int mask = this.allocated.length - 1;
        while (true) {
            int slotPrev = slotCurr;
            slotCurr = slotPrev + 1 & mask;
            while (this.allocated[slotCurr]) {
                int slotOther = Internals.rehash(this.keys[slotCurr]) & mask;
                if (slotPrev <= slotCurr ? slotPrev >= slotOther || slotOther > slotCurr : slotPrev >= slotOther && slotOther > slotCurr) break;
                slotCurr = slotCurr + 1 & mask;
            }
            if (!this.allocated[slotCurr]) break;
            this.keys[slotPrev] = this.keys[slotCurr];
            this.values[slotPrev] = this.values[slotCurr];
        }
        this.allocated[slotPrev] = false;
        this.keys[slotPrev] = null;
        this.values[slotPrev] = null;
    }

    @Override
    public int removeAll(ObjectContainer<? extends KType> container) {
        int before = this.assigned;
        for (ObjectCursor<KType> objectCursor : container) {
            this.remove(objectCursor.value);
        }
        return before - this.assigned;
    }

    @Override
    public int removeAll(ObjectPredicate<? super KType> predicate) {
        int before = this.assigned;
        KType[] keys = this.keys;
        boolean[] states = this.allocated;
        int i = 0;
        while (i < states.length) {
            if (states[i] && predicate.apply(keys[i])) {
                --this.assigned;
                this.shiftConflictingKeys(i);
                continue;
            }
            ++i;
        }
        return before - this.assigned;
    }

    @Override
    public VType get(KType key) {
        int slot;
        int mask = this.allocated.length - 1;
        int wrappedAround = slot = Internals.rehash(key) & mask;
        while (this.allocated[slot]) {
            if (key == null ? this.keys[slot] == null : key.equals(this.keys[slot])) {
                return this.values[slot];
            }
            if ((slot = slot + 1 & mask) != wrappedAround) continue;
            break;
        }
        return null;
    }

    public KType lkey() {
        return this.keys[this.lslot()];
    }

    public VType lget() {
        assert (this.lastSlot >= 0) : "Call containsKey() first.";
        assert (this.allocated[this.lastSlot]) : "Last call to exists did not have any associated value.";
        return this.values[this.lastSlot];
    }

    public VType lset(VType key) {
        assert (this.lastSlot >= 0) : "Call containsKey() first.";
        assert (this.allocated[this.lastSlot]) : "Last call to exists did not have any associated value.";
        VType previous = this.values[this.lastSlot];
        this.values[this.lastSlot] = key;
        return previous;
    }

    public int lslot() {
        assert (this.lastSlot >= 0) : "Call containsKey() first.";
        return this.lastSlot;
    }

    @Override
    public boolean containsKey(KType key) {
        int slot;
        int mask = this.allocated.length - 1;
        int wrappedAround = slot = Internals.rehash(key) & mask;
        while (this.allocated[slot]) {
            if (key == null ? this.keys[slot] == null : key.equals(this.keys[slot])) {
                this.lastSlot = slot;
                return true;
            }
            if ((slot = slot + 1 & mask) != wrappedAround) continue;
        }
        this.lastSlot = -1;
        return false;
    }

    @Override
    public void clear() {
        this.assigned = 0;
        Arrays.fill(this.allocated, false);
        Arrays.fill(this.keys, null);
        Arrays.fill(this.values, null);
    }

    @Override
    public int size() {
        return this.assigned;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public int hashCode() {
        int h = 0;
        for (ObjectObjectCursor<KType, VType> c : this) {
            h += Internals.rehash(c.key) + Internals.rehash(c.value);
        }
        return h;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null) {
            ObjectObjectMap other;
            if (obj == this) {
                return true;
            }
            if (obj instanceof ObjectObjectMap && (other = (ObjectObjectMap)obj).size() == this.size()) {
                for (ObjectObjectCursor<KType, VType> c : this) {
                    if (other.containsKey(c.key)) {
                        Object v = other.get(c.key);
                        if (c.value == null ? v == null : c.value.equals(v)) continue;
                    }
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public Iterator<ObjectObjectCursor<KType, VType>> iterator() {
        return new EntryIterator();
    }

    @Override
    public <T extends ObjectObjectProcedure<? super KType, ? super VType>> T forEach(T procedure) {
        KType[] keys = this.keys;
        VType[] values = this.values;
        boolean[] states = this.allocated;
        for (int i = 0; i < states.length; ++i) {
            if (!states[i]) continue;
            procedure.apply(keys[i], values[i]);
        }
        return procedure;
    }

    public KeysContainer keys() {
        return new KeysContainer();
    }

    @Override
    public ObjectContainer<VType> values() {
        return new ValuesContainer();
    }

    public ObjectObjectOpenHashMap<KType, VType> clone() {
        try {
            ObjectObjectOpenHashMap cloned = (ObjectObjectOpenHashMap)super.clone();
            cloned.keys = (Object[])this.keys.clone();
            cloned.values = (Object[])this.values.clone();
            cloned.allocated = (boolean[])this.allocated.clone();
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[");
        boolean first = true;
        for (ObjectObjectCursor<KType, VType> cursor : this) {
            if (!first) {
                buffer.append(", ");
            }
            buffer.append(cursor.key);
            buffer.append("=>");
            buffer.append(cursor.value);
            first = false;
        }
        buffer.append("]");
        return buffer.toString();
    }

    public static <KType, VType> ObjectObjectOpenHashMap<KType, VType> from(KType[] keys, VType[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        ObjectObjectOpenHashMap<KType, VType> map = new ObjectObjectOpenHashMap<KType, VType>();
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }

    public static <KType, VType> ObjectObjectOpenHashMap<KType, VType> from(ObjectObjectAssociativeContainer<KType, VType> container) {
        return new ObjectObjectOpenHashMap<KType, VType>(container);
    }

    public static <KType, VType> ObjectObjectOpenHashMap<KType, VType> newInstance() {
        return new ObjectObjectOpenHashMap<KType, VType>();
    }

    public static <KType, VType> ObjectObjectOpenHashMap<KType, VType> newInstance(int initialCapacity, float loadFactor) {
        return new ObjectObjectOpenHashMap<KType, VType>(initialCapacity, loadFactor);
    }

    private final class ValuesIterator
    extends AbstractIterator<ObjectCursor<VType>> {
        private final ObjectCursor<VType> cursor = new ObjectCursor();

        public ValuesIterator() {
            this.cursor.index = -1;
        }

        @Override
        protected ObjectCursor<VType> fetch() {
            int i;
            int max = ObjectObjectOpenHashMap.this.keys.length;
            for (i = this.cursor.index + 1; i < max && !ObjectObjectOpenHashMap.this.allocated[i]; ++i) {
            }
            if (i == max) {
                return (ObjectCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.value = ObjectObjectOpenHashMap.this.values[i];
            return this.cursor;
        }
    }

    private final class ValuesContainer
    extends AbstractObjectCollection<VType> {
        private ValuesContainer() {
        }

        @Override
        public int size() {
            return ObjectObjectOpenHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return ObjectObjectOpenHashMap.this.isEmpty();
        }

        @Override
        public boolean contains(VType value) {
            boolean[] allocated = ObjectObjectOpenHashMap.this.allocated;
            VType[] values = ObjectObjectOpenHashMap.this.values;
            for (int slot = 0; slot < allocated.length; ++slot) {
                if (!allocated[slot] || !(value == null ? values[slot] == null : value.equals(values[slot]))) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends ObjectProcedure<? super VType>> T forEach(T procedure) {
            boolean[] allocated = ObjectObjectOpenHashMap.this.allocated;
            VType[] values = ObjectObjectOpenHashMap.this.values;
            for (int i = 0; i < allocated.length; ++i) {
                if (!allocated[i]) continue;
                procedure.apply(values[i]);
            }
            return procedure;
        }

        @Override
        public <T extends ObjectPredicate<? super VType>> T forEach(T predicate) {
            boolean[] allocated = ObjectObjectOpenHashMap.this.allocated;
            VType[] values = ObjectObjectOpenHashMap.this.values;
            for (int i = 0; i < allocated.length && (!allocated[i] || predicate.apply(values[i])); ++i) {
            }
            return predicate;
        }

        @Override
        public Iterator<ObjectCursor<VType>> iterator() {
            return new ValuesIterator();
        }

        @Override
        public int removeAllOccurrences(VType e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int removeAll(ObjectPredicate<? super VType> predicate) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }
    }

    private final class KeysIterator
    extends AbstractIterator<ObjectCursor<KType>> {
        private final ObjectCursor<KType> cursor = new ObjectCursor();

        public KeysIterator() {
            this.cursor.index = -1;
        }

        @Override
        protected ObjectCursor<KType> fetch() {
            int i;
            int max = ObjectObjectOpenHashMap.this.keys.length;
            for (i = this.cursor.index + 1; i < max && !ObjectObjectOpenHashMap.this.allocated[i]; ++i) {
            }
            if (i == max) {
                return (ObjectCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.value = ObjectObjectOpenHashMap.this.keys[i];
            return this.cursor;
        }
    }

    public final class KeysContainer
    extends AbstractObjectCollection<KType>
    implements ObjectLookupContainer<KType> {
        private final ObjectObjectOpenHashMap<KType, VType> owner;

        public KeysContainer() {
            this.owner = ObjectObjectOpenHashMap.this;
        }

        @Override
        public boolean contains(KType e) {
            return ObjectObjectOpenHashMap.this.containsKey(e);
        }

        @Override
        public <T extends ObjectProcedure<? super KType>> T forEach(T procedure) {
            KType[] localKeys = this.owner.keys;
            boolean[] localStates = this.owner.allocated;
            for (int i = 0; i < localStates.length; ++i) {
                if (!localStates[i]) continue;
                procedure.apply(localKeys[i]);
            }
            return procedure;
        }

        @Override
        public <T extends ObjectPredicate<? super KType>> T forEach(T predicate) {
            KType[] localKeys = this.owner.keys;
            boolean[] localStates = this.owner.allocated;
            for (int i = 0; i < localStates.length && (!localStates[i] || predicate.apply(localKeys[i])); ++i) {
            }
            return predicate;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<ObjectCursor<KType>> iterator() {
            return new KeysIterator();
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public int removeAll(ObjectPredicate<? super KType> predicate) {
            return this.owner.removeAll(predicate);
        }

        @Override
        public int removeAllOccurrences(KType e) {
            boolean hasKey = this.owner.containsKey(e);
            int result = 0;
            if (hasKey) {
                this.owner.remove(e);
                result = 1;
            }
            return result;
        }
    }

    private final class EntryIterator
    extends AbstractIterator<ObjectObjectCursor<KType, VType>> {
        private final ObjectObjectCursor<KType, VType> cursor = new ObjectObjectCursor();

        public EntryIterator() {
            this.cursor.index = -1;
        }

        @Override
        protected ObjectObjectCursor<KType, VType> fetch() {
            int i;
            int max = ObjectObjectOpenHashMap.this.keys.length;
            for (i = this.cursor.index + 1; i < max && !ObjectObjectOpenHashMap.this.allocated[i]; ++i) {
            }
            if (i == max) {
                return (ObjectObjectCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.key = ObjectObjectOpenHashMap.this.keys[i];
            this.cursor.value = ObjectObjectOpenHashMap.this.values[i];
            return this.cursor;
        }
    }
}

