/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractDoubleCollection;
import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.ArraySizingStrategy;
import com.carrotsearch.hppc.BoundedProportionalArraySizingStrategy;
import com.carrotsearch.hppc.DoubleContainer;
import com.carrotsearch.hppc.DoubleDeque;
import com.carrotsearch.hppc.Internals;
import com.carrotsearch.hppc.cursors.DoubleCursor;
import com.carrotsearch.hppc.predicates.DoublePredicate;
import com.carrotsearch.hppc.procedures.DoubleProcedure;
import java.util.Arrays;
import java.util.Iterator;

public class DoubleArrayDeque
extends AbstractDoubleCollection
implements DoubleDeque,
Cloneable {
    public static final int DEFAULT_CAPACITY = 5;
    public double[] buffer;
    public int head;
    public int tail;
    protected final ArraySizingStrategy resizer;

    public DoubleArrayDeque() {
        this(5);
    }

    public DoubleArrayDeque(int initialCapacity) {
        this(initialCapacity, new BoundedProportionalArraySizingStrategy());
    }

    public DoubleArrayDeque(int initialCapacity, ArraySizingStrategy resizer) {
        assert (initialCapacity >= 0) : "initialCapacity must be >= 0: " + initialCapacity;
        assert (resizer != null);
        this.resizer = resizer;
        initialCapacity = resizer.round(initialCapacity);
        this.buffer = new double[initialCapacity];
    }

    public DoubleArrayDeque(DoubleContainer container) {
        this(container.size());
        this.addLast(container);
    }

    @Override
    public void addFirst(double e1) {
        int h = DoubleArrayDeque.oneLeft(this.head, this.buffer.length);
        if (h == this.tail) {
            this.ensureBufferSpace(1);
            h = DoubleArrayDeque.oneLeft(this.head, this.buffer.length);
        }
        this.head = h;
        this.buffer[this.head] = e1;
    }

    public void addFirst(double ... elements) {
        this.ensureBufferSpace(elements.length);
        for (int i = 0; i < elements.length; ++i) {
            this.addFirst(elements[i]);
        }
    }

    public int addFirst(DoubleContainer container) {
        int size = container.size();
        this.ensureBufferSpace(size);
        for (DoubleCursor cursor : container) {
            this.addFirst(cursor.value);
        }
        return size;
    }

    public int addFirst(Iterable<? extends DoubleCursor> iterable) {
        int size = 0;
        for (DoubleCursor doubleCursor : iterable) {
            this.addFirst(doubleCursor.value);
            ++size;
        }
        return size;
    }

    @Override
    public void addLast(double e1) {
        int t = DoubleArrayDeque.oneRight(this.tail, this.buffer.length);
        if (this.head == t) {
            this.ensureBufferSpace(1);
            t = DoubleArrayDeque.oneRight(this.tail, this.buffer.length);
        }
        this.buffer[this.tail] = e1;
        this.tail = t;
    }

    public void addLast(double ... elements) {
        this.ensureBufferSpace(1);
        for (int i = 0; i < elements.length; ++i) {
            this.addLast(elements[i]);
        }
    }

    public int addLast(DoubleContainer container) {
        int size = container.size();
        this.ensureBufferSpace(size);
        for (DoubleCursor cursor : container) {
            this.addLast(cursor.value);
        }
        return size;
    }

    public int addLast(Iterable<? extends DoubleCursor> iterable) {
        int size = 0;
        for (DoubleCursor doubleCursor : iterable) {
            this.addLast(doubleCursor.value);
            ++size;
        }
        return size;
    }

    @Override
    public double removeFirst() {
        assert (this.size() > 0) : "The deque is empty.";
        double result = this.buffer[this.head];
        this.buffer[this.head] = 0.0;
        this.head = DoubleArrayDeque.oneRight(this.head, this.buffer.length);
        return result;
    }

    @Override
    public double removeLast() {
        assert (this.size() > 0) : "The deque is empty.";
        this.tail = DoubleArrayDeque.oneLeft(this.tail, this.buffer.length);
        double result = this.buffer[this.tail];
        this.buffer[this.tail] = 0.0;
        return result;
    }

    @Override
    public double getFirst() {
        assert (this.size() > 0) : "The deque is empty.";
        return this.buffer[this.head];
    }

    @Override
    public double getLast() {
        assert (this.size() > 0) : "The deque is empty.";
        return this.buffer[DoubleArrayDeque.oneLeft(this.tail, this.buffer.length)];
    }

    @Override
    public int removeFirstOccurrence(double e1) {
        int index = this.bufferIndexOf(e1);
        if (index >= 0) {
            this.removeAtBufferIndex(index);
        }
        return index;
    }

    public int bufferIndexOf(double e1) {
        int last = this.tail;
        int bufLen = this.buffer.length;
        int i = this.head;
        while (i != last) {
            if (e1 == this.buffer[i]) {
                return i;
            }
            i = DoubleArrayDeque.oneRight(i, bufLen);
        }
        return -1;
    }

    @Override
    public int removeLastOccurrence(double e1) {
        int index = this.lastBufferIndexOf(e1);
        if (index >= 0) {
            this.removeAtBufferIndex(index);
        }
        return index;
    }

    public int lastBufferIndexOf(double e1) {
        int bufLen = this.buffer.length;
        int last = DoubleArrayDeque.oneLeft(this.head, bufLen);
        int i = DoubleArrayDeque.oneLeft(this.tail, bufLen);
        while (i != last) {
            if (e1 == this.buffer[i]) {
                return i;
            }
            i = DoubleArrayDeque.oneLeft(i, bufLen);
        }
        return -1;
    }

    @Override
    public int removeAllOccurrences(double e1) {
        int to;
        int removed = 0;
        int last = this.tail;
        int bufLen = this.buffer.length;
        int from = to = this.head;
        while (from != last) {
            if (e1 == this.buffer[from]) {
                this.buffer[from] = 0.0;
                ++removed;
            } else {
                if (to != from) {
                    this.buffer[to] = this.buffer[from];
                    this.buffer[from] = 0.0;
                }
                to = DoubleArrayDeque.oneRight(to, bufLen);
            }
            from = DoubleArrayDeque.oneRight(from, bufLen);
        }
        this.tail = to;
        return removed;
    }

    public void removeAtBufferIndex(int index) {
        int rightChunk;
        assert (this.head > this.tail ? index >= this.head || index < this.tail : index >= this.head && index < this.tail) : "Index out of range (head=" + this.head + ", tail=" + this.tail + ", index=" + index + ").";
        double[] b = this.buffer;
        int bufLen = b.length;
        int lastIndex = bufLen - 1;
        int head = this.head;
        int tail = this.tail;
        int leftChunk = Math.abs(index - head) % bufLen;
        if (leftChunk < (rightChunk = Math.abs(tail - index) % bufLen)) {
            if (index >= head) {
                System.arraycopy(b, head, b, head + 1, leftChunk);
            } else {
                System.arraycopy(b, 0, b, 1, index);
                b[0] = b[lastIndex];
                System.arraycopy(b, head, b, head + 1, lastIndex - head);
            }
            b[head] = 0.0;
            this.head = DoubleArrayDeque.oneRight(head, bufLen);
        } else {
            if (index < tail) {
                System.arraycopy(b, index + 1, b, index, rightChunk);
            } else {
                System.arraycopy(b, index + 1, b, index, lastIndex - index);
                b[lastIndex] = b[0];
                System.arraycopy(b, 1, b, 0, tail);
            }
            b[tail] = 0.0;
            this.tail = DoubleArrayDeque.oneLeft(tail, bufLen);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public int size() {
        if (this.head <= this.tail) {
            return this.tail - this.head;
        }
        return this.tail - this.head + this.buffer.length;
    }

    @Override
    public void clear() {
        if (this.head < this.tail) {
            Arrays.fill(this.buffer, this.head, this.tail, 0.0);
        } else {
            Arrays.fill(this.buffer, 0, this.tail, 0.0);
            Arrays.fill(this.buffer, this.head, this.buffer.length, 0.0);
        }
        this.tail = 0;
        this.head = 0;
    }

    public void release() {
        this.tail = 0;
        this.head = 0;
        this.buffer = new double[this.resizer.round(5)];
    }

    protected void ensureBufferSpace(int expectedAdditions) {
        int bufferLen = this.buffer == null ? 0 : this.buffer.length;
        int elementsCount = this.size();
        int requestedMinimum = 1 + elementsCount + expectedAdditions;
        if (requestedMinimum >= bufferLen) {
            int newSize = this.resizer.grow(bufferLen, elementsCount, expectedAdditions + 1);
            assert (newSize >= requestedMinimum) : "Resizer failed to return sensible new size: " + newSize + " <= " + (elementsCount + expectedAdditions);
            double[] newBuffer = new double[newSize];
            if (bufferLen > 0) {
                this.toArray(newBuffer);
                this.tail = elementsCount;
                this.head = 0;
            }
            this.buffer = newBuffer;
        }
    }

    @Override
    public double[] toArray() {
        int size = this.size();
        return this.toArray(new double[size]);
    }

    public double[] toArray(double[] target) {
        assert (target.length >= this.size()) : "Target array must be >= " + this.size();
        if (this.head < this.tail) {
            System.arraycopy(this.buffer, this.head, target, 0, this.size());
        } else if (this.head > this.tail) {
            int rightCount = this.buffer.length - this.head;
            System.arraycopy(this.buffer, this.head, target, 0, rightCount);
            System.arraycopy(this.buffer, 0, target, rightCount, this.tail);
        }
        return target;
    }

    public DoubleArrayDeque clone() {
        try {
            DoubleArrayDeque cloned = (DoubleArrayDeque)super.clone();
            cloned.buffer = (double[])this.buffer.clone();
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    protected static int oneLeft(int index, int modulus) {
        if (index >= 1) {
            return index - 1;
        }
        return modulus - 1;
    }

    protected static int oneRight(int index, int modulus) {
        if (index + 1 == modulus) {
            return 0;
        }
        return index + 1;
    }

    @Override
    public Iterator<DoubleCursor> iterator() {
        return new ValueIterator();
    }

    @Override
    public Iterator<DoubleCursor> descendingIterator() {
        return new DescendingValueIterator();
    }

    @Override
    public <T extends DoubleProcedure> T forEach(T procedure) {
        this.forEach(procedure, this.head, this.tail);
        return procedure;
    }

    private void forEach(DoubleProcedure procedure, int fromIndex, int toIndex) {
        double[] buffer = this.buffer;
        int i = fromIndex;
        while (i != toIndex) {
            procedure.apply(buffer[i]);
            i = DoubleArrayDeque.oneRight(i, buffer.length);
        }
    }

    @Override
    public <T extends DoublePredicate> T forEach(T predicate) {
        int fromIndex = this.head;
        int toIndex = this.tail;
        double[] buffer = this.buffer;
        int i = fromIndex;
        while (i != toIndex && predicate.apply(buffer[i])) {
            i = DoubleArrayDeque.oneRight(i, buffer.length);
        }
        return predicate;
    }

    @Override
    public <T extends DoubleProcedure> T descendingForEach(T procedure) {
        this.descendingForEach(procedure, this.head, this.tail);
        return procedure;
    }

    private void descendingForEach(DoubleProcedure procedure, int fromIndex, int toIndex) {
        if (fromIndex == toIndex) {
            return;
        }
        double[] buffer = this.buffer;
        int i = toIndex;
        do {
            i = DoubleArrayDeque.oneLeft(i, buffer.length);
            procedure.apply(buffer[i]);
        } while (i != fromIndex);
    }

    @Override
    public <T extends DoublePredicate> T descendingForEach(T predicate) {
        this.descendingForEach(predicate, this.head, this.tail);
        return predicate;
    }

    private void descendingForEach(DoublePredicate predicate, int fromIndex, int toIndex) {
        if (fromIndex == toIndex) {
            return;
        }
        double[] buffer = this.buffer;
        int i = toIndex;
        while (predicate.apply(buffer[i = DoubleArrayDeque.oneLeft(i, buffer.length)]) && i != fromIndex) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int removeAll(DoublePredicate predicate) {
        int to;
        int removed = 0;
        int last = this.tail;
        int bufLen = this.buffer.length;
        int from = to = this.head;
        try {
            from = to = this.head;
            while (from != last) {
                if (predicate.apply(this.buffer[from])) {
                    this.buffer[from] = 0.0;
                    ++removed;
                } else {
                    if (to != from) {
                        this.buffer[to] = this.buffer[from];
                        this.buffer[from] = 0.0;
                    }
                    to = DoubleArrayDeque.oneRight(to, bufLen);
                }
                from = DoubleArrayDeque.oneRight(from, bufLen);
            }
        }
        finally {
            while (from != last) {
                if (to != from) {
                    this.buffer[to] = this.buffer[from];
                    this.buffer[from] = 0.0;
                }
                to = DoubleArrayDeque.oneRight(to, bufLen);
                from = DoubleArrayDeque.oneRight(from, bufLen);
            }
            this.tail = to;
        }
        return removed;
    }

    @Override
    public boolean contains(double e) {
        int fromIndex = this.head;
        int toIndex = this.tail;
        double[] buffer = this.buffer;
        int i = fromIndex;
        while (i != toIndex) {
            if (e == buffer[i]) {
                return true;
            }
            i = DoubleArrayDeque.oneRight(i, buffer.length);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int h = 1;
        int fromIndex = this.head;
        int toIndex = this.tail;
        double[] buffer = this.buffer;
        int i = fromIndex;
        while (i != toIndex) {
            h = 31 * h + Internals.rehash(this.buffer[i]);
            i = DoubleArrayDeque.oneRight(i, buffer.length);
        }
        return h;
    }

    @Override
    public boolean equals(Object obj) {
        DoubleDeque other;
        if (obj != null && obj instanceof DoubleDeque && (other = (DoubleDeque)obj).size() == this.size()) {
            int fromIndex = this.head;
            double[] buffer = this.buffer;
            int i = fromIndex;
            for (DoubleCursor c : other) {
                if (c.value != buffer[i]) {
                    return false;
                }
                i = DoubleArrayDeque.oneRight(i, buffer.length);
            }
            return true;
        }
        return false;
    }

    public static DoubleArrayDeque newInstance() {
        return new DoubleArrayDeque();
    }

    public static DoubleArrayDeque newInstanceWithCapacity(int initialCapacity) {
        return new DoubleArrayDeque(initialCapacity);
    }

    public static DoubleArrayDeque from(double ... elements) {
        DoubleArrayDeque coll = new DoubleArrayDeque(elements.length);
        coll.addLast(elements);
        return coll;
    }

    public static DoubleArrayDeque from(DoubleArrayDeque container) {
        return new DoubleArrayDeque(container);
    }

    private final class DescendingValueIterator
    extends AbstractIterator<DoubleCursor> {
        private final DoubleCursor cursor = new DoubleCursor();
        private int remaining;

        public DescendingValueIterator() {
            this.cursor.index = DoubleArrayDeque.this.tail;
            this.remaining = DoubleArrayDeque.this.size();
        }

        @Override
        protected DoubleCursor fetch() {
            if (this.remaining == 0) {
                return (DoubleCursor)this.done();
            }
            --this.remaining;
            this.cursor.index = DoubleArrayDeque.oneLeft(this.cursor.index, DoubleArrayDeque.this.buffer.length);
            this.cursor.value = DoubleArrayDeque.this.buffer[this.cursor.index];
            return this.cursor;
        }
    }

    private final class ValueIterator
    extends AbstractIterator<DoubleCursor> {
        private final DoubleCursor cursor = new DoubleCursor();
        private int remaining;

        public ValueIterator() {
            this.cursor.index = DoubleArrayDeque.oneLeft(DoubleArrayDeque.this.head, DoubleArrayDeque.this.buffer.length);
            this.remaining = DoubleArrayDeque.this.size();
        }

        @Override
        protected DoubleCursor fetch() {
            if (this.remaining == 0) {
                return (DoubleCursor)this.done();
            }
            --this.remaining;
            this.cursor.index = DoubleArrayDeque.oneRight(this.cursor.index, DoubleArrayDeque.this.buffer.length);
            this.cursor.value = DoubleArrayDeque.this.buffer[this.cursor.index];
            return this.cursor;
        }
    }
}

