/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractCharCollection;
import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.ArraySizingStrategy;
import com.carrotsearch.hppc.BoundedProportionalArraySizingStrategy;
import com.carrotsearch.hppc.CharContainer;
import com.carrotsearch.hppc.CharDeque;
import com.carrotsearch.hppc.Internals;
import com.carrotsearch.hppc.cursors.CharCursor;
import com.carrotsearch.hppc.predicates.CharPredicate;
import com.carrotsearch.hppc.procedures.CharProcedure;
import java.util.Arrays;
import java.util.Iterator;

public class CharArrayDeque
extends AbstractCharCollection
implements CharDeque,
Cloneable {
    public static final int DEFAULT_CAPACITY = 5;
    public char[] buffer;
    public int head;
    public int tail;
    protected final ArraySizingStrategy resizer;

    public CharArrayDeque() {
        this(5);
    }

    public CharArrayDeque(int initialCapacity) {
        this(initialCapacity, new BoundedProportionalArraySizingStrategy());
    }

    public CharArrayDeque(int initialCapacity, ArraySizingStrategy resizer) {
        assert (initialCapacity >= 0) : "initialCapacity must be >= 0: " + initialCapacity;
        assert (resizer != null);
        this.resizer = resizer;
        initialCapacity = resizer.round(initialCapacity);
        this.buffer = new char[initialCapacity];
    }

    public CharArrayDeque(CharContainer container) {
        this(container.size());
        this.addLast(container);
    }

    @Override
    public void addFirst(char e1) {
        int h = CharArrayDeque.oneLeft(this.head, this.buffer.length);
        if (h == this.tail) {
            this.ensureBufferSpace(1);
            h = CharArrayDeque.oneLeft(this.head, this.buffer.length);
        }
        this.head = h;
        this.buffer[this.head] = e1;
    }

    public void addFirst(char ... elements) {
        this.ensureBufferSpace(elements.length);
        for (int i = 0; i < elements.length; ++i) {
            this.addFirst(elements[i]);
        }
    }

    public int addFirst(CharContainer container) {
        int size = container.size();
        this.ensureBufferSpace(size);
        for (CharCursor cursor : container) {
            this.addFirst(cursor.value);
        }
        return size;
    }

    public int addFirst(Iterable<? extends CharCursor> iterable) {
        int size = 0;
        for (CharCursor charCursor : iterable) {
            this.addFirst(charCursor.value);
            ++size;
        }
        return size;
    }

    @Override
    public void addLast(char e1) {
        int t = CharArrayDeque.oneRight(this.tail, this.buffer.length);
        if (this.head == t) {
            this.ensureBufferSpace(1);
            t = CharArrayDeque.oneRight(this.tail, this.buffer.length);
        }
        this.buffer[this.tail] = e1;
        this.tail = t;
    }

    public void addLast(char ... elements) {
        this.ensureBufferSpace(1);
        for (int i = 0; i < elements.length; ++i) {
            this.addLast(elements[i]);
        }
    }

    public int addLast(CharContainer container) {
        int size = container.size();
        this.ensureBufferSpace(size);
        for (CharCursor cursor : container) {
            this.addLast(cursor.value);
        }
        return size;
    }

    public int addLast(Iterable<? extends CharCursor> iterable) {
        int size = 0;
        for (CharCursor charCursor : iterable) {
            this.addLast(charCursor.value);
            ++size;
        }
        return size;
    }

    @Override
    public char removeFirst() {
        assert (this.size() > 0) : "The deque is empty.";
        char result = this.buffer[this.head];
        this.buffer[this.head] = '\u0000';
        this.head = CharArrayDeque.oneRight(this.head, this.buffer.length);
        return result;
    }

    @Override
    public char removeLast() {
        assert (this.size() > 0) : "The deque is empty.";
        this.tail = CharArrayDeque.oneLeft(this.tail, this.buffer.length);
        char result = this.buffer[this.tail];
        this.buffer[this.tail] = '\u0000';
        return result;
    }

    @Override
    public char getFirst() {
        assert (this.size() > 0) : "The deque is empty.";
        return this.buffer[this.head];
    }

    @Override
    public char getLast() {
        assert (this.size() > 0) : "The deque is empty.";
        return this.buffer[CharArrayDeque.oneLeft(this.tail, this.buffer.length)];
    }

    @Override
    public int removeFirstOccurrence(char e1) {
        int index = this.bufferIndexOf(e1);
        if (index >= 0) {
            this.removeAtBufferIndex(index);
        }
        return index;
    }

    public int bufferIndexOf(char e1) {
        int last = this.tail;
        int bufLen = this.buffer.length;
        int i = this.head;
        while (i != last) {
            if (e1 == this.buffer[i]) {
                return i;
            }
            i = CharArrayDeque.oneRight(i, bufLen);
        }
        return -1;
    }

    @Override
    public int removeLastOccurrence(char e1) {
        int index = this.lastBufferIndexOf(e1);
        if (index >= 0) {
            this.removeAtBufferIndex(index);
        }
        return index;
    }

    public int lastBufferIndexOf(char e1) {
        int bufLen = this.buffer.length;
        int last = CharArrayDeque.oneLeft(this.head, bufLen);
        int i = CharArrayDeque.oneLeft(this.tail, bufLen);
        while (i != last) {
            if (e1 == this.buffer[i]) {
                return i;
            }
            i = CharArrayDeque.oneLeft(i, bufLen);
        }
        return -1;
    }

    @Override
    public int removeAllOccurrences(char e1) {
        int to;
        int removed = 0;
        int last = this.tail;
        int bufLen = this.buffer.length;
        int from = to = this.head;
        while (from != last) {
            if (e1 == this.buffer[from]) {
                this.buffer[from] = '\u0000';
                ++removed;
            } else {
                if (to != from) {
                    this.buffer[to] = this.buffer[from];
                    this.buffer[from] = '\u0000';
                }
                to = CharArrayDeque.oneRight(to, bufLen);
            }
            from = CharArrayDeque.oneRight(from, bufLen);
        }
        this.tail = to;
        return removed;
    }

    public void removeAtBufferIndex(int index) {
        int rightChunk;
        assert (this.head > this.tail ? index >= this.head || index < this.tail : index >= this.head && index < this.tail) : "Index out of range (head=" + this.head + ", tail=" + this.tail + ", index=" + index + ").";
        char[] b = this.buffer;
        int bufLen = b.length;
        int lastIndex = bufLen - 1;
        int head = this.head;
        int tail = this.tail;
        int leftChunk = Math.abs(index - head) % bufLen;
        if (leftChunk < (rightChunk = Math.abs(tail - index) % bufLen)) {
            if (index >= head) {
                System.arraycopy(b, head, b, head + 1, leftChunk);
            } else {
                System.arraycopy(b, 0, b, 1, index);
                b[0] = b[lastIndex];
                System.arraycopy(b, head, b, head + 1, lastIndex - head);
            }
            b[head] = '\u0000';
            this.head = CharArrayDeque.oneRight(head, bufLen);
        } else {
            if (index < tail) {
                System.arraycopy(b, index + 1, b, index, rightChunk);
            } else {
                System.arraycopy(b, index + 1, b, index, lastIndex - index);
                b[lastIndex] = b[0];
                System.arraycopy(b, 1, b, 0, tail);
            }
            b[tail] = '\u0000';
            this.tail = CharArrayDeque.oneLeft(tail, bufLen);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public int size() {
        if (this.head <= this.tail) {
            return this.tail - this.head;
        }
        return this.tail - this.head + this.buffer.length;
    }

    @Override
    public void clear() {
        if (this.head < this.tail) {
            Arrays.fill(this.buffer, this.head, this.tail, '\u0000');
        } else {
            Arrays.fill(this.buffer, 0, this.tail, '\u0000');
            Arrays.fill(this.buffer, this.head, this.buffer.length, '\u0000');
        }
        this.tail = 0;
        this.head = 0;
    }

    public void release() {
        this.tail = 0;
        this.head = 0;
        this.buffer = new char[this.resizer.round(5)];
    }

    protected void ensureBufferSpace(int expectedAdditions) {
        int bufferLen = this.buffer == null ? 0 : this.buffer.length;
        int elementsCount = this.size();
        int requestedMinimum = 1 + elementsCount + expectedAdditions;
        if (requestedMinimum >= bufferLen) {
            int newSize = this.resizer.grow(bufferLen, elementsCount, expectedAdditions + 1);
            assert (newSize >= requestedMinimum) : "Resizer failed to return sensible new size: " + newSize + " <= " + (elementsCount + expectedAdditions);
            char[] newBuffer = new char[newSize];
            if (bufferLen > 0) {
                this.toArray(newBuffer);
                this.tail = elementsCount;
                this.head = 0;
            }
            this.buffer = newBuffer;
        }
    }

    @Override
    public char[] toArray() {
        int size = this.size();
        return this.toArray(new char[size]);
    }

    public char[] toArray(char[] target) {
        assert (target.length >= this.size()) : "Target array must be >= " + this.size();
        if (this.head < this.tail) {
            System.arraycopy(this.buffer, this.head, target, 0, this.size());
        } else if (this.head > this.tail) {
            int rightCount = this.buffer.length - this.head;
            System.arraycopy(this.buffer, this.head, target, 0, rightCount);
            System.arraycopy(this.buffer, 0, target, rightCount, this.tail);
        }
        return target;
    }

    public CharArrayDeque clone() {
        try {
            CharArrayDeque cloned = (CharArrayDeque)super.clone();
            cloned.buffer = (char[])this.buffer.clone();
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    protected static int oneLeft(int index, int modulus) {
        if (index >= 1) {
            return index - 1;
        }
        return modulus - 1;
    }

    protected static int oneRight(int index, int modulus) {
        if (index + 1 == modulus) {
            return 0;
        }
        return index + 1;
    }

    @Override
    public Iterator<CharCursor> iterator() {
        return new ValueIterator();
    }

    @Override
    public Iterator<CharCursor> descendingIterator() {
        return new DescendingValueIterator();
    }

    @Override
    public <T extends CharProcedure> T forEach(T procedure) {
        this.forEach(procedure, this.head, this.tail);
        return procedure;
    }

    private void forEach(CharProcedure procedure, int fromIndex, int toIndex) {
        char[] buffer = this.buffer;
        int i = fromIndex;
        while (i != toIndex) {
            procedure.apply(buffer[i]);
            i = CharArrayDeque.oneRight(i, buffer.length);
        }
    }

    @Override
    public <T extends CharPredicate> T forEach(T predicate) {
        int fromIndex = this.head;
        int toIndex = this.tail;
        char[] buffer = this.buffer;
        int i = fromIndex;
        while (i != toIndex && predicate.apply(buffer[i])) {
            i = CharArrayDeque.oneRight(i, buffer.length);
        }
        return predicate;
    }

    @Override
    public <T extends CharProcedure> T descendingForEach(T procedure) {
        this.descendingForEach(procedure, this.head, this.tail);
        return procedure;
    }

    private void descendingForEach(CharProcedure procedure, int fromIndex, int toIndex) {
        if (fromIndex == toIndex) {
            return;
        }
        char[] buffer = this.buffer;
        int i = toIndex;
        do {
            i = CharArrayDeque.oneLeft(i, buffer.length);
            procedure.apply(buffer[i]);
        } while (i != fromIndex);
    }

    @Override
    public <T extends CharPredicate> T descendingForEach(T predicate) {
        this.descendingForEach(predicate, this.head, this.tail);
        return predicate;
    }

    private void descendingForEach(CharPredicate predicate, int fromIndex, int toIndex) {
        if (fromIndex == toIndex) {
            return;
        }
        char[] buffer = this.buffer;
        int i = toIndex;
        while (predicate.apply(buffer[i = CharArrayDeque.oneLeft(i, buffer.length)]) && i != fromIndex) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int removeAll(CharPredicate predicate) {
        int to;
        int removed = 0;
        int last = this.tail;
        int bufLen = this.buffer.length;
        int from = to = this.head;
        try {
            from = to = this.head;
            while (from != last) {
                if (predicate.apply(this.buffer[from])) {
                    this.buffer[from] = '\u0000';
                    ++removed;
                } else {
                    if (to != from) {
                        this.buffer[to] = this.buffer[from];
                        this.buffer[from] = '\u0000';
                    }
                    to = CharArrayDeque.oneRight(to, bufLen);
                }
                from = CharArrayDeque.oneRight(from, bufLen);
            }
        }
        finally {
            while (from != last) {
                if (to != from) {
                    this.buffer[to] = this.buffer[from];
                    this.buffer[from] = '\u0000';
                }
                to = CharArrayDeque.oneRight(to, bufLen);
                from = CharArrayDeque.oneRight(from, bufLen);
            }
            this.tail = to;
        }
        return removed;
    }

    @Override
    public boolean contains(char e) {
        int fromIndex = this.head;
        int toIndex = this.tail;
        char[] buffer = this.buffer;
        int i = fromIndex;
        while (i != toIndex) {
            if (e == buffer[i]) {
                return true;
            }
            i = CharArrayDeque.oneRight(i, buffer.length);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int h = 1;
        int fromIndex = this.head;
        int toIndex = this.tail;
        char[] buffer = this.buffer;
        int i = fromIndex;
        while (i != toIndex) {
            h = 31 * h + Internals.rehash(this.buffer[i]);
            i = CharArrayDeque.oneRight(i, buffer.length);
        }
        return h;
    }

    @Override
    public boolean equals(Object obj) {
        CharDeque other;
        if (obj != null && obj instanceof CharDeque && (other = (CharDeque)obj).size() == this.size()) {
            int fromIndex = this.head;
            char[] buffer = this.buffer;
            int i = fromIndex;
            for (CharCursor c : other) {
                if (c.value != buffer[i]) {
                    return false;
                }
                i = CharArrayDeque.oneRight(i, buffer.length);
            }
            return true;
        }
        return false;
    }

    public static CharArrayDeque newInstance() {
        return new CharArrayDeque();
    }

    public static CharArrayDeque newInstanceWithCapacity(int initialCapacity) {
        return new CharArrayDeque(initialCapacity);
    }

    public static CharArrayDeque from(char ... elements) {
        CharArrayDeque coll = new CharArrayDeque(elements.length);
        coll.addLast(elements);
        return coll;
    }

    public static CharArrayDeque from(CharArrayDeque container) {
        return new CharArrayDeque(container);
    }

    private final class DescendingValueIterator
    extends AbstractIterator<CharCursor> {
        private final CharCursor cursor = new CharCursor();
        private int remaining;

        public DescendingValueIterator() {
            this.cursor.index = CharArrayDeque.this.tail;
            this.remaining = CharArrayDeque.this.size();
        }

        @Override
        protected CharCursor fetch() {
            if (this.remaining == 0) {
                return (CharCursor)this.done();
            }
            --this.remaining;
            this.cursor.index = CharArrayDeque.oneLeft(this.cursor.index, CharArrayDeque.this.buffer.length);
            this.cursor.value = CharArrayDeque.this.buffer[this.cursor.index];
            return this.cursor;
        }
    }

    private final class ValueIterator
    extends AbstractIterator<CharCursor> {
        private final CharCursor cursor = new CharCursor();
        private int remaining;

        public ValueIterator() {
            this.cursor.index = CharArrayDeque.oneLeft(CharArrayDeque.this.head, CharArrayDeque.this.buffer.length);
            this.remaining = CharArrayDeque.this.size();
        }

        @Override
        protected CharCursor fetch() {
            if (this.remaining == 0) {
                return (CharCursor)this.done();
            }
            --this.remaining;
            this.cursor.index = CharArrayDeque.oneRight(this.cursor.index, CharArrayDeque.this.buffer.length);
            this.cursor.value = CharArrayDeque.this.buffer[this.cursor.index];
            return this.cursor;
        }
    }
}

