/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractFloatCollection;
import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.AbstractShortCollection;
import com.carrotsearch.hppc.FloatContainer;
import com.carrotsearch.hppc.HashContainerUtils;
import com.carrotsearch.hppc.Internals;
import com.carrotsearch.hppc.ShortContainer;
import com.carrotsearch.hppc.ShortFloatAssociativeContainer;
import com.carrotsearch.hppc.ShortFloatMap;
import com.carrotsearch.hppc.ShortLookupContainer;
import com.carrotsearch.hppc.cursors.FloatCursor;
import com.carrotsearch.hppc.cursors.ShortCursor;
import com.carrotsearch.hppc.cursors.ShortFloatCursor;
import com.carrotsearch.hppc.predicates.FloatPredicate;
import com.carrotsearch.hppc.predicates.ShortPredicate;
import com.carrotsearch.hppc.procedures.FloatProcedure;
import com.carrotsearch.hppc.procedures.ShortFloatProcedure;
import com.carrotsearch.hppc.procedures.ShortProcedure;
import java.util.Arrays;
import java.util.Iterator;

public class ShortFloatOpenHashMap
implements ShortFloatMap,
Cloneable {
    public static final int MIN_CAPACITY = 4;
    public static final int DEFAULT_CAPACITY = 16;
    public static final float DEFAULT_LOAD_FACTOR = 0.75f;
    public short[] keys;
    public float[] values;
    public boolean[] allocated;
    public int assigned;
    public final float loadFactor;
    private int resizeAt;
    private int lastSlot;

    public ShortFloatOpenHashMap() {
        this(16);
    }

    public ShortFloatOpenHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public ShortFloatOpenHashMap(int initialCapacity, float loadFactor) {
        initialCapacity = Math.max(initialCapacity, 4);
        assert (initialCapacity > 0) : "Initial capacity must be between (0, 2147483647].";
        assert (loadFactor > 0.0f && loadFactor <= 1.0f) : "Load factor must be between (0, 1].";
        this.loadFactor = loadFactor;
        this.allocateBuffers(HashContainerUtils.roundCapacity(initialCapacity));
    }

    public ShortFloatOpenHashMap(ShortFloatAssociativeContainer container) {
        this((int)((float)container.size() * 1.75f));
        this.putAll(container);
    }

    @Override
    public float put(short key, float value) {
        assert (this.assigned < this.allocated.length);
        int mask = this.allocated.length - 1;
        int slot = Internals.rehash(key) & mask;
        while (this.allocated[slot]) {
            if (key == this.keys[slot]) {
                float oldValue = this.values[slot];
                this.values[slot] = value;
                return oldValue;
            }
            slot = slot + 1 & mask;
        }
        if (this.assigned == this.resizeAt) {
            this.expandAndPut(key, value, slot);
        } else {
            ++this.assigned;
            this.allocated[slot] = true;
            this.keys[slot] = key;
            this.values[slot] = value;
        }
        return 0.0f;
    }

    @Override
    public final int putAll(ShortFloatAssociativeContainer container) {
        int count = this.assigned;
        for (ShortFloatCursor c : container) {
            this.put(c.key, c.value);
        }
        return this.assigned - count;
    }

    @Override
    public final int putAll(Iterable<? extends ShortFloatCursor> iterable) {
        int count = this.assigned;
        for (ShortFloatCursor shortFloatCursor : iterable) {
            this.put(shortFloatCursor.key, shortFloatCursor.value);
        }
        return this.assigned - count;
    }

    public final boolean putIfAbsent(short key, float value) {
        if (!this.containsKey(key)) {
            this.put(key, value);
            return true;
        }
        return false;
    }

    public final float putOrAdd(short key, float putValue, float additionValue) {
        assert (this.assigned < this.allocated.length);
        int mask = this.allocated.length - 1;
        int slot = Internals.rehash(key) & mask;
        while (this.allocated[slot]) {
            if (key == this.keys[slot]) {
                this.values[slot] = this.values[slot] + additionValue;
                return this.values[slot];
            }
            slot = slot + 1 & mask;
        }
        if (this.assigned == this.resizeAt) {
            this.expandAndPut(key, putValue, slot);
        } else {
            ++this.assigned;
            this.allocated[slot] = true;
            this.keys[slot] = key;
            this.values[slot] = putValue;
        }
        return putValue;
    }

    private void expandAndPut(short pendingKey, float pendingValue, int freeSlot) {
        assert (this.assigned == this.resizeAt);
        assert (!this.allocated[freeSlot]);
        short[] oldKeys = this.keys;
        float[] oldValues = this.values;
        boolean[] oldAllocated = this.allocated;
        this.allocateBuffers(HashContainerUtils.nextCapacity(this.keys.length));
        this.lastSlot = -1;
        ++this.assigned;
        oldAllocated[freeSlot] = true;
        oldKeys[freeSlot] = pendingKey;
        oldValues[freeSlot] = pendingValue;
        short[] keys = this.keys;
        float[] values = this.values;
        boolean[] allocated = this.allocated;
        int mask = allocated.length - 1;
        int i = oldAllocated.length;
        while (--i >= 0) {
            if (!oldAllocated[i]) continue;
            short k = oldKeys[i];
            float v = oldValues[i];
            int slot = Internals.rehash(k) & mask;
            while (allocated[slot]) {
                slot = slot + 1 & mask;
            }
            allocated[slot] = true;
            keys[slot] = k;
            values[slot] = v;
        }
    }

    private void allocateBuffers(int capacity) {
        short[] keys = new short[capacity];
        float[] values = new float[capacity];
        boolean[] allocated = new boolean[capacity];
        this.keys = keys;
        this.values = values;
        this.allocated = allocated;
        this.resizeAt = Math.max(2, (int)Math.ceil((float)capacity * this.loadFactor)) - 1;
    }

    @Override
    public float remove(short key) {
        int slot;
        int mask = this.allocated.length - 1;
        int wrappedAround = slot = Internals.rehash(key) & mask;
        while (this.allocated[slot]) {
            if (key == this.keys[slot]) {
                --this.assigned;
                float v = this.values[slot];
                this.shiftConflictingKeys(slot);
                return v;
            }
            if ((slot = slot + 1 & mask) != wrappedAround) continue;
            break;
        }
        return 0.0f;
    }

    protected final void shiftConflictingKeys(int slotCurr) {
        int mask = this.allocated.length - 1;
        while (true) {
            int slotPrev = slotCurr;
            slotCurr = slotPrev + 1 & mask;
            while (this.allocated[slotCurr]) {
                int slotOther = Internals.rehash(this.keys[slotCurr]) & mask;
                if (slotPrev <= slotCurr ? slotPrev >= slotOther || slotOther > slotCurr : slotPrev >= slotOther && slotOther > slotCurr) break;
                slotCurr = slotCurr + 1 & mask;
            }
            if (!this.allocated[slotCurr]) break;
            this.keys[slotPrev] = this.keys[slotCurr];
            this.values[slotPrev] = this.values[slotCurr];
        }
        this.allocated[slotPrev] = false;
    }

    @Override
    public final int removeAll(ShortContainer container) {
        int before = this.assigned;
        for (ShortCursor cursor : container) {
            this.remove(cursor.value);
        }
        return before - this.assigned;
    }

    @Override
    public final int removeAll(ShortPredicate predicate) {
        int before = this.assigned;
        short[] keys = this.keys;
        boolean[] states = this.allocated;
        int i = 0;
        while (i < states.length) {
            if (states[i] && predicate.apply(keys[i])) {
                --this.assigned;
                this.shiftConflictingKeys(i);
                continue;
            }
            ++i;
        }
        return before - this.assigned;
    }

    @Override
    public float get(short key) {
        int slot;
        int mask = this.allocated.length - 1;
        int wrappedAround = slot = Internals.rehash(key) & mask;
        while (this.allocated[slot]) {
            if (key == this.keys[slot]) {
                return this.values[slot];
            }
            if ((slot = slot + 1 & mask) != wrappedAround) continue;
            break;
        }
        return 0.0f;
    }

    public float lget() {
        assert (this.lastSlot >= 0) : "Call containsKey() first.";
        assert (this.allocated[this.lastSlot]) : "Last call to exists did not have any associated value.";
        return this.values[this.lastSlot];
    }

    public float lset(float key) {
        assert (this.lastSlot >= 0) : "Call containsKey() first.";
        assert (this.allocated[this.lastSlot]) : "Last call to exists did not have any associated value.";
        float previous = this.values[this.lastSlot];
        this.values[this.lastSlot] = key;
        return previous;
    }

    @Override
    public boolean containsKey(short key) {
        int slot;
        int mask = this.allocated.length - 1;
        int wrappedAround = slot = Internals.rehash(key) & mask;
        while (this.allocated[slot]) {
            if (key == this.keys[slot]) {
                this.lastSlot = slot;
                return true;
            }
            if ((slot = slot + 1 & mask) != wrappedAround) continue;
        }
        this.lastSlot = -1;
        return false;
    }

    @Override
    public void clear() {
        this.assigned = 0;
        Arrays.fill(this.allocated, false);
    }

    @Override
    public int size() {
        return this.assigned;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public int hashCode() {
        int h = 0;
        for (ShortFloatCursor c : this) {
            h += Internals.rehash(c.key) + Internals.rehash(c.value);
        }
        return h;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null) {
            ShortFloatMap other;
            if (obj == this) {
                return true;
            }
            if (obj instanceof ShortFloatMap && (other = (ShortFloatMap)obj).size() == this.size()) {
                for (ShortFloatCursor c : this) {
                    float v;
                    if (other.containsKey(c.key) && c.value == (v = other.get(c.key))) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public Iterator<ShortFloatCursor> iterator() {
        return new EntryIterator();
    }

    @Override
    public <T extends ShortFloatProcedure> T forEach(T procedure) {
        short[] keys = this.keys;
        float[] values = this.values;
        boolean[] states = this.allocated;
        for (int i = 0; i < states.length; ++i) {
            if (!states[i]) continue;
            procedure.apply(keys[i], values[i]);
        }
        return procedure;
    }

    @Override
    public KeysContainer keys() {
        return new KeysContainer();
    }

    @Override
    public FloatContainer values() {
        return new ValuesContainer();
    }

    public ShortFloatOpenHashMap clone() {
        try {
            ShortFloatOpenHashMap cloned = (ShortFloatOpenHashMap)super.clone();
            cloned.keys = (short[])this.keys.clone();
            cloned.values = (float[])this.values.clone();
            cloned.allocated = (boolean[])this.allocated.clone();
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[");
        boolean first = true;
        for (ShortFloatCursor cursor : this) {
            if (!first) {
                buffer.append(", ");
            }
            buffer.append(cursor.key);
            buffer.append("=>");
            buffer.append(cursor.value);
            first = false;
        }
        buffer.append("]");
        return buffer.toString();
    }

    public static ShortFloatOpenHashMap from(short[] keys, float[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        ShortFloatOpenHashMap map = new ShortFloatOpenHashMap();
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }

    public static ShortFloatOpenHashMap from(ShortFloatAssociativeContainer container) {
        return new ShortFloatOpenHashMap(container);
    }

    public static ShortFloatOpenHashMap newInstance() {
        return new ShortFloatOpenHashMap();
    }

    public static ShortFloatOpenHashMap newInstance(int initialCapacity, float loadFactor) {
        return new ShortFloatOpenHashMap(initialCapacity, loadFactor);
    }

    private final class ValuesIterator
    extends AbstractIterator<FloatCursor> {
        private final FloatCursor cursor = new FloatCursor();

        public ValuesIterator() {
            this.cursor.index = -1;
        }

        @Override
        protected FloatCursor fetch() {
            int i;
            int max = ShortFloatOpenHashMap.this.keys.length;
            for (i = this.cursor.index + 1; i < max && !ShortFloatOpenHashMap.this.allocated[i]; ++i) {
            }
            if (i == max) {
                return (FloatCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.value = ShortFloatOpenHashMap.this.values[i];
            return this.cursor;
        }
    }

    private final class ValuesContainer
    extends AbstractFloatCollection {
        private ValuesContainer() {
        }

        @Override
        public int size() {
            return ShortFloatOpenHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return ShortFloatOpenHashMap.this.isEmpty();
        }

        @Override
        public boolean contains(float value) {
            boolean[] allocated = ShortFloatOpenHashMap.this.allocated;
            float[] values = ShortFloatOpenHashMap.this.values;
            for (int slot = 0; slot < allocated.length; ++slot) {
                if (!allocated[slot] || value != values[slot]) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends FloatProcedure> T forEach(T procedure) {
            boolean[] allocated = ShortFloatOpenHashMap.this.allocated;
            float[] values = ShortFloatOpenHashMap.this.values;
            for (int i = 0; i < allocated.length; ++i) {
                if (!allocated[i]) continue;
                procedure.apply(values[i]);
            }
            return procedure;
        }

        @Override
        public <T extends FloatPredicate> T forEach(T predicate) {
            boolean[] allocated = ShortFloatOpenHashMap.this.allocated;
            float[] values = ShortFloatOpenHashMap.this.values;
            for (int i = 0; i < allocated.length && (!allocated[i] || predicate.apply(values[i])); ++i) {
            }
            return predicate;
        }

        @Override
        public Iterator<FloatCursor> iterator() {
            return new ValuesIterator();
        }

        @Override
        public int removeAllOccurrences(float e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int removeAll(FloatPredicate predicate) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }
    }

    private final class KeysIterator
    extends AbstractIterator<ShortCursor> {
        private final ShortCursor cursor = new ShortCursor();

        public KeysIterator() {
            this.cursor.index = -1;
        }

        @Override
        protected ShortCursor fetch() {
            int i;
            int max = ShortFloatOpenHashMap.this.keys.length;
            for (i = this.cursor.index + 1; i < max && !ShortFloatOpenHashMap.this.allocated[i]; ++i) {
            }
            if (i == max) {
                return (ShortCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.value = ShortFloatOpenHashMap.this.keys[i];
            return this.cursor;
        }
    }

    public final class KeysContainer
    extends AbstractShortCollection
    implements ShortLookupContainer {
        private final ShortFloatOpenHashMap owner;

        public KeysContainer() {
            this.owner = ShortFloatOpenHashMap.this;
        }

        @Override
        public boolean contains(short e) {
            return ShortFloatOpenHashMap.this.containsKey(e);
        }

        @Override
        public <T extends ShortProcedure> T forEach(T procedure) {
            short[] localKeys = this.owner.keys;
            boolean[] localStates = this.owner.allocated;
            for (int i = 0; i < localStates.length; ++i) {
                if (!localStates[i]) continue;
                procedure.apply(localKeys[i]);
            }
            return procedure;
        }

        @Override
        public <T extends ShortPredicate> T forEach(T predicate) {
            short[] localKeys = this.owner.keys;
            boolean[] localStates = this.owner.allocated;
            for (int i = 0; i < localStates.length && (!localStates[i] || predicate.apply(localKeys[i])); ++i) {
            }
            return predicate;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<ShortCursor> iterator() {
            return new KeysIterator();
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public int removeAll(ShortPredicate predicate) {
            return this.owner.removeAll(predicate);
        }

        @Override
        public int removeAllOccurrences(short e) {
            boolean hasKey = this.owner.containsKey(e);
            int result = 0;
            if (hasKey) {
                this.owner.remove(e);
                result = 1;
            }
            return result;
        }
    }

    private final class EntryIterator
    extends AbstractIterator<ShortFloatCursor> {
        private final ShortFloatCursor cursor = new ShortFloatCursor();

        public EntryIterator() {
            this.cursor.index = -1;
        }

        @Override
        protected ShortFloatCursor fetch() {
            int i;
            int max = ShortFloatOpenHashMap.this.keys.length;
            for (i = this.cursor.index + 1; i < max && !ShortFloatOpenHashMap.this.allocated[i]; ++i) {
            }
            if (i == max) {
                return (ShortFloatCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.key = ShortFloatOpenHashMap.this.keys[i];
            this.cursor.value = ShortFloatOpenHashMap.this.values[i];
            return this.cursor;
        }
    }
}

