/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractCharCollection;
import com.carrotsearch.hppc.AbstractDoubleCollection;
import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.CharContainer;
import com.carrotsearch.hppc.CharDoubleAssociativeContainer;
import com.carrotsearch.hppc.CharDoubleMap;
import com.carrotsearch.hppc.CharLookupContainer;
import com.carrotsearch.hppc.DoubleContainer;
import com.carrotsearch.hppc.HashContainerUtils;
import com.carrotsearch.hppc.Internals;
import com.carrotsearch.hppc.cursors.CharCursor;
import com.carrotsearch.hppc.cursors.CharDoubleCursor;
import com.carrotsearch.hppc.cursors.DoubleCursor;
import com.carrotsearch.hppc.predicates.CharPredicate;
import com.carrotsearch.hppc.predicates.DoublePredicate;
import com.carrotsearch.hppc.procedures.CharDoubleProcedure;
import com.carrotsearch.hppc.procedures.CharProcedure;
import com.carrotsearch.hppc.procedures.DoubleProcedure;
import java.util.Arrays;
import java.util.Iterator;

public class CharDoubleOpenHashMap
implements CharDoubleMap,
Cloneable {
    public static final int MIN_CAPACITY = 4;
    public static final int DEFAULT_CAPACITY = 16;
    public static final float DEFAULT_LOAD_FACTOR = 0.75f;
    public char[] keys;
    public double[] values;
    public boolean[] allocated;
    public int assigned;
    public final float loadFactor;
    private int resizeAt;
    private int lastSlot;

    public CharDoubleOpenHashMap() {
        this(16);
    }

    public CharDoubleOpenHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public CharDoubleOpenHashMap(int initialCapacity, float loadFactor) {
        initialCapacity = Math.max(initialCapacity, 4);
        assert (initialCapacity > 0) : "Initial capacity must be between (0, 2147483647].";
        assert (loadFactor > 0.0f && loadFactor <= 1.0f) : "Load factor must be between (0, 1].";
        this.loadFactor = loadFactor;
        this.allocateBuffers(HashContainerUtils.roundCapacity(initialCapacity));
    }

    public CharDoubleOpenHashMap(CharDoubleAssociativeContainer container) {
        this((int)((float)container.size() * 1.75f));
        this.putAll(container);
    }

    @Override
    public double put(char key, double value) {
        assert (this.assigned < this.allocated.length);
        int mask = this.allocated.length - 1;
        int slot = Internals.rehash(key) & mask;
        while (this.allocated[slot]) {
            if (key == this.keys[slot]) {
                double oldValue = this.values[slot];
                this.values[slot] = value;
                return oldValue;
            }
            slot = slot + 1 & mask;
        }
        if (this.assigned == this.resizeAt) {
            this.expandAndPut(key, value, slot);
        } else {
            ++this.assigned;
            this.allocated[slot] = true;
            this.keys[slot] = key;
            this.values[slot] = value;
        }
        return 0.0;
    }

    @Override
    public final int putAll(CharDoubleAssociativeContainer container) {
        int count = this.assigned;
        for (CharDoubleCursor c : container) {
            this.put(c.key, c.value);
        }
        return this.assigned - count;
    }

    @Override
    public final int putAll(Iterable<? extends CharDoubleCursor> iterable) {
        int count = this.assigned;
        for (CharDoubleCursor charDoubleCursor : iterable) {
            this.put(charDoubleCursor.key, charDoubleCursor.value);
        }
        return this.assigned - count;
    }

    public final boolean putIfAbsent(char key, double value) {
        if (!this.containsKey(key)) {
            this.put(key, value);
            return true;
        }
        return false;
    }

    public final double putOrAdd(char key, double putValue, double additionValue) {
        assert (this.assigned < this.allocated.length);
        int mask = this.allocated.length - 1;
        int slot = Internals.rehash(key) & mask;
        while (this.allocated[slot]) {
            if (key == this.keys[slot]) {
                this.values[slot] = this.values[slot] + additionValue;
                return this.values[slot];
            }
            slot = slot + 1 & mask;
        }
        if (this.assigned == this.resizeAt) {
            this.expandAndPut(key, putValue, slot);
        } else {
            ++this.assigned;
            this.allocated[slot] = true;
            this.keys[slot] = key;
            this.values[slot] = putValue;
        }
        return putValue;
    }

    private void expandAndPut(char pendingKey, double pendingValue, int freeSlot) {
        assert (this.assigned == this.resizeAt);
        assert (!this.allocated[freeSlot]);
        char[] oldKeys = this.keys;
        double[] oldValues = this.values;
        boolean[] oldAllocated = this.allocated;
        this.allocateBuffers(HashContainerUtils.nextCapacity(this.keys.length));
        this.lastSlot = -1;
        ++this.assigned;
        oldAllocated[freeSlot] = true;
        oldKeys[freeSlot] = pendingKey;
        oldValues[freeSlot] = pendingValue;
        char[] keys = this.keys;
        double[] values = this.values;
        boolean[] allocated = this.allocated;
        int mask = allocated.length - 1;
        int i = oldAllocated.length;
        while (--i >= 0) {
            if (!oldAllocated[i]) continue;
            char k = oldKeys[i];
            double v = oldValues[i];
            int slot = Internals.rehash(k) & mask;
            while (allocated[slot]) {
                slot = slot + 1 & mask;
            }
            allocated[slot] = true;
            keys[slot] = k;
            values[slot] = v;
        }
    }

    private void allocateBuffers(int capacity) {
        char[] keys = new char[capacity];
        double[] values = new double[capacity];
        boolean[] allocated = new boolean[capacity];
        this.keys = keys;
        this.values = values;
        this.allocated = allocated;
        this.resizeAt = Math.max(2, (int)Math.ceil((float)capacity * this.loadFactor)) - 1;
    }

    @Override
    public double remove(char key) {
        int slot;
        int mask = this.allocated.length - 1;
        int wrappedAround = slot = Internals.rehash(key) & mask;
        while (this.allocated[slot]) {
            if (key == this.keys[slot]) {
                --this.assigned;
                double v = this.values[slot];
                this.shiftConflictingKeys(slot);
                return v;
            }
            if ((slot = slot + 1 & mask) != wrappedAround) continue;
            break;
        }
        return 0.0;
    }

    protected final void shiftConflictingKeys(int slotCurr) {
        int mask = this.allocated.length - 1;
        while (true) {
            int slotPrev = slotCurr;
            slotCurr = slotPrev + 1 & mask;
            while (this.allocated[slotCurr]) {
                int slotOther = Internals.rehash(this.keys[slotCurr]) & mask;
                if (slotPrev <= slotCurr ? slotPrev >= slotOther || slotOther > slotCurr : slotPrev >= slotOther && slotOther > slotCurr) break;
                slotCurr = slotCurr + 1 & mask;
            }
            if (!this.allocated[slotCurr]) break;
            this.keys[slotPrev] = this.keys[slotCurr];
            this.values[slotPrev] = this.values[slotCurr];
        }
        this.allocated[slotPrev] = false;
    }

    @Override
    public final int removeAll(CharContainer container) {
        int before = this.assigned;
        for (CharCursor cursor : container) {
            this.remove(cursor.value);
        }
        return before - this.assigned;
    }

    @Override
    public final int removeAll(CharPredicate predicate) {
        int before = this.assigned;
        char[] keys = this.keys;
        boolean[] states = this.allocated;
        int i = 0;
        while (i < states.length) {
            if (states[i] && predicate.apply(keys[i])) {
                --this.assigned;
                this.shiftConflictingKeys(i);
                continue;
            }
            ++i;
        }
        return before - this.assigned;
    }

    @Override
    public double get(char key) {
        int slot;
        int mask = this.allocated.length - 1;
        int wrappedAround = slot = Internals.rehash(key) & mask;
        while (this.allocated[slot]) {
            if (key == this.keys[slot]) {
                return this.values[slot];
            }
            if ((slot = slot + 1 & mask) != wrappedAround) continue;
            break;
        }
        return 0.0;
    }

    public double lget() {
        assert (this.lastSlot >= 0) : "Call containsKey() first.";
        assert (this.allocated[this.lastSlot]) : "Last call to exists did not have any associated value.";
        return this.values[this.lastSlot];
    }

    public double lset(double key) {
        assert (this.lastSlot >= 0) : "Call containsKey() first.";
        assert (this.allocated[this.lastSlot]) : "Last call to exists did not have any associated value.";
        double previous = this.values[this.lastSlot];
        this.values[this.lastSlot] = key;
        return previous;
    }

    @Override
    public boolean containsKey(char key) {
        int slot;
        int mask = this.allocated.length - 1;
        int wrappedAround = slot = Internals.rehash(key) & mask;
        while (this.allocated[slot]) {
            if (key == this.keys[slot]) {
                this.lastSlot = slot;
                return true;
            }
            if ((slot = slot + 1 & mask) != wrappedAround) continue;
        }
        this.lastSlot = -1;
        return false;
    }

    @Override
    public void clear() {
        this.assigned = 0;
        Arrays.fill(this.allocated, false);
    }

    @Override
    public int size() {
        return this.assigned;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public int hashCode() {
        int h = 0;
        for (CharDoubleCursor c : this) {
            h += Internals.rehash(c.key) + Internals.rehash(c.value);
        }
        return h;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null) {
            CharDoubleMap other;
            if (obj == this) {
                return true;
            }
            if (obj instanceof CharDoubleMap && (other = (CharDoubleMap)obj).size() == this.size()) {
                for (CharDoubleCursor c : this) {
                    double v;
                    if (other.containsKey(c.key) && c.value == (v = other.get(c.key))) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public Iterator<CharDoubleCursor> iterator() {
        return new EntryIterator();
    }

    @Override
    public <T extends CharDoubleProcedure> T forEach(T procedure) {
        char[] keys = this.keys;
        double[] values = this.values;
        boolean[] states = this.allocated;
        for (int i = 0; i < states.length; ++i) {
            if (!states[i]) continue;
            procedure.apply(keys[i], values[i]);
        }
        return procedure;
    }

    @Override
    public KeysContainer keys() {
        return new KeysContainer();
    }

    @Override
    public DoubleContainer values() {
        return new ValuesContainer();
    }

    public CharDoubleOpenHashMap clone() {
        try {
            CharDoubleOpenHashMap cloned = (CharDoubleOpenHashMap)super.clone();
            cloned.keys = (char[])this.keys.clone();
            cloned.values = (double[])this.values.clone();
            cloned.allocated = (boolean[])this.allocated.clone();
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[");
        boolean first = true;
        for (CharDoubleCursor cursor : this) {
            if (!first) {
                buffer.append(", ");
            }
            buffer.append(cursor.key);
            buffer.append("=>");
            buffer.append(cursor.value);
            first = false;
        }
        buffer.append("]");
        return buffer.toString();
    }

    public static CharDoubleOpenHashMap from(char[] keys, double[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        CharDoubleOpenHashMap map = new CharDoubleOpenHashMap();
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }

    public static CharDoubleOpenHashMap from(CharDoubleAssociativeContainer container) {
        return new CharDoubleOpenHashMap(container);
    }

    public static CharDoubleOpenHashMap newInstance() {
        return new CharDoubleOpenHashMap();
    }

    public static CharDoubleOpenHashMap newInstance(int initialCapacity, float loadFactor) {
        return new CharDoubleOpenHashMap(initialCapacity, loadFactor);
    }

    private final class ValuesIterator
    extends AbstractIterator<DoubleCursor> {
        private final DoubleCursor cursor = new DoubleCursor();

        public ValuesIterator() {
            this.cursor.index = -1;
        }

        @Override
        protected DoubleCursor fetch() {
            int i;
            int max = CharDoubleOpenHashMap.this.keys.length;
            for (i = this.cursor.index + 1; i < max && !CharDoubleOpenHashMap.this.allocated[i]; ++i) {
            }
            if (i == max) {
                return (DoubleCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.value = CharDoubleOpenHashMap.this.values[i];
            return this.cursor;
        }
    }

    private final class ValuesContainer
    extends AbstractDoubleCollection {
        private ValuesContainer() {
        }

        @Override
        public int size() {
            return CharDoubleOpenHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return CharDoubleOpenHashMap.this.isEmpty();
        }

        @Override
        public boolean contains(double value) {
            boolean[] allocated = CharDoubleOpenHashMap.this.allocated;
            double[] values = CharDoubleOpenHashMap.this.values;
            for (int slot = 0; slot < allocated.length; ++slot) {
                if (!allocated[slot] || value != values[slot]) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends DoubleProcedure> T forEach(T procedure) {
            boolean[] allocated = CharDoubleOpenHashMap.this.allocated;
            double[] values = CharDoubleOpenHashMap.this.values;
            for (int i = 0; i < allocated.length; ++i) {
                if (!allocated[i]) continue;
                procedure.apply(values[i]);
            }
            return procedure;
        }

        @Override
        public <T extends DoublePredicate> T forEach(T predicate) {
            boolean[] allocated = CharDoubleOpenHashMap.this.allocated;
            double[] values = CharDoubleOpenHashMap.this.values;
            for (int i = 0; i < allocated.length && (!allocated[i] || predicate.apply(values[i])); ++i) {
            }
            return predicate;
        }

        @Override
        public Iterator<DoubleCursor> iterator() {
            return new ValuesIterator();
        }

        @Override
        public int removeAllOccurrences(double e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int removeAll(DoublePredicate predicate) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }
    }

    private final class KeysIterator
    extends AbstractIterator<CharCursor> {
        private final CharCursor cursor = new CharCursor();

        public KeysIterator() {
            this.cursor.index = -1;
        }

        @Override
        protected CharCursor fetch() {
            int i;
            int max = CharDoubleOpenHashMap.this.keys.length;
            for (i = this.cursor.index + 1; i < max && !CharDoubleOpenHashMap.this.allocated[i]; ++i) {
            }
            if (i == max) {
                return (CharCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.value = CharDoubleOpenHashMap.this.keys[i];
            return this.cursor;
        }
    }

    public final class KeysContainer
    extends AbstractCharCollection
    implements CharLookupContainer {
        private final CharDoubleOpenHashMap owner;

        public KeysContainer() {
            this.owner = CharDoubleOpenHashMap.this;
        }

        @Override
        public boolean contains(char e) {
            return CharDoubleOpenHashMap.this.containsKey(e);
        }

        @Override
        public <T extends CharProcedure> T forEach(T procedure) {
            char[] localKeys = this.owner.keys;
            boolean[] localStates = this.owner.allocated;
            for (int i = 0; i < localStates.length; ++i) {
                if (!localStates[i]) continue;
                procedure.apply(localKeys[i]);
            }
            return procedure;
        }

        @Override
        public <T extends CharPredicate> T forEach(T predicate) {
            char[] localKeys = this.owner.keys;
            boolean[] localStates = this.owner.allocated;
            for (int i = 0; i < localStates.length && (!localStates[i] || predicate.apply(localKeys[i])); ++i) {
            }
            return predicate;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<CharCursor> iterator() {
            return new KeysIterator();
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public int removeAll(CharPredicate predicate) {
            return this.owner.removeAll(predicate);
        }

        @Override
        public int removeAllOccurrences(char e) {
            boolean hasKey = this.owner.containsKey(e);
            int result = 0;
            if (hasKey) {
                this.owner.remove(e);
                result = 1;
            }
            return result;
        }
    }

    private final class EntryIterator
    extends AbstractIterator<CharDoubleCursor> {
        private final CharDoubleCursor cursor = new CharDoubleCursor();

        public EntryIterator() {
            this.cursor.index = -1;
        }

        @Override
        protected CharDoubleCursor fetch() {
            int i;
            int max = CharDoubleOpenHashMap.this.keys.length;
            for (i = this.cursor.index + 1; i < max && !CharDoubleOpenHashMap.this.allocated[i]; ++i) {
            }
            if (i == max) {
                return (CharDoubleCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.key = CharDoubleOpenHashMap.this.keys[i];
            this.cursor.value = CharDoubleOpenHashMap.this.values[i];
            return this.cursor;
        }
    }
}

