/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractByteCollection;
import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.ByteContainer;
import com.carrotsearch.hppc.ByteLookupContainer;
import com.carrotsearch.hppc.ByteSet;
import com.carrotsearch.hppc.HashContainerUtils;
import com.carrotsearch.hppc.Internals;
import com.carrotsearch.hppc.cursors.ByteCursor;
import com.carrotsearch.hppc.predicates.BytePredicate;
import com.carrotsearch.hppc.procedures.ByteProcedure;
import java.util.Arrays;
import java.util.Iterator;

public class ByteOpenHashSet
extends AbstractByteCollection
implements ByteLookupContainer,
ByteSet,
Cloneable {
    public static final int MIN_CAPACITY = 4;
    public static final int DEFAULT_CAPACITY = 16;
    public static final float DEFAULT_LOAD_FACTOR = 0.75f;
    public byte[] keys;
    public boolean[] allocated;
    public int assigned;
    public final float loadFactor;
    private int resizeAt;
    private int lastSlot;

    public ByteOpenHashSet() {
        this(16, 0.75f);
    }

    public ByteOpenHashSet(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public ByteOpenHashSet(int initialCapacity, float loadFactor) {
        initialCapacity = Math.max(initialCapacity, 4);
        assert (initialCapacity > 0) : "Initial capacity must be between (0, 2147483647].";
        assert (loadFactor > 0.0f && loadFactor <= 1.0f) : "Load factor must be between (0, 1].";
        this.loadFactor = loadFactor;
        this.allocateBuffers(HashContainerUtils.roundCapacity(initialCapacity));
    }

    public ByteOpenHashSet(ByteContainer container) {
        this((int)((float)container.size() * 1.75f));
        this.addAll(container);
    }

    @Override
    public boolean add(byte e) {
        assert (this.assigned < this.allocated.length);
        int mask = this.allocated.length - 1;
        int slot = Internals.rehash(e) & mask;
        while (this.allocated[slot]) {
            if (e == this.keys[slot]) {
                return false;
            }
            slot = slot + 1 & mask;
        }
        if (this.assigned == this.resizeAt) {
            this.expandAndAdd(e, slot);
        } else {
            ++this.assigned;
            this.allocated[slot] = true;
            this.keys[slot] = e;
        }
        return true;
    }

    public int add(byte e1, byte e2) {
        int count = 0;
        if (this.add(e1)) {
            ++count;
        }
        if (this.add(e2)) {
            ++count;
        }
        return count;
    }

    public int add(byte ... elements) {
        int count = 0;
        for (byte e : elements) {
            if (!this.add(e)) continue;
            ++count;
        }
        return count;
    }

    public final int addAll(ByteContainer container) {
        return this.addAll((Iterable<? extends ByteCursor>)container);
    }

    public final int addAll(Iterable<? extends ByteCursor> iterable) {
        int count = 0;
        for (ByteCursor byteCursor : iterable) {
            if (!this.add(byteCursor.value)) continue;
            ++count;
        }
        return count;
    }

    private void expandAndAdd(byte pendingKey, int freeSlot) {
        assert (this.assigned == this.resizeAt);
        assert (!this.allocated[freeSlot]);
        byte[] oldKeys = this.keys;
        boolean[] oldAllocated = this.allocated;
        this.allocateBuffers(HashContainerUtils.nextCapacity(this.keys.length));
        this.lastSlot = -1;
        ++this.assigned;
        oldAllocated[freeSlot] = true;
        oldKeys[freeSlot] = pendingKey;
        byte[] keys = this.keys;
        boolean[] allocated = this.allocated;
        int mask = allocated.length - 1;
        int i = oldAllocated.length;
        while (--i >= 0) {
            if (!oldAllocated[i]) continue;
            byte k = oldKeys[i];
            int slot = Internals.rehash(k) & mask;
            while (allocated[slot]) {
                slot = slot + 1 & mask;
            }
            allocated[slot] = true;
            keys[slot] = k;
        }
    }

    private void allocateBuffers(int capacity) {
        byte[] keys = new byte[capacity];
        boolean[] allocated = new boolean[capacity];
        this.keys = keys;
        this.allocated = allocated;
        this.resizeAt = Math.max(2, (int)Math.ceil((float)capacity * this.loadFactor)) - 1;
    }

    @Override
    public int removeAllOccurrences(byte key) {
        return this.remove(key) ? 1 : 0;
    }

    public boolean remove(byte key) {
        int mask = this.allocated.length - 1;
        int slot = Internals.rehash(key) & mask;
        while (this.allocated[slot]) {
            if (key == this.keys[slot]) {
                --this.assigned;
                this.shiftConflictingKeys(slot);
                return true;
            }
            slot = slot + 1 & mask;
        }
        return false;
    }

    protected final void shiftConflictingKeys(int slotCurr) {
        int mask = this.allocated.length - 1;
        while (true) {
            int slotPrev = slotCurr;
            slotCurr = slotPrev + 1 & mask;
            while (this.allocated[slotCurr]) {
                int slotOther = Internals.rehash(this.keys[slotCurr]) & mask;
                if (slotPrev <= slotCurr ? slotPrev >= slotOther || slotOther > slotCurr : slotPrev >= slotOther && slotOther > slotCurr) break;
                slotCurr = slotCurr + 1 & mask;
            }
            if (!this.allocated[slotCurr]) break;
            this.keys[slotPrev] = this.keys[slotCurr];
        }
        this.allocated[slotPrev] = false;
    }

    public byte lget() {
        assert (this.lastSlot >= 0) : "Call contains() first.";
        assert (this.allocated[this.lastSlot]) : "Last call to exists did not have any associated value.";
        return this.keys[this.lastSlot];
    }

    @Override
    public boolean contains(byte key) {
        int mask = this.allocated.length - 1;
        int slot = Internals.rehash(key) & mask;
        while (this.allocated[slot]) {
            if (key == this.keys[slot]) {
                this.lastSlot = slot;
                return true;
            }
            slot = slot + 1 & mask;
        }
        this.lastSlot = -1;
        return false;
    }

    @Override
    public void clear() {
        this.assigned = 0;
        Arrays.fill(this.allocated, false);
        Arrays.fill(this.keys, (byte)0);
    }

    @Override
    public int size() {
        return this.assigned;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public int hashCode() {
        int h = 0;
        byte[] keys = this.keys;
        boolean[] states = this.allocated;
        int i = states.length;
        while (--i >= 0) {
            if (!states[i]) continue;
            h += Internals.rehash(keys[i]);
        }
        return h;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null) {
            ByteSet other;
            if (obj == this) {
                return true;
            }
            if (obj instanceof ByteSet && (other = (ByteSet)obj).size() == this.size()) {
                for (ByteCursor c : this) {
                    if (other.contains(c.value)) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public Iterator<ByteCursor> iterator() {
        return new EntryIterator();
    }

    @Override
    public <T extends ByteProcedure> T forEach(T procedure) {
        byte[] keys = this.keys;
        boolean[] states = this.allocated;
        for (int i = 0; i < states.length; ++i) {
            if (!states[i]) continue;
            procedure.apply(keys[i]);
        }
        return procedure;
    }

    @Override
    public final byte[] toArray() {
        byte[] cloned = new byte[this.assigned];
        int j = 0;
        for (int i = 0; i < this.keys.length; ++i) {
            if (!this.allocated[i]) continue;
            cloned[j++] = this.keys[i];
        }
        return cloned;
    }

    public ByteOpenHashSet clone() {
        try {
            ByteOpenHashSet cloned = (ByteOpenHashSet)super.clone();
            cloned.keys = (byte[])this.keys.clone();
            cloned.allocated = (boolean[])this.allocated.clone();
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <T extends BytePredicate> T forEach(T predicate) {
        byte[] keys = this.keys;
        boolean[] states = this.allocated;
        for (int i = 0; i < states.length && (!states[i] || predicate.apply(keys[i])); ++i) {
        }
        return predicate;
    }

    @Override
    public int removeAll(BytePredicate predicate) {
        byte[] keys = this.keys;
        boolean[] allocated = this.allocated;
        int before = this.assigned;
        int i = 0;
        while (i < allocated.length) {
            if (allocated[i] && predicate.apply(keys[i])) {
                --this.assigned;
                this.shiftConflictingKeys(i);
                continue;
            }
            ++i;
        }
        return before - this.assigned;
    }

    public static ByteOpenHashSet from(byte ... elements) {
        ByteOpenHashSet set = new ByteOpenHashSet((int)((float)elements.length * 1.75f));
        set.add(elements);
        return set;
    }

    public static ByteOpenHashSet from(ByteContainer container) {
        return new ByteOpenHashSet(container);
    }

    public static ByteOpenHashSet newInstance() {
        return new ByteOpenHashSet();
    }

    public static ByteOpenHashSet newInstanceWithCapacity(int initialCapacity, float loadFactor) {
        return new ByteOpenHashSet(initialCapacity, loadFactor);
    }

    private final class EntryIterator
    extends AbstractIterator<ByteCursor> {
        private final ByteCursor cursor = new ByteCursor();

        public EntryIterator() {
            this.cursor.index = -1;
        }

        @Override
        protected ByteCursor fetch() {
            int i;
            int max = ByteOpenHashSet.this.keys.length;
            for (i = this.cursor.index + 1; i < ByteOpenHashSet.this.keys.length && !ByteOpenHashSet.this.allocated[i]; ++i) {
            }
            if (i == max) {
                return (ByteCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.value = ByteOpenHashSet.this.keys[i];
            return this.cursor;
        }
    }
}

